export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
  BinaryString: { input: string; output: string; }
  FormId: { input: string; output: string; }
  ISO8601Date: { input: string; output: string; }
  ISO8601DateTime: { input: string; output: string; }
  JSON: { input: any; output: any; }
  NonEmptyString: { input: string; output: string; }
  UriHttpString: { input: string; output: string; }
};

/** AI::Agents */
export type AiAgent = {
  __typename?: 'AIAgent';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Name of the AI Agent */
  name: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** AI Analytics Metadata type that returns related run ID and usage data if present */
export type AiAnalyticsMetadata = {
  __typename?: 'AIAnalyticsMetadata';
  /** Indicates if the summary is unread by the current user. */
  isUnread?: Maybe<Scalars['Boolean']['output']>;
  /** ID of the related AI::Analytics::Run. */
  run?: Maybe<AiAnalyticsRun>;
  /** AI analytics usage record. */
  usage?: Maybe<AiAnalyticsUsage>;
};

/** AI::Analytics::Run identifies an AI result that can be used for analytics purposes. */
export type AiAnalyticsRun = {
  __typename?: 'AIAnalyticsRun';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** The ticket related to this AI result. */
  relatedObject?: Maybe<Ticket>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** AI::Analytics::Usage records a usage of an AI result that can be used for analytics purposes. */
export type AiAnalyticsUsage = {
  __typename?: 'AIAnalyticsUsage';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  /** Indicates if the user has already provided feedback for this AI result. */
  userHasProvidedFeedback?: Maybe<Scalars['Boolean']['output']>;
};

/** Input for the AI analytics usage. */
export type AiAnalyticsUsageInput = {
  /** Usage comment on the AI result. */
  comment?: InputMaybe<Scalars['String']['input']>;
  /** Context data of the usage, e.g. approval status. */
  context?: InputMaybe<Scalars['JSON']['input']>;
  /** Usage rating of the AI result. */
  rating?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Autogenerated return type of AIAnalyticsUsage. */
export type AiAnalyticsUsagePayload = {
  __typename?: 'AIAnalyticsUsagePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** AI analytics usage record. */
  usage?: Maybe<AiAnalyticsUsage>;
};

/** Autogenerated return type of AIAssistanceTextToolsRun. */
export type AiAssistanceTextToolsRunPayload = {
  __typename?: 'AIAssistanceTextToolsRunPayload';
  /** Analytics metadata */
  analytics?: Maybe<AiAnalyticsMetadata>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Returned text */
  output?: Maybe<Scalars['String']['output']>;
};

/** AI::TextTool represents a tool that can be used to process text or HTML content using AI services. */
export type AiTextTool = {
  __typename?: 'AITextTool';
  active: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  groups?: Maybe<GroupConnection>;
  id: Scalars['ID']['output'];
  instruction: Scalars['String']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};


/** AI::TextTool represents a tool that can be used to process text or HTML content using AI services. */
export type AiTextToolGroupsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of AITextToolUpdates. */
export type AiTextToolUpdatesPayload = {
  __typename?: 'AITextToolUpdatesPayload';
  /** The group IDs from the updated AI text tool */
  groupIds?: Maybe<Array<Scalars['ID']['output']>>;
  /** The AI text tool ID that was removed */
  removeTextToolId?: Maybe<Scalars['ID']['output']>;
  /** AI text tool ID that was updated */
  textToolId?: Maybe<Scalars['ID']['output']>;
};

/** Objects used to build activity message */
export type ActivityMessageMetaObject = DataPrivacyTask | Group | Organization | Role | Ticket | TicketArticle | User;

/** A field which may contain one or more email or other addresses. */
export type AddressesField = {
  __typename?: 'AddressesField';
  /** If email addresses were found and parseable, this will hold the parsed result. */
  parsed?: Maybe<Array<EmailAddressParsed>>;
  /** Unparsed content of the addresses field. */
  raw: Scalars['String']['output'];
};

/** Autogenerated return type of AdminPasswordAuthSend. */
export type AdminPasswordAuthSendPayload = {
  __typename?: 'AdminPasswordAuthSendPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if sending the token was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of AdminPasswordAuthVerify. */
export type AdminPasswordAuthVerifyPayload = {
  __typename?: 'AdminPasswordAuthVerifyPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Login of the user */
  login?: Maybe<Scalars['String']['output']>;
};

/** Autogenerated return type of AppMaintenance. */
export type AppMaintenancePayload = {
  __typename?: 'AppMaintenancePayload';
  /** Maintenance type, may trigger actions in the front end */
  type?: Maybe<EnumAppMaintenanceType>;
};

/** Represents an error with the execution of an async job. */
export type AsyncExecutionError = {
  __typename?: 'AsyncExecutionError';
  exception: Scalars['String']['output'];
  message: Scalars['String']['output'];
};

/** Represents the attachment attributes to be used e.g. in ticket create/update. */
export type AttachmentInput = {
  /** The attached files. */
  files: Array<UploadFileInput>;
  /** FormID for the attached files. */
  formId: Scalars['FormId']['input'];
};

/** Authorization for an account linked to a user */
export type Authorization = {
  __typename?: 'Authorization';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['ID']['output'];
  provider: Scalars['String']['output'];
  uid: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  username?: Maybe<Scalars['String']['output']>;
};

/** Type that represents an autocomplete entry with a string value. */
export type AutocompleteSearchEntry = {
  __typename?: 'AutocompleteSearchEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  value: Scalars['String']['output'];
};

/** Type that represents an autocomplete entry with an external data source value. */
export type AutocompleteSearchExternalDataSourceEntry = {
  __typename?: 'AutocompleteSearchExternalDataSourceEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  value: Scalars['JSON']['output'];
};

/** Type that represents a generic autocomplete entry. */
export type AutocompleteSearchGenericEntry = {
  __typename?: 'AutocompleteSearchGenericEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  object: Item;
  value: Scalars['Int']['output'];
};

/** Input fields for generic autocomplete searches. */
export type AutocompleteSearchGenericInput = {
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Optionally restrict search certain models */
  onlyIn?: InputMaybe<Array<EnumSearchableModels>>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** The default fields for autocomplete searches. */
export type AutocompleteSearchInput = {
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Input fields for object attribute external data source autocomplete searches. */
export type AutocompleteSearchObjectAttributeExternalDataSourceInput = {
  /** Name of the object attribute */
  attributeName: Scalars['String']['input'];
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Object name of the object attribute, e.g. Ticket */
  object: EnumObjectManagerObjects;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
  /** Context data for the search url rendering, e.g. customer data. */
  templateRenderContext: TemplateRenderContextInput;
};

/** Type that represents an autocomplete organization entry. */
export type AutocompleteSearchOrganizationEntry = {
  __typename?: 'AutocompleteSearchOrganizationEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  organization: Organization;
  value: Scalars['Int']['output'];
};

/** Input fields for organization autocomplete searches. */
export type AutocompleteSearchOrganizationInput = {
  /** Customer ID to filter the organizations by */
  customerId?: InputMaybe<Scalars['ID']['input']>;
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Type that represents an autocomplete recipient entry. */
export type AutocompleteSearchRecipientEntry = {
  __typename?: 'AutocompleteSearchRecipientEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  user: User;
  value: Scalars['String']['output'];
};

/** Input fields for recipient autocomplete searches. */
export type AutocompleteSearchRecipientInput = {
  /** User contact type option, i.e. email or phone */
  contact?: InputMaybe<EnumUserContact>;
  /** Optional user ID to be filtered out from results */
  exceptInternalId?: InputMaybe<Scalars['Int']['input']>;
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Input fields for tag autocomplete searches. */
export type AutocompleteSearchTagInput = {
  /** Optional tags to be filtered out from results */
  exceptTags?: InputMaybe<Array<Scalars['String']['input']>>;
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Type that represents an autocomplete ticket entry. */
export type AutocompleteSearchTicketEntry = {
  __typename?: 'AutocompleteSearchTicketEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  ticket: Ticket;
  value: Scalars['String']['output'];
};

/** Input fields for ticket autocomplete searches. */
export type AutocompleteSearchTicketInput = {
  /** Optional ticket ID to be filtered out from results */
  exceptTicketInternalId?: InputMaybe<Scalars['Int']['input']>;
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Type that represents an autocomplete user entry. */
export type AutocompleteSearchUserEntry = {
  __typename?: 'AutocompleteSearchUserEntry';
  disabled?: Maybe<Scalars['Boolean']['output']>;
  heading?: Maybe<Scalars['String']['output']>;
  headingPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  icon?: Maybe<Scalars['String']['output']>;
  label: Scalars['String']['output'];
  labelPlaceholder?: Maybe<Array<Scalars['String']['output']>>;
  user: User;
  value: Scalars['Int']['output'];
};

/** Input fields for user autocomplete searches. */
export type AutocompleteSearchUserInput = {
  /** Optional user ID to be filtered out from results */
  exceptInternalId?: InputMaybe<Scalars['Int']['input']>;
  /** Limit for the amount of entries */
  limit?: InputMaybe<Scalars['Int']['input']>;
  /** Query from the autocomplete field */
  query: Scalars['String']['input'];
};

/** Avatar for users */
export type Avatar = {
  __typename?: 'Avatar';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  default: Scalars['Boolean']['output'];
  deletable: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  imageFull?: Maybe<Scalars['String']['output']>;
  imageHash?: Maybe<Scalars['String']['output']>;
  imageResize?: Maybe<Scalars['String']['output']>;
  initial: Scalars['Boolean']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** The fields for uploading a new avatar. */
export type AvatarInput = {
  /** The original image to use for the avatar. */
  original: UploadFileInput;
  /** The resized/cropped image to use for the avatar. */
  resized: UploadFileInput;
};

/** The connection type for Ticket. */
export type CachedTicketConnection = {
  __typename?: 'CachedTicketConnection';
  /** Signature that identifies the current collection state. This is always returned, even if the edges data is not because the signature is still the same. */
  collectionSignature: Scalars['String']['output'];
  /** A list of edges. */
  edges?: Maybe<Array<TicketEdge>>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** Event from ICS file */
export type CalendarIcsFileEvent = {
  __typename?: 'CalendarIcsFileEvent';
  attendees?: Maybe<Array<Scalars['String']['output']>>;
  description?: Maybe<Scalars['String']['output']>;
  endDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  location?: Maybe<Scalars['String']['output']>;
  organizer?: Maybe<Scalars['String']['output']>;
  startDate?: Maybe<Scalars['ISO8601DateTime']['output']>;
  title?: Maybe<Scalars['String']['output']>;
};

/** Channels */
export type Channel = {
  __typename?: 'Channel';
  active: Scalars['Boolean']['output'];
  area: Scalars['String']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  group?: Maybe<Group>;
  id: Scalars['ID']['output'];
  lastLogIn?: Maybe<Scalars['String']['output']>;
  lastLogOut?: Maybe<Scalars['String']['output']>;
  options?: Maybe<Scalars['JSON']['output']>;
  preferences?: Maybe<Scalars['JSON']['output']>;
  statusIn?: Maybe<Scalars['String']['output']>;
  statusOut?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Fields for a new email channel. */
export type ChannelEmailAddInput = {
  /** Sender email address for this channel */
  emailAddress: Scalars['String']['input'];
  /** Sender email realname for this channel */
  emailRealname: Scalars['String']['input'];
  /** Group for this channel */
  groupId?: InputMaybe<Scalars['ID']['input']>;
  /** Configuration to validate */
  inboundConfiguration: ChannelEmailInboundConfigurationInput;
  /** Configuration to validate */
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
};

/** Autogenerated return type of ChannelEmailAdd. */
export type ChannelEmailAddPayload = {
  __typename?: 'ChannelEmailAddPayload';
  /** The new channel object */
  channel?: Maybe<Channel>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Autogenerated return type of ChannelEmailGuessConfiguration. */
export type ChannelEmailGuessConfigurationPayload = {
  __typename?: 'ChannelEmailGuessConfigurationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Holds the guessed configurations. */
  result: ChannelEmailGuessConfigurationResult;
};

/** Result for channel configuration guessing. */
export type ChannelEmailGuessConfigurationResult = {
  __typename?: 'ChannelEmailGuessConfigurationResult';
  /** If present, the probing for inbound was successful */
  inboundConfiguration?: Maybe<ChannelEmailInboundConfiguration>;
  /** Inbound mailbox data */
  mailboxStats?: Maybe<ChannelEmailInboundMailboxStats>;
  /** If present, the probing for inbound was successful */
  outboundConfiguration?: Maybe<ChannelEmailOutboundConfiguration>;
};

/** Configuration for an inbound email channel. */
export type ChannelEmailInboundConfiguration = {
  __typename?: 'ChannelEmailInboundConfiguration';
  /** Protocol/adapter for this email channel */
  adapter: EnumChannelEmailInboundAdapter;
  /** IMAP Mailbox folder to fetch emails from */
  folder?: Maybe<Scalars['String']['output']>;
  /** Hostname for the email service to connect to */
  host?: Maybe<Scalars['String']['output']>;
  password?: Maybe<Scalars['String']['output']>;
  port?: Maybe<Scalars['Int']['output']>;
  ssl?: Maybe<EnumChannelEmailSsl>;
  /** Whether to perform SSL verification */
  sslVerify?: Maybe<Scalars['Boolean']['output']>;
  /** Username for the email service to connect with */
  user?: Maybe<Scalars['String']['output']>;
};

/** Configuration for an inbound email channel. */
export type ChannelEmailInboundConfigurationInput = {
  /** Protocol/adapter for this email channel */
  adapter: EnumChannelEmailInboundAdapter;
  /** Whether to perform the email import in archive mode */
  archive?: InputMaybe<Scalars['Boolean']['input']>;
  /** Import mails older than this date in archive mode */
  archiveBefore?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  /** Archive ticket target state internal ID */
  archiveStateId?: InputMaybe<Scalars['Int']['input']>;
  /** IMAP Mailbox folder to fetch emails from */
  folder?: InputMaybe<Scalars['String']['input']>;
  /** Hostname for the email service to connect to */
  host: Scalars['String']['input'];
  /** Whether messages should be kept on the IMAP server when fetching */
  keepOnServer?: InputMaybe<Scalars['Boolean']['input']>;
  /** Password for the email service to connect with */
  password: Scalars['String']['input'];
  /** Port for the email service to connect to */
  port: Scalars['Int']['input'];
  /** Whether to use TLS/SSL */
  ssl: EnumChannelEmailSsl;
  /** Whether to perform SSL verification */
  sslVerify?: InputMaybe<Scalars['Boolean']['input']>;
  /** Username for the email service to connect with */
  user: Scalars['String']['input'];
};

/** Inbound mailbox statistics. */
export type ChannelEmailInboundMailboxStats = {
  __typename?: 'ChannelEmailInboundMailboxStats';
  /** Number of content emails found during account probing. */
  contentMessages?: Maybe<Scalars['Int']['output']>;
};

/** Configuration for an outbound email channel. */
export type ChannelEmailOutboundConfiguration = {
  __typename?: 'ChannelEmailOutboundConfiguration';
  /** Protocol/adapter for this email channel */
  adapter: EnumChannelEmailOutboundAdapter;
  /** Hostname for the email service to connect to */
  host?: Maybe<Scalars['String']['output']>;
  password?: Maybe<Scalars['String']['output']>;
  port?: Maybe<Scalars['Int']['output']>;
  /** Whether to perform SSL verification */
  sslVerify?: Maybe<Scalars['Boolean']['output']>;
  /** Username for the email service to connect with */
  user?: Maybe<Scalars['String']['output']>;
};

/** Configuration for an outbound email channel. */
export type ChannelEmailOutboundConfigurationInput = {
  /** Protocol/adapter for this email channel */
  adapter: EnumChannelEmailOutboundAdapter;
  /** Hostname for the email service to connect to */
  host?: InputMaybe<Scalars['String']['input']>;
  /** Password for the email service to connect with */
  password?: InputMaybe<Scalars['String']['input']>;
  /** Port for the email service to connect to */
  port?: InputMaybe<Scalars['Int']['input']>;
  /** Whether to perform SSL verification */
  sslVerify?: InputMaybe<Scalars['Boolean']['input']>;
  /** Username for the email service to connect with */
  user?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of ChannelEmailSetNotificationConfiguration. */
export type ChannelEmailSetNotificationConfigurationPayload = {
  __typename?: 'ChannelEmailSetNotificationConfigurationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the operation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of ChannelEmailValidateConfigurationInbound. */
export type ChannelEmailValidateConfigurationInboundPayload = {
  __typename?: 'ChannelEmailValidateConfigurationInboundPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Inbound mailbox data */
  mailboxStats?: Maybe<ChannelEmailInboundMailboxStats>;
  /** Was the validation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of ChannelEmailValidateConfigurationOutbound. */
export type ChannelEmailValidateConfigurationOutboundPayload = {
  __typename?: 'ChannelEmailValidateConfigurationOutboundPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the validation successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of ChannelEmailValidateConfigurationRoundtrip. */
export type ChannelEmailValidateConfigurationRoundtripPayload = {
  __typename?: 'ChannelEmailValidateConfigurationRoundtripPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the validation successful? */
  success: Scalars['Boolean']['output'];
};

/** Ticket checklist */
export type Checklist = {
  __typename?: 'Checklist';
  complete: Scalars['Int']['output'];
  completed: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  incomplete: Scalars['Int']['output'];
  items: Array<ChecklistItem>;
  name?: Maybe<Scalars['String']['output']>;
  /** resolver for Rails' belongs_to relationship */
  ticket: Ticket;
  total: Scalars['Int']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Ticket checklist item */
export type ChecklistItem = {
  __typename?: 'ChecklistItem';
  checked: Scalars['Boolean']['output'];
  /** resolver for Rails' belongs_to relationship */
  checklist: Checklist;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  text: Scalars['String']['output'];
  ticketReference?: Maybe<TicketReference>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Checklist template */
export type ChecklistTemplate = {
  __typename?: 'ChecklistTemplate';
  active?: Maybe<Scalars['Boolean']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of ChecklistTemplateUpdates. */
export type ChecklistTemplateUpdatesPayload = {
  __typename?: 'ChecklistTemplateUpdatesPayload';
  /** Checklist templates */
  checklistTemplates?: Maybe<Array<ChecklistTemplate>>;
};

/** Autogenerated return type of ConfigUpdates. */
export type ConfigUpdatesPayload = {
  __typename?: 'ConfigUpdatesPayload';
  /** Updated setting */
  setting?: Maybe<KeyComplexValue>;
};

/** Data privacy task type */
export type DataPrivacyTask = {
  __typename?: 'DataPrivacyTask';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  deletableId?: Maybe<Scalars['Int']['output']>;
  deletableType?: Maybe<Scalars['String']['output']>;
  id: Scalars['ID']['output'];
  state?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** EmailAddress model instances */
export type EmailAddress = {
  __typename?: 'EmailAddress';
  active: Scalars['Boolean']['output'];
  /** resolver for Rails' belongs_to relationship */
  channel?: Maybe<Channel>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  email: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  preferences?: Maybe<Scalars['JSON']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Represents a parsed email address. */
export type EmailAddressParsed = {
  __typename?: 'EmailAddressParsed';
  /** Email address. */
  emailAddress?: Maybe<Scalars['String']['output']>;
  /** Is email added as system EmailAddress? */
  isSystemAddress: Scalars['Boolean']['output'];
  /** Display name + comment part of email (if any). */
  name?: Maybe<Scalars['String']['output']>;
};

/** Possible AfterAuth message types */
export enum EnumAfterAuthType {
  /** TwoFactorConfiguration */
  TwoFactorConfiguration = 'TwoFactorConfiguration'
}

/** Possible AppVersion messages */
export enum EnumAppMaintenanceType {
  /** A new version of the app is available. */
  AppVersion = 'app_version',
  /** The app configuration has changed. */
  ConfigChanged = 'config_changed',
  /** App is restarting. */
  RestartAuto = 'restart_auto',
  /** App needs a restart. */
  RestartManual = 'restart_manual'
}

/** Option to choose the appearance theme */
export enum EnumAppearanceTheme {
  /** Prefer color scheme as indicated by the operating system. */
  Auto = 'auto',
  /** A color scheme that uses light-colored elements on a dark background. */
  Dark = 'dark',
  /** A color scheme that uses dark-colored elements on a light background. */
  Light = 'light'
}

/** Available thirdparty authentication providers */
export enum EnumAuthenticationProvider {
  Facebook = 'facebook',
  Github = 'github',
  Gitlab = 'gitlab',
  GoogleOauth2 = 'google_oauth2',
  Linkedin = 'linkedin',
  MicrosoftOffice365 = 'microsoft_office365',
  OpenidConnect = 'openid_connect',
  Saml = 'saml',
  Sso = 'sso',
  Twitter = 'twitter',
  Weibo = 'weibo'
}

/** The channel area type */
export enum EnumChannelArea {
  EmailAccount = 'Email__Account',
  EmailNotification = 'Email__Notification',
  FacebookAccount = 'Facebook__Account',
  GoogleAccount = 'Google__Account',
  Microsoft365Account = 'Microsoft365__Account',
  MicrosoftGraphAccount = 'MicrosoftGraph__Account',
  SmsAccount = 'Sms__Account',
  SmsNotification = 'Sms__Notification',
  TelegramBot = 'Telegram__Bot',
  WhatsAppBusiness = 'WhatsApp__Business'
}

/** Inbound email protocols/adapters */
export enum EnumChannelEmailInboundAdapter {
  Imap = 'imap',
  Pop3 = 'pop3'
}

/** Outbound email protocols/adapters */
export enum EnumChannelEmailOutboundAdapter {
  Sendmail = 'sendmail',
  Smtp = 'smtp'
}

/** Possible values for email SSL/TLS transport security */
export enum EnumChannelEmailSsl {
  Off = 'off',
  Ssl = 'ssl',
  Starttls = 'starttls'
}

/** All available form updaters */
export enum EnumFormUpdaterId {
  FormUpdaterUpdaterGuidedSetupEmailArchive = 'FormUpdater__Updater__GuidedSetup__EmailArchive',
  FormUpdaterUpdaterGuidedSetupEmailInbound = 'FormUpdater__Updater__GuidedSetup__EmailInbound',
  FormUpdaterUpdaterGuidedSetupEmailNotification = 'FormUpdater__Updater__GuidedSetup__EmailNotification',
  FormUpdaterUpdaterGuidedSetupEmailOutbound = 'FormUpdater__Updater__GuidedSetup__EmailOutbound',
  FormUpdaterUpdaterOrganizationEdit = 'FormUpdater__Updater__Organization__Edit',
  FormUpdaterUpdaterTicketBulkEdit = 'FormUpdater__Updater__Ticket__BulkEdit',
  FormUpdaterUpdaterTicketCreate = 'FormUpdater__Updater__Ticket__Create',
  FormUpdaterUpdaterTicketEdit = 'FormUpdater__Updater__Ticket__Edit',
  FormUpdaterUpdaterTicketTimeAccounting = 'FormUpdater__Updater__Ticket__TimeAccounting',
  FormUpdaterUpdaterUserCreate = 'FormUpdater__Updater__User__Create',
  FormUpdaterUpdaterUserCurrentNewAccessToken = 'FormUpdater__Updater__User__Current__NewAccessToken',
  FormUpdaterUpdaterUserEdit = 'FormUpdater__Updater__User__Edit',
  FormUpdaterUpdaterUserInvite = 'FormUpdater__Updater__User__Invite',
  FormUpdaterUpdaterUserNotifications = 'FormUpdater__Updater__User__Notifications'
}

/** Link type */
export enum EnumLinkType {
  /** Target is child of source */
  Child = 'child',
  /** Equally related */
  Normal = 'normal',
  /** Target is parent of source */
  Parent = 'parent'
}

/** Available notification sound files */
export enum EnumNotificationSoundFile {
  Bell = 'Bell',
  Kalimba = 'Kalimba',
  Marimba = 'Marimba',
  Peep = 'Peep',
  Plop = 'Plop',
  Ring = 'Ring',
  Space = 'Space',
  Wood = 'Wood',
  Xylo = 'Xylo'
}

/** All backend managed objects */
export enum EnumObjectManagerObjects {
  Group = 'Group',
  Organization = 'Organization',
  Ticket = 'Ticket',
  TicketArticle = 'TicketArticle',
  User = 'User'
}

/** Option to choose SQL sorting direction */
export enum EnumOrderDirection {
  /** Sort with ascending order */
  Ascending = 'ASCENDING',
  /** Sort with descending order */
  Descending = 'DESCENDING'
}

/** Different user access levels */
export enum EnumPermissionAccess {
  Change = 'change',
  Create = 'create',
  Full = 'full',
  Overview = 'overview',
  Read = 'read'
}

/** All available public links screens */
export enum EnumPublicLinksScreen {
  Login = 'login',
  PasswordReset = 'password_reset',
  Signup = 'signup'
}

/** All searchable models */
export enum EnumSearchableModels {
  Organization = 'Organization',
  Ticket = 'Ticket',
  User = 'User'
}

/** Ticket article security options for email security methods */
export enum EnumSecurityOption {
  /** Encrypt article */
  Encryption = 'encryption',
  /** Sign article */
  Sign = 'sign'
}

/** Available email security methods */
export enum EnumSecurityStateType {
  /** PGP */
  Pgp = 'PGP',
  /** S/MIME */
  Smime = 'SMIME'
}

/** Third-party system source */
export enum EnumSystemImportSource {
  Freshdesk = 'freshdesk',
  Kayako = 'kayako',
  Otrs = 'otrs',
  Zendesk = 'zendesk'
}

/** Possible system setup status */
export enum EnumSystemSetupInfoStatus {
  Automated = 'automated',
  Done = 'done',
  InProgress = 'in_progress',
  New = 'new'
}

/** Possible system setup types */
export enum EnumSystemSetupInfoType {
  Auto = 'auto',
  Import = 'import',
  Manual = 'manual'
}

/** All taskbar app values */
export enum EnumTaskbarApp {
  Desktop = 'desktop',
  Mobile = 'mobile'
}

/** All taskbar entity values */
export enum EnumTaskbarEntity {
  OrganizationProfile = 'OrganizationProfile',
  Search = 'Search',
  TicketCreate = 'TicketCreate',
  TicketZoom = 'TicketZoom',
  UserProfile = 'UserProfile'
}

/** All taskbar entity access type values */
export enum EnumTaskbarEntityAccess {
  /** Access to this entity is forbidden */
  Forbidden = 'Forbidden',
  /** Access to this entity is granted */
  Granted = 'Granted',
  /** The entity could not be found */
  NotFound = 'NotFound'
}

/** Option to choose SQL sorting direction */
export enum EnumTextDirection {
  /** Left-to-right */
  Ltr = 'ltr',
  /** Right-to-left */
  Rtl = 'rtl'
}

/** Ticket article sender names */
export enum EnumTicketArticleSenderName {
  Agent = 'Agent',
  Customer = 'Customer',
  System = 'System'
}

/** Possible values for issue tracker item states */
export enum EnumTicketExternalReferencesIssueTrackerItemState {
  Closed = 'closed',
  Open = 'open'
}

/** Possible values for issue tracker type */
export enum EnumTicketExternalReferencesIssueTrackerType {
  /** GitHub */
  Github = 'github',
  /** GitLab */
  Gitlab = 'gitlab'
}

/** Option to choose the ticket screen behavior */
export enum EnumTicketScreenBehavior {
  /** Next in overview */
  CloseNextInOverview = 'closeNextInOverview',
  /** Close tab */
  CloseTab = 'closeTab',
  /** Close tab on ticket close */
  CloseTabOnTicketClose = 'closeTabOnTicketClose',
  /** Stay on tab */
  StayOnTab = 'stayOnTab'
}

/** Ticket state color code */
export enum EnumTicketStateColorCode {
  /** Closed. */
  Closed = 'closed',
  /** Requires urgent attention. */
  Escalating = 'escalating',
  /** Ready for action. */
  Open = 'open',
  /** Marked as pending; no immediate action required. */
  Pending = 'pending'
}

/** Ticket state color code */
export enum EnumTicketStateTypeCategory {
  ArchivableInto = 'archivable_into',
  Closed = 'closed',
  Merged = 'merged',
  Open = 'open',
  Pending = 'pending',
  PendingAction = 'pending_action',
  PendingReminder = 'pending_reminder',
  Resolved = 'resolved',
  Viewable = 'viewable',
  ViewableAgentEdit = 'viewable_agent_edit',
  ViewableAgentNew = 'viewable_agent_new',
  ViewableCustomerEdit = 'viewable_customer_edit',
  ViewableCustomerNew = 'viewable_customer_new',
  WorkOn = 'work_on',
  WorkOnAll = 'work_on_all'
}

/** Defines when the ticket summary should be generated */
export enum EnumTicketSummaryGeneration {
  /** Use global default setting. */
  GlobalDefault = 'global_default',
  /** On ticket detail opening */
  OnTicketDetailOpening = 'on_ticket_detail_opening',
  /** On ticket summary sidebar activation */
  OnTicketSummarySidebarActivation = 'on_ticket_summary_sidebar_activation'
}

/** Possible two factor authentication methods (availability depends on system configuration) */
export enum EnumTwoFactorAuthenticationMethod {
  /** Authenticator App */
  AuthenticatorApp = 'authenticator_app',
  /** Security Keys */
  SecurityKeys = 'security_keys'
}

/** User contact option */
export enum EnumUserContact {
  /** User email address */
  Email = 'email',
  /** User phone number */
  Phone = 'phone'
}

/** All user error exception values */
export enum EnumUserErrorException {
  ServiceTicketUpdateValidatorChecklistCompletedError = 'Service__Ticket__Update__Validator__ChecklistCompleted__Error',
  ServiceTicketUpdateValidatorTimeAccountingError = 'Service__Ticket__Update__Validator__TimeAccounting__Error'
}

/** Represents the form changed field information. */
export type FormUpdaterChangedFieldInput = {
  /** Changed field name */
  name: Scalars['String']['input'];
  /** New value from changed field */
  newValue?: InputMaybe<Scalars['JSON']['input']>;
  /** Old value from changed field */
  oldValue?: InputMaybe<Scalars['JSON']['input']>;
};

/** Represents the form meta information. */
export type FormUpdaterMetaInput = {
  /** Additional data for form updater */
  additionalData?: InputMaybe<Scalars['JSON']['input']>;
  /** Changed field information */
  changedField?: InputMaybe<FormUpdaterChangedFieldInput>;
  /** List of dirty fields */
  dirtyFields?: InputMaybe<Array<Scalars['String']['input']>>;
  /** Generated frontend form ID */
  formId: Scalars['FormId']['input'];
  /** Initial form updater request */
  initial?: InputMaybe<Scalars['Boolean']['input']>;
  /** Generated frontend request ID */
  requestId?: InputMaybe<Scalars['String']['input']>;
  /** After form reset form updater request */
  reset?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Represents the relation field information. */
export type FormUpdaterRelationField = {
  /** Optional filter ids from the frontend */
  filterIds?: InputMaybe<Array<Scalars['Int']['input']>>;
  /** Field name of the relation field */
  name: Scalars['String']['input'];
  /** Relation name for the current field (e.g. group) */
  relation: Scalars['String']['input'];
};

/** Holds the fields and flags information for an form updater resolver. */
export type FormUpdaterResult = {
  __typename?: 'FormUpdaterResult';
  fields: Scalars['JSON']['output'];
  flags: Scalars['JSON']['output'];
};

/** Autogenerated return type of FormUploadCacheAdd. */
export type FormUploadCacheAddPayload = {
  __typename?: 'FormUploadCacheAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Information about the uploaded files. */
  uploadedFiles: Array<StoredFile>;
};

/** Autogenerated return type of FormUploadCacheRemove. */
export type FormUploadCacheRemovePayload = {
  __typename?: 'FormUploadCacheRemovePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success: Scalars['Boolean']['output'];
};

/** Groups */
export type Group = {
  __typename?: 'Group';
  active: Scalars['Boolean']['output'];
  assignmentTimeout?: Maybe<Scalars['Int']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  emailAddress?: Maybe<EmailAddressParsed>;
  followUpAssignment?: Maybe<Scalars['Boolean']['output']>;
  followUpPossible?: Maybe<Scalars['String']['output']>;
  id: Scalars['ID']['output'];
  name?: Maybe<Scalars['String']['output']>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  sharedDrafts?: Maybe<Scalars['Boolean']['output']>;
  /** Ticket summary generation behavior for this group */
  summaryGeneration?: Maybe<EnumTicketSummaryGeneration>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** The connection type for Group. */
export type GroupConnection = {
  __typename?: 'GroupConnection';
  /** A list of edges. */
  edges: Array<GroupEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type GroupEdge = {
  __typename?: 'GroupEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: Group;
};

/** Autogenerated return type of GuidedSetupSetSystemInformation. */
export type GuidedSetupSetSystemInformationPayload = {
  __typename?: 'GuidedSetupSetSystemInformationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** System setup information updated successfully? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** History record */
export type HistoryGroup = {
  __typename?: 'HistoryGroup';
  /** Date and time of the history record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** Records of the history record */
  records: Array<HistoryRecord>;
};

/** History record */
export type HistoryRecord = {
  __typename?: 'HistoryRecord';
  /** Events of the history record */
  events: Array<HistoryRecordEvent>;
  /** User or system service who created the history record */
  issuer: HistoryRecordIssuer;
};

/** History record event */
export type HistoryRecordEvent = {
  __typename?: 'HistoryRecordEvent';
  /** Action of the event */
  action: Scalars['String']['output'];
  /** Attribute of the event */
  attribute?: Maybe<Scalars['String']['output']>;
  /** Changes of the event */
  changes?: Maybe<Scalars['JSON']['output']>;
  /** Date and time of the event */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** Object of the event */
  object: HistoryRecordEventObject;
};

/** History record event object */
export type HistoryRecordEventObject = Checklist | ChecklistItem | Group | Mention | ObjectClass | Organization | Ticket | TicketArticle | TicketSharedDraftZoom | User;

/** History record issuer */
export type HistoryRecordIssuer = AiAgent | Job | Macro | ObjectClass | PostmasterFilter | Trigger | User;

/** Import job information */
export type ImportJob = {
  __typename?: 'ImportJob';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  finishedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  result?: Maybe<Scalars['JSON']['output']>;
  startedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Objects found by search */
export type Item = Organization | Ticket | User;

/** Jobs */
export type Job = {
  __typename?: 'Job';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Name of the job */
  name: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Key/value type with complex (JSON) values. */
export type KeyComplexValue = {
  __typename?: 'KeyComplexValue';
  key: Scalars['String']['output'];
  value?: Maybe<Scalars['JSON']['output']>;
};

/** Key/value type with string values. */
export type KeyValue = {
  __typename?: 'KeyValue';
  key: Scalars['String']['output'];
  value?: Maybe<Scalars['String']['output']>;
};

/** Knowledge Base */
export type KnowledgeBase = {
  __typename?: 'KnowledgeBase';
  active: Scalars['Boolean']['output'];
  categoryLayout: Scalars['String']['output'];
  colorHeader: Scalars['String']['output'];
  colorHeaderLink: Scalars['String']['output'];
  colorHighlight: Scalars['String']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  customAddress?: Maybe<Scalars['String']['output']>;
  homepageLayout: Scalars['String']['output'];
  iconset: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** Knowledge Base Answer */
export type KnowledgeBaseAnswer = {
  __typename?: 'KnowledgeBaseAnswer';
  archivedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** resolver for Rails' belongs_to relationship */
  archivedBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  category: KnowledgeBaseCategory;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  internalAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** resolver for Rails' belongs_to relationship */
  internalBy?: Maybe<User>;
  internalNote?: Maybe<Scalars['String']['output']>;
  position: Scalars['Int']['output'];
  promoted?: Maybe<Scalars['Boolean']['output']>;
  publishedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** resolver for Rails' belongs_to relationship */
  publishedBy?: Maybe<User>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of KnowledgeBaseAnswerSuggestionContentTransform. */
export type KnowledgeBaseAnswerSuggestionContentTransformPayload = {
  __typename?: 'KnowledgeBaseAnswerSuggestionContentTransformPayload';
  /** Attachments of the answer */
  attachments?: Maybe<Array<StoredFile>>;
  /** Answer translation content */
  body?: Maybe<Scalars['String']['output']>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Knowledge Base Answer Translation */
export type KnowledgeBaseAnswerTranslation = {
  __typename?: 'KnowledgeBaseAnswerTranslation';
  /** resolver for Rails' belongs_to relationship */
  answer: KnowledgeBaseAnswer;
  categoryTreeTranslation: Array<KnowledgeBaseCategoryTranslation>;
  /** resolver for Rails' belongs_to relationship */
  content: KnowledgeBaseAnswerTranslationContent;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  kbLocale: KnowledgeBaseLocale;
  /** Specified only for knowledge bases with multiple locales */
  maybeLocale?: Maybe<Scalars['String']['output']>;
  title: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Knowledge Base Answer Translation Content */
export type KnowledgeBaseAnswerTranslationContent = {
  __typename?: 'KnowledgeBaseAnswerTranslationContent';
  body?: Maybe<Scalars['String']['output']>;
  bodyPrepared?: Maybe<Scalars['String']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  hasAttachments: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** Knowledge Base Category */
export type KnowledgeBaseCategory = {
  __typename?: 'KnowledgeBaseCategory';
  categoryIcon: Scalars['String']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  knowledgeBase: KnowledgeBase;
  /** resolver for Rails' belongs_to relationship */
  parent?: Maybe<KnowledgeBaseCategory>;
  position: Scalars['Int']['output'];
  translations: Array<KnowledgeBaseCategoryTranslation>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** Knowledge Base Category Translation */
export type KnowledgeBaseCategoryTranslation = {
  __typename?: 'KnowledgeBaseCategoryTranslation';
  /** resolver for Rails' belongs_to relationship */
  category: KnowledgeBaseCategory;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  kbLocale: KnowledgeBaseLocale;
  title: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** Knowledge Base Locale */
export type KnowledgeBaseLocale = {
  __typename?: 'KnowledgeBaseLocale';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  knowledgeBase: KnowledgeBase;
  primary: Scalars['Boolean']['output'];
  /** resolver for Rails' belongs_to relationship */
  systemLocale: Locale;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** Links between objects */
export type Link = {
  __typename?: 'Link';
  item: LinkObject;
  type: EnumLinkType;
};

/** Autogenerated return type of LinkAdd. */
export type LinkAddPayload = {
  __typename?: 'LinkAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created link */
  link?: Maybe<Link>;
};

/** Link input */
export type LinkInput = {
  /** Source object ID */
  sourceId: Scalars['ID']['input'];
  /** Target object ID */
  targetId: Scalars['ID']['input'];
  /** Link type */
  type: EnumLinkType;
};

/** Linkable objects */
export type LinkObject = KnowledgeBaseAnswerTranslation | Ticket;

/** Autogenerated return type of LinkRemove. */
export type LinkRemovePayload = {
  __typename?: 'LinkRemovePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of LinkUpdates. */
export type LinkUpdatesPayload = {
  __typename?: 'LinkUpdatesPayload';
  /** Link records */
  links?: Maybe<Array<Link>>;
};

/** Locales available in the system */
export type Locale = {
  __typename?: 'Locale';
  active: Scalars['Boolean']['output'];
  alias?: Maybe<Scalars['String']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  dir: EnumTextDirection;
  id: Scalars['ID']['output'];
  locale: Scalars['String']['output'];
  name: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** The user login fields. */
export type LoginInput = {
  /** User name */
  login: Scalars['String']['input'];
  /** Password */
  password: Scalars['String']['input'];
  /** Remember me - Session expire date will be set to one year */
  rememberMe?: InputMaybe<Scalars['Boolean']['input']>;
  /** Two factor authentication */
  twoFactorAuthentication?: InputMaybe<TwoFactorAuthenticationInput>;
  /** Two factor recovery */
  twoFactorRecovery?: InputMaybe<TwoFactorRecoveryInput>;
};

/** Autogenerated return type of Login. */
export type LoginPayload = {
  __typename?: 'LoginPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The current session, if the login was successful. */
  session?: Maybe<Session>;
  /** Two factor authentication methods available for the user about to log-in. */
  twoFactorRequired?: Maybe<UserLoginTwoFactorMethods>;
};

/** Autogenerated return type of Logout. */
export type LogoutPayload = {
  __typename?: 'LogoutPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** External logout URL (e.g. for SAML)? */
  externalLogoutUrl?: Maybe<Scalars['String']['output']>;
  /** Was the logout successful? */
  success: Scalars['Boolean']['output'];
};

/** Returns a list of macros */
export type Macro = {
  __typename?: 'Macro';
  active: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  perform: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  uxFlowNextUp: Scalars['String']['output'];
};

/** Autogenerated return type of MacrosUpdate. */
export type MacrosUpdatePayload = {
  __typename?: 'MacrosUpdatePayload';
  /** The group IDs from the updated macro */
  groupIds?: Maybe<Array<Scalars['ID']['output']>>;
  /** Macro ID that was updated */
  macroId?: Maybe<Scalars['ID']['output']>;
  /** The macro ID that was removed */
  removeMacroId?: Maybe<Scalars['ID']['output']>;
};

/** Mention */
export type Mention = {
  __typename?: 'Mention';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  mentionable: Ticket;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  user: User;
  userTicketAccess: PolicyMentionUserTicketAccess;
};

/** The connection type for Mention. */
export type MentionConnection = {
  __typename?: 'MentionConnection';
  /** A list of edges. */
  edges: Array<MentionEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type MentionEdge = {
  __typename?: 'MentionEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: Mention;
};

/** Autogenerated return type of MentionSubscribe. */
export type MentionSubscribePayload = {
  __typename?: 'MentionSubscribePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of MentionUnsubscribe. */
export type MentionUnsubscribePayload = {
  __typename?: 'MentionUnsubscribePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** All available mutations */
export type Mutations = {
  __typename?: 'Mutations';
  /** Sends an email with a token to login via password. */
  adminPasswordAuthSend?: Maybe<AdminPasswordAuthSendPayload>;
  /** Verify admin password authentication */
  adminPasswordAuthVerify?: Maybe<AdminPasswordAuthVerifyPayload>;
  /** Record usage of an AI result for purposes of analytics */
  aiAnalyticsUsage?: Maybe<AiAnalyticsUsagePayload>;
  /** Run an AI text tool service on the supplied text or HTML content */
  aiAssistanceTextToolsRun?: Maybe<AiAssistanceTextToolsRunPayload>;
  /** Create a new email channel. This does not perform email validation. */
  channelEmailAdd?: Maybe<ChannelEmailAddPayload>;
  /** Try to guess email channel configuration from user credentials */
  channelEmailGuessConfiguration?: Maybe<ChannelEmailGuessConfigurationPayload>;
  /** Set confioguration for sending system notification emails */
  channelEmailSetNotificationConfiguration?: Maybe<ChannelEmailSetNotificationConfigurationPayload>;
  /** Validate an inbound email channel configuration by trying to fetch email */
  channelEmailValidateConfigurationInbound?: Maybe<ChannelEmailValidateConfigurationInboundPayload>;
  /** Validate an outbound email channel configuration by sending a test email */
  channelEmailValidateConfigurationOutbound?: Maybe<ChannelEmailValidateConfigurationOutboundPayload>;
  /** Validate an email channel configuration first sending and then fetching that same mail */
  channelEmailValidateConfigurationRoundtrip?: Maybe<ChannelEmailValidateConfigurationRoundtripPayload>;
  /** Upload files for a form */
  formUploadCacheAdd?: Maybe<FormUploadCacheAddPayload>;
  /** Remove uploaded files for a form */
  formUploadCacheRemove?: Maybe<FormUploadCacheRemovePayload>;
  /** Sets basic system information */
  guidedSetupSetSystemInformation?: Maybe<GuidedSetupSetSystemInformationPayload>;
  /** Transform the content of a knowledge base answer suggestion to be usable in the frontend */
  knowledgeBaseAnswerSuggestionContentTransform?: Maybe<KnowledgeBaseAnswerSuggestionContentTransformPayload>;
  /** Add a link between objects */
  linkAdd?: Maybe<LinkAddPayload>;
  /** Remove link between objects */
  linkRemove?: Maybe<LinkRemovePayload>;
  /** Performs a user login to create a session */
  login?: Maybe<LoginPayload>;
  /** End the current session */
  logout?: Maybe<LogoutPayload>;
  /** Subscribe to updates to an object. */
  mentionSubscribe?: Maybe<MentionSubscribePayload>;
  /** Unsubscribe from updates to an object. */
  mentionUnsubscribe?: Maybe<MentionUnsubscribePayload>;
  /** Marks notifications for active user as seen */
  onlineNotificationDelete?: Maybe<OnlineNotificationDeletePayload>;
  /** Marks notifications for active user as seen */
  onlineNotificationMarkAllAsSeen?: Maybe<OnlineNotificationMarkAllAsSeenPayload>;
  /** Mark an online notification as seen */
  onlineNotificationSeen?: Maybe<OnlineNotificationSeenPayload>;
  /** Update organization data. */
  organizationUpdate?: Maybe<OrganizationUpdatePayload>;
  /** Verify and apply third-party system import configuration */
  systemImportConfiguration?: Maybe<SystemImportConfigurationPayload>;
  /** Start the system import process */
  systemImportStart?: Maybe<SystemImportStartPayload>;
  /** Lock critical section, system setup. */
  systemSetupLock?: Maybe<SystemSetupLockPayload>;
  /** Executes the auto wizard for automated system set-up. */
  systemSetupRunAutoWizard?: Maybe<SystemSetupRunAutoWizardPayload>;
  /** Unlock critical section, system setup. */
  systemSetupUnlock?: Maybe<SystemSetupUnlockPayload>;
  /** Assign a tag to an object. This will create tags as needed. */
  tagAssignmentAdd?: Maybe<TagAssignmentAddPayload>;
  /** Removes a tag from an object. */
  tagAssignmentRemove?: Maybe<TagAssignmentRemovePayload>;
  /** Update tags of an object. This will create tags as needed. */
  tagAssignmentUpdate?: Maybe<TagAssignmentUpdatePayload>;
  /** Return current summary or trigger generation in the background */
  ticketAIAssistanceSummarize?: Maybe<TicketAiAssistanceSummarizePayload>;
  /** Change ticket article visibility from public to internal or vice versa */
  ticketArticleChangeVisibility?: Maybe<TicketArticleChangeVisibilityPayload>;
  /** Deletes ticket article if eligible */
  ticketArticleDelete?: Maybe<TicketArticleDeletePayload>;
  /** Prepare for a new forward or reply email article */
  ticketArticleEmailForwardReply?: Maybe<TicketArticleEmailForwardReplyPayload>;
  /** Retry an article's media download. */
  ticketArticleRetryMediaDownload?: Maybe<TicketArticleRetryMediaDownloadPayload>;
  /** Retry an article's security process. */
  ticketArticleRetrySecurityProcess?: Maybe<TicketArticleRetrySecurityProcessPayload>;
  /** Create an empty checklist or a checklist based on a template for a ticket. */
  ticketChecklistAdd?: Maybe<TicketChecklistAddPayload>;
  /** Delete a ticket checklist. */
  ticketChecklistDelete?: Maybe<TicketChecklistDeletePayload>;
  /** Delete a ticket checklist item. */
  ticketChecklistItemDelete?: Maybe<TicketChecklistItemDeletePayload>;
  /** Update order of the ticket checklist items. */
  ticketChecklistItemOrderUpdate?: Maybe<TicketChecklistItemOrderUpdatePayload>;
  /** Update or create a ticket checklist item. */
  ticketChecklistItemUpsert?: Maybe<TicketChecklistItemUpsertPayload>;
  /** Add checklist items. */
  ticketChecklistItemsAdd?: Maybe<TicketChecklistItemsAddPayload>;
  /** Update title of the ticket checklist. */
  ticketChecklistTitleUpdate?: Maybe<TicketChecklistTitleUpdatePayload>;
  /** Create a new ticket. */
  ticketCreate?: Maybe<TicketCreatePayload>;
  /** Update a ticket. */
  ticketCustomerUpdate?: Maybe<TicketCustomerUpdatePayload>;
  /** Add idoit objects to a ticket or just resolve them for ticket creation. */
  ticketExternalReferencesIdoitObjectAdd?: Maybe<TicketExternalReferencesIdoitObjectAddPayload>;
  /** Remove an idoit object from a ticket. */
  ticketExternalReferencesIdoitObjectRemove?: Maybe<TicketExternalReferencesIdoitObjectRemovePayload>;
  /** Add an issue tracker link to a ticket or just resolve it for ticket creation. */
  ticketExternalReferencesIssueTrackerItemAdd?: Maybe<TicketExternalReferencesIssueTrackerItemAddPayload>;
  /** Removes an issue tracker link from an ticket. */
  ticketExternalReferencesIssueTrackerItemRemove?: Maybe<TicketExternalReferencesIssueTrackerItemRemovePayload>;
  /** Deletes the desired live user entry. */
  ticketLiveUserDelete?: Maybe<TicketLiveUserDeletePayload>;
  /** Updates the current live user entry. If no matching live user entry is found, a new live user entry for the current user and ticket will be created. */
  ticketLiveUserUpsert?: Maybe<TicketLiveUserUpsertPayload>;
  /** Create a new ticket. */
  ticketMerge?: Maybe<TicketMergePayload>;
  /** Deletes ticket shared draft */
  ticketSharedDraftStartCreate?: Maybe<TicketSharedDraftStartCreatePayload>;
  /** Deletes ticket shared draft */
  ticketSharedDraftStartDelete?: Maybe<TicketSharedDraftStartDeletePayload>;
  /** Deletes ticket shared draft */
  ticketSharedDraftStartUpdate?: Maybe<TicketSharedDraftStartUpdatePayload>;
  /** Create ticket shared draft in detail view */
  ticketSharedDraftZoomCreate?: Maybe<TicketSharedDraftZoomCreatePayload>;
  /** Deletes ticket shared draft */
  ticketSharedDraftZoomDelete?: Maybe<TicketSharedDraftZoomDeletePayload>;
  /** Update ticket shared draft in detail view */
  ticketSharedDraftZoomUpdate?: Maybe<TicketSharedDraftZoomUpdatePayload>;
  /** Update a ticket. */
  ticketTitleUpdate?: Maybe<TicketTitleUpdatePayload>;
  /** Update a ticket. */
  ticketUpdate?: Maybe<TicketUpdatePayload>;
  /** Bulk-update tickets. */
  ticketUpdateBulk?: Maybe<TicketUpdateBulkPayload>;
  /** Fetches the initiation phase data for a two-factor authentication method. */
  twoFactorMethodInitiateAuthentication?: Maybe<TwoFactorMethodInitiateAuthenticationPayload>;
  /** Add a new user. */
  userAdd?: Maybe<UserAddPayload>;
  /** Add the first admin user during system set-up and log that user in. */
  userAddFirstAdmin?: Maybe<UserAddFirstAdminPayload>;
  /** Create a new user access token */
  userCurrentAccessTokenAdd?: Maybe<UserCurrentAccessTokenAddPayload>;
  /** Deletes user access token */
  userCurrentAccessTokenDelete?: Maybe<UserCurrentAccessTokenDeletePayload>;
  /** Update user profile appearance settings */
  userCurrentAppearance?: Maybe<UserCurrentAppearancePayload>;
  /** Add a new avatar for the currently logged in user. */
  userCurrentAvatarAdd?: Maybe<UserCurrentAvatarAddPayload>;
  /** Delete an existing avatar for the currently logged in user. */
  userCurrentAvatarDelete?: Maybe<UserCurrentAvatarDeletePayload>;
  /** Select avatar for the currently logged in user. */
  userCurrentAvatarSelect?: Maybe<UserCurrentAvatarSelectPayload>;
  /** Fetch calendar subscriptions settings */
  userCurrentCalendarSubscriptionUpdate?: Maybe<UserCurrentCalendarSubscriptionUpdatePayload>;
  /** Change user password. */
  userCurrentChangePassword?: Maybe<UserCurrentChangePasswordPayload>;
  /** Delete a user (session) device. */
  userCurrentDeviceDelete?: Maybe<UserCurrentDeviceDeletePayload>;
  /** Update the language of the currently logged in user */
  userCurrentLocale?: Maybe<UserCurrentLocalePayload>;
  /** Reset user notification settings */
  userCurrentNotificationPreferencesReset?: Maybe<UserCurrentNotificationPreferencesResetPayload>;
  /** Update user notification settings */
  userCurrentNotificationPreferencesUpdate?: Maybe<UserCurrentNotificationPreferencesUpdatePayload>;
  /** Update user profile out of office settings */
  userCurrentOutOfOffice?: Maybe<UserCurrentOutOfOfficePayload>;
  /** Reset the overview sorting for the current user */
  userCurrentOverviewResetOrder?: Maybe<UserCurrentOverviewResetOrderPayload>;
  /** Update the last used information of the current user in their user preferences */
  userCurrentOverviewUpdateLastUsed?: Maybe<UserCurrentOverviewUpdateLastUsedPayload>;
  /** Update the overview sorting for the current user */
  userCurrentOverviewUpdateOrder?: Maybe<UserCurrentOverviewUpdateOrderPayload>;
  /** Check your password */
  userCurrentPasswordCheck?: Maybe<UserCurrentPasswordCheckPayload>;
  /** Reset recent view records of the current user */
  userCurrentRecentViewReset?: Maybe<UserCurrentRecentViewResetPayload>;
  /** Remove a linked account of the current user's profile */
  userCurrentRemoveLinkedAccount?: Maybe<UserCurrentRemoveLinkedAccountPayload>;
  /** Create a taskbar item for the currently logged-in user. */
  userCurrentTaskbarItemAdd?: Maybe<UserCurrentTaskbarItemAddPayload>;
  /** Delete a taskbar item of the currently logged-in user */
  userCurrentTaskbarItemDelete?: Maybe<UserCurrentTaskbarItemDeletePayload>;
  /** Sort taskbar item list by priority. */
  userCurrentTaskbarItemListPrio?: Maybe<UserCurrentTaskbarItemListPrioPayload>;
  /** Update last_contact_at for a taskbar item of the currently logged-in user */
  userCurrentTaskbarItemTouchLastContact?: Maybe<UserCurrentTaskbarItemTouchLastContactPayload>;
  /** Update a taskbar item of the currently logged-in user */
  userCurrentTaskbarItemUpdate?: Maybe<UserCurrentTaskbarItemUpdatePayload>;
  /** Update user ticket screen behavior settings */
  userCurrentTicketScreenBehavior?: Maybe<UserCurrentTicketScreenBehaviorPayload>;
  /** Regenerates new two factor recovery codes */
  userCurrentTwoFactorRecoveryCodesGenerate?: Maybe<UserCurrentTwoFactorRecoveryCodesGeneratePayload>;
  /** Removes given two factor authentication method */
  userCurrentTwoFactorRemoveMethod?: Maybe<UserCurrentTwoFactorRemoveMethodPayload>;
  /** Removes given two factor authentication method */
  userCurrentTwoFactorRemoveMethodCredentials?: Maybe<UserCurrentTwoFactorRemoveMethodCredentialsPayload>;
  /** Sets given two factor authentication method as default */
  userCurrentTwoFactorSetDefaultMethod?: Maybe<UserCurrentTwoFactorSetDefaultMethodPayload>;
  /** Verifies two factor authentication method configuration. */
  userCurrentTwoFactorVerifyMethodConfiguration?: Maybe<UserCurrentTwoFactorVerifyMethodConfigurationPayload>;
  /** Send password reset link to the user. */
  userPasswordResetSend?: Maybe<UserPasswordResetSendPayload>;
  /** Update user password via reset token. */
  userPasswordResetUpdate?: Maybe<UserPasswordResetUpdatePayload>;
  /** Verify password reset token. */
  userPasswordResetVerify?: Maybe<UserPasswordResetVerifyPayload>;
  /** Sign-up / register user. */
  userSignup?: Maybe<UserSignupPayload>;
  /** Resend signup verification email. */
  userSignupResend?: Maybe<UserSignupResendPayload>;
  /** Verify a signed up user. */
  userSignupVerify?: Maybe<UserSignupVerifyPayload>;
  /** Update an existing user. */
  userUpdate?: Maybe<UserUpdatePayload>;
};


/** All available mutations */
export type MutationsAdminPasswordAuthSendArgs = {
  login: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsAdminPasswordAuthVerifyArgs = {
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsAiAnalyticsUsageArgs = {
  aiAnalyticsRunId: Scalars['ID']['input'];
  input?: InputMaybe<AiAnalyticsUsageInput>;
};


/** All available mutations */
export type MutationsAiAssistanceTextToolsRunArgs = {
  input: Scalars['String']['input'];
  templateRenderContext: TemplateRenderContextInput;
  textToolId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsChannelEmailAddArgs = {
  input: ChannelEmailAddInput;
};


/** All available mutations */
export type MutationsChannelEmailGuessConfigurationArgs = {
  emailAddress: Scalars['String']['input'];
  password: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsChannelEmailSetNotificationConfigurationArgs = {
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
};


/** All available mutations */
export type MutationsChannelEmailValidateConfigurationInboundArgs = {
  inboundConfiguration: ChannelEmailInboundConfigurationInput;
};


/** All available mutations */
export type MutationsChannelEmailValidateConfigurationOutboundArgs = {
  emailAddress: Scalars['String']['input'];
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
};


/** All available mutations */
export type MutationsChannelEmailValidateConfigurationRoundtripArgs = {
  emailAddress: Scalars['String']['input'];
  inboundConfiguration: ChannelEmailInboundConfigurationInput;
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
};


/** All available mutations */
export type MutationsFormUploadCacheAddArgs = {
  files: Array<UploadFileInput>;
  formId: Scalars['FormId']['input'];
};


/** All available mutations */
export type MutationsFormUploadCacheRemoveArgs = {
  fileIds: Array<Scalars['ID']['input']>;
  formId: Scalars['FormId']['input'];
};


/** All available mutations */
export type MutationsGuidedSetupSetSystemInformationArgs = {
  input: SystemInformation;
};


/** All available mutations */
export type MutationsKnowledgeBaseAnswerSuggestionContentTransformArgs = {
  formId: Scalars['FormId']['input'];
  translationId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsLinkAddArgs = {
  input: LinkInput;
};


/** All available mutations */
export type MutationsLinkRemoveArgs = {
  input: LinkInput;
};


/** All available mutations */
export type MutationsLoginArgs = {
  input: LoginInput;
};


/** All available mutations */
export type MutationsMentionSubscribeArgs = {
  objectId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsMentionUnsubscribeArgs = {
  objectId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsOnlineNotificationDeleteArgs = {
  onlineNotificationId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsOnlineNotificationMarkAllAsSeenArgs = {
  onlineNotificationIds: Array<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsOnlineNotificationSeenArgs = {
  objectId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsOrganizationUpdateArgs = {
  id: Scalars['ID']['input'];
  input: OrganizationInput;
};


/** All available mutations */
export type MutationsSystemImportConfigurationArgs = {
  configuration: SystemImportConfigurationInput;
};


/** All available mutations */
export type MutationsSystemSetupLockArgs = {
  ttl?: InputMaybe<Scalars['Int']['input']>;
};


/** All available mutations */
export type MutationsSystemSetupRunAutoWizardArgs = {
  token?: InputMaybe<Scalars['String']['input']>;
};


/** All available mutations */
export type MutationsSystemSetupUnlockArgs = {
  value: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsTagAssignmentAddArgs = {
  objectId: Scalars['ID']['input'];
  tag: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsTagAssignmentRemoveArgs = {
  objectId: Scalars['ID']['input'];
  tag: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsTagAssignmentUpdateArgs = {
  objectId: Scalars['ID']['input'];
  tags: Array<Scalars['String']['input']>;
};


/** All available mutations */
export type MutationsTicketAiAssistanceSummarizeArgs = {
  regenerationOfId?: InputMaybe<Scalars['ID']['input']>;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketArticleChangeVisibilityArgs = {
  articleId: Scalars['ID']['input'];
  internal: Scalars['Boolean']['input'];
};


/** All available mutations */
export type MutationsTicketArticleDeleteArgs = {
  articleId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketArticleEmailForwardReplyArgs = {
  articleId: Scalars['ID']['input'];
  formId: Scalars['FormId']['input'];
};


/** All available mutations */
export type MutationsTicketArticleRetryMediaDownloadArgs = {
  articleId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketArticleRetrySecurityProcessArgs = {
  articleId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketChecklistAddArgs = {
  createFirstItem?: InputMaybe<Scalars['Boolean']['input']>;
  templateId?: InputMaybe<Scalars['ID']['input']>;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketChecklistDeleteArgs = {
  checklistId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketChecklistItemDeleteArgs = {
  checklistId: Scalars['ID']['input'];
  checklistItemId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketChecklistItemOrderUpdateArgs = {
  checklistId: Scalars['ID']['input'];
  order: Array<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsTicketChecklistItemUpsertArgs = {
  checklistId: Scalars['ID']['input'];
  checklistItemId?: InputMaybe<Scalars['ID']['input']>;
  input: TicketChecklistItemInput;
};


/** All available mutations */
export type MutationsTicketChecklistItemsAddArgs = {
  checklistId: Scalars['ID']['input'];
  input: Array<TicketChecklistItemInput>;
};


/** All available mutations */
export type MutationsTicketChecklistTitleUpdateArgs = {
  checklistId: Scalars['ID']['input'];
  title?: InputMaybe<Scalars['String']['input']>;
};


/** All available mutations */
export type MutationsTicketCreateArgs = {
  input: TicketCreateInput;
};


/** All available mutations */
export type MutationsTicketCustomerUpdateArgs = {
  input: TicketCustomerUpdateInput;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketExternalReferencesIdoitObjectAddArgs = {
  idoitObjectIds: Array<Scalars['Int']['input']>;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsTicketExternalReferencesIdoitObjectRemoveArgs = {
  idoitObjectId: Scalars['Int']['input'];
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketExternalReferencesIssueTrackerItemAddArgs = {
  issueTrackerLink: Scalars['UriHttpString']['input'];
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsTicketExternalReferencesIssueTrackerItemRemoveArgs = {
  issueTrackerLink: Scalars['UriHttpString']['input'];
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketLiveUserDeleteArgs = {
  app: EnumTaskbarApp;
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketLiveUserUpsertArgs = {
  app: EnumTaskbarApp;
  editing: Scalars['Boolean']['input'];
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketMergeArgs = {
  sourceTicketId: Scalars['ID']['input'];
  targetTicketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketSharedDraftStartCreateArgs = {
  input: TicketSharedDraftStartInput;
  name: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsTicketSharedDraftStartDeleteArgs = {
  sharedDraftId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketSharedDraftStartUpdateArgs = {
  input: TicketSharedDraftStartInput;
  sharedDraftId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketSharedDraftZoomCreateArgs = {
  input: TicketSharedDraftZoomInput;
};


/** All available mutations */
export type MutationsTicketSharedDraftZoomDeleteArgs = {
  sharedDraftId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketSharedDraftZoomUpdateArgs = {
  input: TicketSharedDraftZoomInput;
  sharedDraftId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketTitleUpdateArgs = {
  input: TicketTitleUpdateInput;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketUpdateArgs = {
  input: TicketUpdateInput;
  meta?: InputMaybe<TicketUpdateMetaInput>;
  ticketId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsTicketUpdateBulkArgs = {
  input: TicketUpdateInput;
  macroId?: InputMaybe<Scalars['ID']['input']>;
  ticketIds: Array<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsTwoFactorMethodInitiateAuthenticationArgs = {
  login: Scalars['String']['input'];
  password: Scalars['String']['input'];
  twoFactorMethod: EnumTwoFactorAuthenticationMethod;
};


/** All available mutations */
export type MutationsUserAddArgs = {
  input: UserInput;
  sendInvite?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available mutations */
export type MutationsUserAddFirstAdminArgs = {
  input: UserSignupInput;
};


/** All available mutations */
export type MutationsUserCurrentAccessTokenAddArgs = {
  input: UserAccessTokenInput;
};


/** All available mutations */
export type MutationsUserCurrentAccessTokenDeleteArgs = {
  tokenId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentAppearanceArgs = {
  theme: EnumAppearanceTheme;
};


/** All available mutations */
export type MutationsUserCurrentAvatarAddArgs = {
  images: AvatarInput;
};


/** All available mutations */
export type MutationsUserCurrentAvatarDeleteArgs = {
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentAvatarSelectArgs = {
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentCalendarSubscriptionUpdateArgs = {
  input: UserCalendarSubscriptionsConfigInput;
};


/** All available mutations */
export type MutationsUserCurrentChangePasswordArgs = {
  currentPassword: Scalars['String']['input'];
  newPassword: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentDeviceDeleteArgs = {
  deviceId: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentLocaleArgs = {
  locale: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentNotificationPreferencesUpdateArgs = {
  groupIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  matrix: UserNotificationMatrixInput;
  sound: UserNotificationSoundInput;
};


/** All available mutations */
export type MutationsUserCurrentOutOfOfficeArgs = {
  input: OutOfOfficeInput;
};


/** All available mutations */
export type MutationsUserCurrentOverviewUpdateLastUsedArgs = {
  overviewsLastUsed: Array<UserCurrentOverviewLastUsed>;
};


/** All available mutations */
export type MutationsUserCurrentOverviewUpdateOrderArgs = {
  overviewIds: Array<Scalars['ID']['input']>;
};


/** All available mutations */
export type MutationsUserCurrentPasswordCheckArgs = {
  password: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentRemoveLinkedAccountArgs = {
  provider: EnumAuthenticationProvider;
  uid: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTaskbarItemAddArgs = {
  input: UserTaskbarItemInput;
};


/** All available mutations */
export type MutationsUserCurrentTaskbarItemDeleteArgs = {
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTaskbarItemListPrioArgs = {
  list: Array<UserTaskbarItemListPrioInput>;
};


/** All available mutations */
export type MutationsUserCurrentTaskbarItemTouchLastContactArgs = {
  id: Scalars['ID']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTaskbarItemUpdateArgs = {
  id: Scalars['ID']['input'];
  input: UserTaskbarItemInput;
};


/** All available mutations */
export type MutationsUserCurrentTicketScreenBehaviorArgs = {
  behavior: EnumTicketScreenBehavior;
};


/** All available mutations */
export type MutationsUserCurrentTwoFactorRecoveryCodesGenerateArgs = {
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTwoFactorRemoveMethodArgs = {
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTwoFactorRemoveMethodCredentialsArgs = {
  credentialId: Scalars['String']['input'];
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTwoFactorSetDefaultMethodArgs = {
  methodName: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserCurrentTwoFactorVerifyMethodConfigurationArgs = {
  configuration: Scalars['JSON']['input'];
  methodName: EnumTwoFactorAuthenticationMethod;
  payload: Scalars['JSON']['input'];
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserPasswordResetSendArgs = {
  username: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserPasswordResetUpdateArgs = {
  password: Scalars['String']['input'];
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserPasswordResetVerifyArgs = {
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserSignupArgs = {
  input: UserSignupInput;
};


/** All available mutations */
export type MutationsUserSignupResendArgs = {
  email: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserSignupVerifyArgs = {
  token: Scalars['String']['input'];
};


/** All available mutations */
export type MutationsUserUpdateArgs = {
  id: Scalars['ID']['input'];
  input: UserInput;
};

/** Data of one object attribute value of another object */
export type ObjectAttributeValue = {
  __typename?: 'ObjectAttributeValue';
  /** The object attribute record */
  attribute: ObjectManagerFrontendAttribute;
  /** Rendered version of link, if attribute has defined template */
  renderedLink?: Maybe<Scalars['String']['output']>;
  /** The value of the current object's object attribute */
  value?: Maybe<Scalars['JSON']['output']>;
};

/** Data of one object attribute value of another object */
export type ObjectAttributeValueInput = {
  /** The name of the current object's attribute */
  name: Scalars['String']['input'];
  /** The value of the current object's object attribute */
  value?: InputMaybe<Scalars['JSON']['input']>;
};

/** Custom object fields (only editable & active) */
export type ObjectAttributeValuesInterface = {
  objectAttributeValues?: Maybe<Array<ObjectAttributeValue>>;
};

/** Object class */
export type ObjectClass = {
  __typename?: 'ObjectClass';
  /** Info about the object class */
  info?: Maybe<Scalars['String']['output']>;
  /** Name of the object class */
  klass?: Maybe<Scalars['String']['output']>;
};

/** An object manager attribute record especially for the frontend */
export type ObjectManagerFrontendAttribute = {
  __typename?: 'ObjectManagerFrontendAttribute';
  dataOption?: Maybe<Scalars['JSON']['output']>;
  dataType: Scalars['String']['output'];
  display: Scalars['String']['output'];
  isInternal: Scalars['Boolean']['output'];
  name: Scalars['String']['output'];
  screens?: Maybe<Scalars['JSON']['output']>;
};

/** Autogenerated return type of ObjectManagerFrontendAttributes. */
export type ObjectManagerFrontendAttributesPayload = {
  __typename?: 'ObjectManagerFrontendAttributesPayload';
  /** Attributes to be shown in the frontend */
  attributes: Array<ObjectManagerFrontendAttribute>;
  /** Screens with attributes to be shown in the frontend */
  screens: Array<ObjectManagerScreenAttributes>;
};

/** Screens with underlying attributes. */
export type ObjectManagerScreenAttributes = {
  __typename?: 'ObjectManagerScreenAttributes';
  attributes: Array<Scalars['String']['output']>;
  name: Scalars['String']['output'];
};

/** Online notifications for a user */
export type OnlineNotification = {
  __typename?: 'OnlineNotification';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** resolver for Rails' belongs_to relationship */
  metaObject?: Maybe<ActivityMessageMetaObject>;
  /** resolver for Rails' has_one relationship */
  objectName: Scalars['String']['output'];
  seen: Scalars['Boolean']['output'];
  /** resolver for Rails' has_one relationship */
  typeName: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** The connection type for OnlineNotification. */
export type OnlineNotificationConnection = {
  __typename?: 'OnlineNotificationConnection';
  /** A list of edges. */
  edges: Array<OnlineNotificationEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** Autogenerated return type of OnlineNotificationDelete. */
export type OnlineNotificationDeletePayload = {
  __typename?: 'OnlineNotificationDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the notification deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** An edge in a connection. */
export type OnlineNotificationEdge = {
  __typename?: 'OnlineNotificationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: OnlineNotification;
};

/** Autogenerated return type of OnlineNotificationMarkAllAsSeen. */
export type OnlineNotificationMarkAllAsSeenPayload = {
  __typename?: 'OnlineNotificationMarkAllAsSeenPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The seen notifications. */
  onlineNotifications?: Maybe<Array<OnlineNotification>>;
};

/** Autogenerated return type of OnlineNotificationSeen. */
export type OnlineNotificationSeenPayload = {
  __typename?: 'OnlineNotificationSeenPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Did we successfully set the online notification to seen? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of OnlineNotificationsCount. */
export type OnlineNotificationsCountPayload = {
  __typename?: 'OnlineNotificationsCountPayload';
  /** Count of unseen notifications for the user */
  unseenCount: Scalars['Int']['output'];
};

/** Organizations that users can belong to */
export type Organization = ObjectAttributeValuesInterface & {
  __typename?: 'Organization';
  active?: Maybe<Scalars['Boolean']['output']>;
  /** All assigned users */
  allMembers?: Maybe<UserConnection>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  domain?: Maybe<Scalars['String']['output']>;
  domainAssignment?: Maybe<Scalars['Boolean']['output']>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Users assigned via primary organization */
  members?: Maybe<UserConnection>;
  name?: Maybe<Scalars['String']['output']>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  objectAttributeValues?: Maybe<Array<ObjectAttributeValue>>;
  policy: PolicyDefault;
  /** Users assigned via secondary organization */
  secondaryMembers?: Maybe<UserConnection>;
  shared?: Maybe<Scalars['Boolean']['output']>;
  ticketsCount?: Maybe<TicketCount>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  vip?: Maybe<Scalars['Boolean']['output']>;
};


/** Organizations that users can belong to */
export type OrganizationAllMembersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


/** Organizations that users can belong to */
export type OrganizationMembersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


/** Organizations that users can belong to */
export type OrganizationSecondaryMembersArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** The connection type for Organization. */
export type OrganizationConnection = {
  __typename?: 'OrganizationConnection';
  /** A list of edges. */
  edges: Array<OrganizationEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** An edge in a connection. */
export type OrganizationEdge = {
  __typename?: 'OrganizationEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: Organization;
};

/** The organization insert/update fields. */
export type OrganizationInput = {
  /** The organization active flag */
  active?: InputMaybe<Scalars['Boolean']['input']>;
  /** The organization domain */
  domain?: InputMaybe<Scalars['String']['input']>;
  /** The organization domain assignment flag */
  domainAssignment?: InputMaybe<Scalars['Boolean']['input']>;
  /** The organization name */
  name?: InputMaybe<Scalars['String']['input']>;
  /** The organization note */
  note?: InputMaybe<Scalars['String']['input']>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization shared flag */
  shared?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Autogenerated return type of OrganizationUpdate. */
export type OrganizationUpdatePayload = {
  __typename?: 'OrganizationUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated organization. */
  organization?: Maybe<Organization>;
};

/** Autogenerated return type of OrganizationUpdates. */
export type OrganizationUpdatesPayload = {
  __typename?: 'OrganizationUpdatesPayload';
  /** Updated organization */
  organization?: Maybe<Organization>;
};

/** Out of office information */
export type OutOfOfficeInput = {
  /** Out of office enabled? */
  enabled: Scalars['Boolean']['input'];
  /** Out of office date range */
  endAt?: InputMaybe<Scalars['ISO8601Date']['input']>;
  /** User ID of replacement */
  replacementId?: InputMaybe<Scalars['ID']['input']>;
  /** Out of office date range */
  startAt?: InputMaybe<Scalars['ISO8601Date']['input']>;
  /** Out of office message */
  text?: InputMaybe<Scalars['String']['input']>;
};

/** Ticket overviews */
export type Overview = {
  __typename?: 'Overview';
  active: Scalars['Boolean']['output'];
  /** Cached count of tickets the authenticated user may see in this overview */
  cachedTicketCount: Scalars['Int']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  groupBy?: Maybe<Scalars['String']['output']>;
  groupDirection?: Maybe<EnumOrderDirection>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  link: Scalars['String']['output'];
  name: Scalars['String']['output'];
  orderBy: Scalars['String']['output'];
  /** Columns that may be used as order_by of overview queries, with assigned label values */
  orderColumns: Array<KeyValue>;
  orderDirection: EnumOrderDirection;
  organizationShared?: Maybe<Scalars['Boolean']['output']>;
  outOfOffice?: Maybe<Scalars['Boolean']['output']>;
  prio: Scalars['Int']['output'];
  /** Count of tickets the authenticated user may see in this overview */
  ticketCount: Scalars['Int']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  /** Columns to be shown on screen, with assigned label values */
  viewColumns: Array<KeyValue>;
  /** Columns to be shown on screen, mapped to actual internal field IDs */
  viewColumnsRaw: Array<Scalars['String']['output']>;
};


/** Ticket overviews */
export type OverviewCachedTicketCountArgs = {
  cacheTtl: Scalars['Int']['input'];
};

/** Information about pagination in a connection. */
export type PageInfo = {
  __typename?: 'PageInfo';
  /** When paginating forwards, the cursor to continue. */
  endCursor?: Maybe<Scalars['String']['output']>;
  /** When paginating forwards, are there more items? */
  hasNextPage: Scalars['Boolean']['output'];
  /** When paginating backwards, are there more items? */
  hasPreviousPage: Scalars['Boolean']['output'];
  /** When paginating backwards, the cursor to continue. */
  startCursor?: Maybe<Scalars['String']['output']>;
};

/** Access Pundit policy queries for the current object and user. */
export type PolicyDefault = {
  __typename?: 'PolicyDefault';
  /** Is the user allowed to delete this object? */
  destroy: Scalars['Boolean']['output'];
  /** Is the user allowed to update this object? */
  update: Scalars['Boolean']['output'];
};

/** Check Pundit policy queries for the mentioned object and user. */
export type PolicyMentionUserTicketAccess = {
  __typename?: 'PolicyMentionUserTicketAccess';
  /** Does the user have agent-level read access to this ticket? */
  agentReadAccess: Scalars['Boolean']['output'];
  /** Does the user have agent-level update access to this ticket? */
  agentUpdateAccess: Scalars['Boolean']['output'];
  /** Is the user allowed to create user subscriptions for this ticket? */
  createMentions: Scalars['Boolean']['output'];
  /** Is the user allowed to delete this object? */
  destroy: Scalars['Boolean']['output'];
  /** Is the user allowed to create a follow-up for this ticket? */
  followUp: Scalars['Boolean']['output'];
  /** Is the user allowed to update this object? */
  update: Scalars['Boolean']['output'];
};

/** Access ticket specific Pundit policy queries for the current object and user. */
export type PolicyTicket = {
  __typename?: 'PolicyTicket';
  /** Does the user have agent-level read access to this ticket? */
  agentReadAccess: Scalars['Boolean']['output'];
  /** Does the user have agent-level update access to this ticket? */
  agentUpdateAccess: Scalars['Boolean']['output'];
  /** Is the user allowed to create user subscriptions for this ticket? */
  createMentions: Scalars['Boolean']['output'];
  /** Is the user allowed to delete this object? */
  destroy: Scalars['Boolean']['output'];
  /** Is the user allowed to create a follow-up for this ticket? */
  followUp: Scalars['Boolean']['output'];
  /** Is the user allowed to update this object? */
  update: Scalars['Boolean']['output'];
};

/** PostmasterFilters */
export type PostmasterFilter = {
  __typename?: 'PostmasterFilter';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Name of the postmaster filter */
  name: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Public links available in the system */
export type PublicLink = {
  __typename?: 'PublicLink';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  description?: Maybe<Scalars['String']['output']>;
  id: Scalars['ID']['output'];
  link: Scalars['String']['output'];
  newTab: Scalars['Boolean']['output'];
  title: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of PublicLinkUpdates. */
export type PublicLinkUpdatesPayload = {
  __typename?: 'PublicLinkUpdatesPayload';
  /** Current available public links */
  publicLinks?: Maybe<Array<PublicLink>>;
};

/** Autogenerated return type of PushMessages. */
export type PushMessagesPayload = {
  __typename?: 'PushMessagesPayload';
  /** Message text */
  text?: Maybe<Scalars['String']['output']>;
  /** Message title */
  title?: Maybe<Scalars['String']['output']>;
};

/** All available queries */
export type Queries = {
  __typename?: 'Queries';
  /** Get a list of available AI text tools */
  aiAssistanceTextToolsList: Array<AiTextTool>;
  /** Checksum of the currently built front-end application. If this changes, the front-end(s) should reload. */
  applicationBuildChecksum: Scalars['String']['output'];
  /** Configuration required for front end operation (more results returned for authenticated users) */
  applicationConfig: Array<KeyComplexValue>;
  /** Search for agents */
  autocompleteSearchAgent: Array<AutocompleteSearchUserEntry>;
  /** Generic autocomplete search */
  autocompleteSearchGeneric: Array<AutocompleteSearchGenericEntry>;
  /** Search for idoit object types */
  autocompleteSearchIdoitObjectTypes: Array<AutocompleteSearchEntry>;
  /** Search for values in object attributes for external data sources */
  autocompleteSearchObjectAttributeExternalDataSource: Array<AutocompleteSearchExternalDataSourceEntry>;
  /** Search for organizations */
  autocompleteSearchOrganization: Array<AutocompleteSearchOrganizationEntry>;
  /** Search for recipients */
  autocompleteSearchRecipient: Array<AutocompleteSearchRecipientEntry>;
  /** Search for tags */
  autocompleteSearchTag: Array<AutocompleteSearchEntry>;
  /** Search for tickets */
  autocompleteSearchTicket: Array<AutocompleteSearchTicketEntry>;
  /** Search for users */
  autocompleteSearchUser: Array<AutocompleteSearchUserEntry>;
  /** Fetch events from ICS file */
  calendarIcsFileEvents: Array<CalendarIcsFileEvent>;
  /** Fetch checklist templates */
  checklistTemplates: Array<ChecklistTemplate>;
  /** Information about the authenticated user */
  currentUser: User;
  /** EmailAddresses available in the system */
  emailAddresses: Array<EmailAddress>;
  /** Return updated form information for a frontend form (e.g. core workflow information or resolved relations). */
  formUpdater: FormUpdaterResult;
  /** Suggestions for insertable knowledge base answers in a new ticket article */
  knowledgeBaseAnswerSuggestions?: Maybe<Array<KnowledgeBaseAnswerTranslation>>;
  /** List linked objects */
  linkList?: Maybe<Array<Link>>;
  /** Locales available in the system */
  locales: Array<Locale>;
  /** Returns a list of macros */
  macros: Array<Macro>;
  /** Suggestions for mentionable users in a new ticket article */
  mentionSuggestions?: Maybe<Array<User>>;
  /** Fetch meta information about object manager attributes for usage in frontend. */
  objectManagerFrontendAttributes?: Maybe<ObjectManagerFrontendAttributesPayload>;
  /** Online notifications for a given user */
  onlineNotifications: OnlineNotificationConnection;
  /** Fetch an organization by ID */
  organization: Organization;
  /** Fetch the version of Zammad */
  productAbout: Scalars['String']['output'];
  /** Fetch public links */
  publicLinks?: Maybe<Array<PublicLink>>;
  /** Generic object search */
  search: SearchResult;
  /** Generic object search, finds only hit counts across models */
  searchCounts: Array<SearchCountsResult>;
  /** The sessionId of the currently authenticated user. */
  session: Session;
  /** Fetch system import state */
  systemImportState?: Maybe<ImportJob>;
  /** Get current system setup state */
  systemSetupInfo: SystemSetupInfo;
  /** Fetch ticket templates */
  templates: Array<Template>;
  /** Search for text modules and return them with variable interpolation */
  textModuleSuggestions: Array<TextModule>;
  /** Fetch a ticket by ID */
  ticket: Ticket;
  /** Fetch ticket articles by ticket ID */
  ticketArticles: TicketArticleConnection;
  /** Fetch ticket attachments by ticket ID */
  ticketAttachments: Array<StoredFile>;
  /** Fetch ticket checklist */
  ticketChecklist?: Maybe<Checklist>;
  /** Detailed idoit objects for the given idoit object ids or the given ticket */
  ticketExternalReferencesIdoitObjectList: Array<TicketExternalReferencesIdoitObject>;
  /** Search for idoit objects belonging to a selected type */
  ticketExternalReferencesIdoitObjectSearch: Array<TicketExternalReferencesIdoitObject>;
  /** Detailed issue tracker items for the given issue tracker links or the given ticket */
  ticketExternalReferencesIssueTrackerItemList: Array<TicketExternalReferencesIssueTrackerItem>;
  /** Fetch history of a ticket */
  ticketHistory: Array<HistoryGroup>;
  /** Ticket overviews available in the system */
  ticketOverviews: Array<Overview>;
  /** Ticket shared drafts available to start new ticket in a given group */
  ticketSharedDraftStartList: Array<TicketSharedDraftStart>;
  /** Ticket shared drafts available to start new ticket in a given group */
  ticketSharedDraftStartSingle: TicketSharedDraftStart;
  /** Get a single ticket shared draft in detail view */
  ticketSharedDraftZoomShow: TicketSharedDraftZoom;
  /** Fetch a ticket signature by group ID */
  ticketSignature?: Maybe<Signature>;
  /** Fetch tickets of a given ticket overview */
  ticketsByFilter: TicketConnection;
  /** Fetch tickets of a given ticket overview */
  ticketsByOverview: TicketConnection;
  /** Fetch tickets of a given ticket overview */
  ticketsCachedByOverview: CachedTicketConnection;
  /** Fetch recent customer tickets */
  ticketsRecentByCustomer: Array<Ticket>;
  /** Fetch tickets recently viewed by the current user */
  ticketsRecentlyViewed: Array<Ticket>;
  /** Translations for a given locale */
  translations?: Maybe<TranslationsPayload>;
  /** Fetch a user information by ID */
  user: User;
  /** Fetch current user access tokens */
  userCurrentAccessTokenList?: Maybe<Array<Token>>;
  /** Fetch actively used avatar of the currently logged-in user. */
  userCurrentAvatarActive?: Maybe<Avatar>;
  /** Fetch available avatar list of the currently logged-in user. */
  userCurrentAvatarList?: Maybe<Array<Avatar>>;
  /** Fetch calendar subscriptions settings */
  userCurrentCalendarSubscriptionList: UserPersonalSettingsCalendarSubscriptionsConfig;
  /** Fetch available device list of the currently logged-in user */
  userCurrentDeviceList?: Maybe<Array<UserDevice>>;
  /** Fetch tickets recently viewed by the current user */
  userCurrentRecentViewList: Array<RecentView>;
  /** Fetch available taskbar item list of the currently logged-in user */
  userCurrentTaskbarItemList?: Maybe<Array<UserTaskbarItem>>;
  /** Ticket overviews according to the personal sorting of the current user */
  userCurrentTicketOverviews: Array<Overview>;
  /** Fetch list of configured two factor authentication methods and . */
  userCurrentTwoFactorConfiguration: UserConfigurationTwoFactor;
  /** Fetch list of configured two factor authentication methods. */
  userCurrentTwoFactorGetMethodConfiguration?: Maybe<Scalars['JSON']['output']>;
  /** Fetch needed initial configuration data to initiate a authentication method configuration. */
  userCurrentTwoFactorInitiateMethodConfiguration: Scalars['JSON']['output'];
};


/** All available queries */
export type QueriesAiAssistanceTextToolsListArgs = {
  groupId?: InputMaybe<Scalars['ID']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};


/** All available queries */
export type QueriesAutocompleteSearchAgentArgs = {
  input: AutocompleteSearchUserInput;
};


/** All available queries */
export type QueriesAutocompleteSearchGenericArgs = {
  input: AutocompleteSearchGenericInput;
};


/** All available queries */
export type QueriesAutocompleteSearchIdoitObjectTypesArgs = {
  input: AutocompleteSearchInput;
};


/** All available queries */
export type QueriesAutocompleteSearchObjectAttributeExternalDataSourceArgs = {
  input: AutocompleteSearchObjectAttributeExternalDataSourceInput;
};


/** All available queries */
export type QueriesAutocompleteSearchOrganizationArgs = {
  input: AutocompleteSearchOrganizationInput;
};


/** All available queries */
export type QueriesAutocompleteSearchRecipientArgs = {
  input: AutocompleteSearchRecipientInput;
};


/** All available queries */
export type QueriesAutocompleteSearchTagArgs = {
  input: AutocompleteSearchTagInput;
};


/** All available queries */
export type QueriesAutocompleteSearchTicketArgs = {
  input: AutocompleteSearchTicketInput;
};


/** All available queries */
export type QueriesAutocompleteSearchUserArgs = {
  input: AutocompleteSearchUserInput;
};


/** All available queries */
export type QueriesCalendarIcsFileEventsArgs = {
  fileId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesChecklistTemplatesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available queries */
export type QueriesEmailAddressesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available queries */
export type QueriesFormUpdaterArgs = {
  data: Scalars['JSON']['input'];
  formUpdaterId: EnumFormUpdaterId;
  id?: InputMaybe<Scalars['ID']['input']>;
  meta: FormUpdaterMetaInput;
  relationFields: Array<FormUpdaterRelationField>;
};


/** All available queries */
export type QueriesKnowledgeBaseAnswerSuggestionsArgs = {
  query: Scalars['String']['input'];
};


/** All available queries */
export type QueriesLinkListArgs = {
  objectId: Scalars['ID']['input'];
  targetType: Scalars['String']['input'];
};


/** All available queries */
export type QueriesLocalesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available queries */
export type QueriesMacrosArgs = {
  groupIds: Array<Scalars['ID']['input']>;
};


/** All available queries */
export type QueriesMentionSuggestionsArgs = {
  groupId: Scalars['ID']['input'];
  query: Scalars['String']['input'];
};


/** All available queries */
export type QueriesObjectManagerFrontendAttributesArgs = {
  object: EnumObjectManagerObjects;
};


/** All available queries */
export type QueriesOnlineNotificationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


/** All available queries */
export type QueriesOrganizationArgs = {
  organizationId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesPublicLinksArgs = {
  screen: EnumPublicLinksScreen;
};


/** All available queries */
export type QueriesSearchArgs = {
  limit?: InputMaybe<Scalars['Int']['input']>;
  offset?: InputMaybe<Scalars['Int']['input']>;
  onlyIn: EnumSearchableModels;
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
  search: Scalars['String']['input'];
};


/** All available queries */
export type QueriesSearchCountsArgs = {
  onlyIn: Array<EnumSearchableModels>;
  search: Scalars['String']['input'];
};


/** All available queries */
export type QueriesTemplatesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available queries */
export type QueriesTextModuleSuggestionsArgs = {
  groupId?: InputMaybe<Scalars['ID']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  query: Scalars['String']['input'];
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};


/** All available queries */
export type QueriesTicketArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketArticlesArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  ticketId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketAttachmentsArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketChecklistArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketExternalReferencesIdoitObjectListArgs = {
  input: TicketExternalReferencesIdoitObjectListInput;
};


/** All available queries */
export type QueriesTicketExternalReferencesIdoitObjectSearchArgs = {
  idoitTypeId?: InputMaybe<Scalars['String']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  query?: InputMaybe<Scalars['String']['input']>;
};


/** All available queries */
export type QueriesTicketExternalReferencesIssueTrackerItemListArgs = {
  input: TicketExternalReferencesIssueTrackerListInput;
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
};


/** All available queries */
export type QueriesTicketHistoryArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketOverviewsArgs = {
  filterOverviewIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  ignoreUserConditions: Scalars['Boolean']['input'];
};


/** All available queries */
export type QueriesTicketSharedDraftStartListArgs = {
  groupId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketSharedDraftStartSingleArgs = {
  sharedDraftId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketSharedDraftZoomShowArgs = {
  sharedDraftId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketSignatureArgs = {
  groupId: Scalars['ID']['input'];
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};


/** All available queries */
export type QueriesTicketsByFilterArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  customerId?: InputMaybe<Scalars['ID']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  stateTypeCategory?: InputMaybe<EnumTicketStateTypeCategory>;
};


/** All available queries */
export type QueriesTicketsByOverviewArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
  overviewId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesTicketsCachedByOverviewArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  cacheTtl: Scalars['Int']['input'];
  first?: InputMaybe<Scalars['Int']['input']>;
  knownCollectionSignature?: InputMaybe<Scalars['String']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
  overviewId: Scalars['ID']['input'];
  renewCache?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available queries */
export type QueriesTicketsRecentByCustomerArgs = {
  customerId: Scalars['ID']['input'];
  exceptTicketInternalId?: InputMaybe<Scalars['Int']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
};


/** All available queries */
export type QueriesTicketsRecentlyViewedArgs = {
  exceptTicketInternalId?: InputMaybe<Scalars['Int']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
};


/** All available queries */
export type QueriesTranslationsArgs = {
  cacheKey?: InputMaybe<Scalars['String']['input']>;
  locale: Scalars['String']['input'];
};


/** All available queries */
export type QueriesUserArgs = {
  userId: Scalars['ID']['input'];
};


/** All available queries */
export type QueriesUserCurrentRecentViewListArgs = {
  limit?: InputMaybe<Scalars['Int']['input']>;
};


/** All available queries */
export type QueriesUserCurrentTaskbarItemListArgs = {
  app?: InputMaybe<EnumTaskbarApp>;
};


/** All available queries */
export type QueriesUserCurrentTicketOverviewsArgs = {
  ignoreUserConditions: Scalars['Boolean']['input'];
};


/** All available queries */
export type QueriesUserCurrentTwoFactorGetMethodConfigurationArgs = {
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
};


/** All available queries */
export type QueriesUserCurrentTwoFactorInitiateMethodConfigurationArgs = {
  methodName: EnumTwoFactorAuthenticationMethod;
  token: Scalars['String']['input'];
};

/** Objects recently viewed */
export type RecentView = Organization | Ticket | User;

/** Roles */
export type Role = {
  __typename?: 'Role';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name?: Maybe<Scalars['String']['output']>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Search count results */
export type SearchCountsResult = {
  __typename?: 'SearchCountsResult';
  /** Model that was searched in */
  model: EnumSearchableModels;
  /** Total count of found entries for the current model */
  totalCount: Scalars['Int']['output'];
};

/** Search result for one model */
export type SearchResult = {
  __typename?: 'SearchResult';
  /** Found items */
  items: Array<Item>;
  /** Total count of found entries across all pages */
  totalCount: Scalars['Int']['output'];
};

/** Session of the currently logged-in user */
export type Session = {
  __typename?: 'Session';
  afterAuth?: Maybe<SessionAfterAuth>;
  id: Scalars['String']['output'];
};

/** After-authorization information for front ends */
export type SessionAfterAuth = {
  __typename?: 'SessionAfterAuth';
  data?: Maybe<Scalars['JSON']['output']>;
  type: EnumAfterAuthType;
};

/** Signature */
export type Signature = {
  __typename?: 'Signature';
  active: Scalars['Boolean']['output'];
  body?: Maybe<Scalars['String']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  renderedBody?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};


/** Signature */
export type SignatureRenderedBodyArgs = {
  groupId?: InputMaybe<Scalars['ID']['input']>;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};

/** Represents a stored file. */
export type StoredFile = {
  __typename?: 'StoredFile';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** File name. */
  name: Scalars['String']['output'];
  preferences?: Maybe<Scalars['JSON']['output']>;
  /** File size in bytes */
  size?: Maybe<Scalars['Int']['output']>;
  /** File's content-type. */
  type?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
};

/** All available subscriptions */
export type Subscriptions = {
  __typename?: 'Subscriptions';
  /** Updated AI text tools */
  aiTextToolUpdates: AiTextToolUpdatesPayload;
  /** Application update/change events */
  appMaintenance: AppMaintenancePayload;
  /** Subscription for checklist template changes. */
  checklistTemplateUpdates: ChecklistTemplateUpdatesPayload;
  /** Updates to configuration settings */
  configUpdates: ConfigUpdatesPayload;
  /** Updates to link records */
  linkUpdates: LinkUpdatesPayload;
  /** Updated macros */
  macrosUpdate: MacrosUpdatePayload;
  /** Updates unseen notifications count */
  onlineNotificationsCount: OnlineNotificationsCountPayload;
  /** Updates to organization records */
  organizationUpdates: OrganizationUpdatesPayload;
  /** Updates to public links */
  publicLinkUpdates: PublicLinkUpdatesPayload;
  /** Broadcast messages to all users */
  pushMessages: PushMessagesPayload;
  /** Updates to ticket templates */
  templateUpdates: TemplateUpdatesPayload;
  /** Updates to triggered AI assistance summary */
  ticketAIAssistanceSummaryUpdates: TicketAiAssistanceSummaryUpdatesPayload;
  /** Changes to the list of ticket articles */
  ticketArticleUpdates: TicketArticleUpdatesPayload;
  /** Subscription for ticket checklist changes. */
  ticketChecklistUpdates: TicketChecklistUpdatesPayload;
  /** Updates to ticket live users (for agents). */
  ticketLiveUserUpdates: TicketLiveUserUpdatesPayload;
  /** Updates to overviews */
  ticketOverviewUpdates: TicketOverviewUpdatesPayload;
  /** Updates to ticket records */
  ticketSharedDraftStartUpdateByGroup: TicketSharedDraftStartUpdateByGroupPayload;
  /** Updates to ticket records */
  ticketUpdates: TicketUpdatesPayload;
  /** Updates to user access tokens */
  userCurrentAccessTokenUpdates: UserCurrentAccessTokenUpdatesPayload;
  /** Updates to account avatar records */
  userCurrentAvatarUpdates: UserCurrentAvatarUpdatesPayload;
  /** Updates to account devices records */
  userCurrentDevicesUpdates: UserCurrentDevicesUpdatesPayload;
  /** Updates to account overview sorting records */
  userCurrentOverviewOrderingUpdates: UserCurrentOverviewOrderingUpdatesPayload;
  /** Updates to the recently viewed items of the current user */
  userCurrentRecentViewUpdates: UserCurrentRecentViewUpdatesPayload;
  /** Subscription for taskbar item list priority changes */
  userCurrentTaskbarItemListUpdates: UserCurrentTaskbarItemListUpdatesPayload;
  /** Changes to the state of a taskbar item of the currently logged-in user */
  userCurrentTaskbarItemStateUpdates: UserCurrentTaskbarItemStateUpdatesPayload;
  /** Changes to the list of taskbar items of the currently logged-in user */
  userCurrentTaskbarItemUpdates: UserCurrentTaskbarItemUpdatesPayload;
  /** Updates to overviews according to the sorting of the current user */
  userCurrentTicketOverviewUpdates: UserCurrentTicketOverviewUpdatesPayload;
  /** Updates to current user two factor records */
  userCurrentTwoFactorUpdates: UserCurrentTwoFactorUpdatesPayload;
  /** Updates to user records */
  userUpdates: UserUpdatesPayload;
};


/** All available subscriptions */
export type SubscriptionsChecklistTemplateUpdatesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available subscriptions */
export type SubscriptionsLinkUpdatesArgs = {
  objectId: Scalars['ID']['input'];
  targetType: Scalars['String']['input'];
};


/** All available subscriptions */
export type SubscriptionsOrganizationUpdatesArgs = {
  organizationId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsPublicLinkUpdatesArgs = {
  screen: EnumPublicLinksScreen;
};


/** All available subscriptions */
export type SubscriptionsTemplateUpdatesArgs = {
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
};


/** All available subscriptions */
export type SubscriptionsTicketAiAssistanceSummaryUpdatesArgs = {
  locale: Scalars['String']['input'];
  ticketId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketArticleUpdatesArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketChecklistUpdatesArgs = {
  ticketId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketLiveUserUpdatesArgs = {
  app: EnumTaskbarApp;
  key: Scalars['String']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketOverviewUpdatesArgs = {
  ignoreUserConditions: Scalars['Boolean']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketSharedDraftStartUpdateByGroupArgs = {
  groupId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsTicketUpdatesArgs = {
  initial?: Scalars['Boolean']['input'];
  ticketId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsUserCurrentOverviewOrderingUpdatesArgs = {
  ignoreUserConditions: Scalars['Boolean']['input'];
};


/** All available subscriptions */
export type SubscriptionsUserCurrentTaskbarItemListUpdatesArgs = {
  app: EnumTaskbarApp;
};


/** All available subscriptions */
export type SubscriptionsUserCurrentTaskbarItemStateUpdatesArgs = {
  taskbarItemId: Scalars['ID']['input'];
};


/** All available subscriptions */
export type SubscriptionsUserCurrentTaskbarItemUpdatesArgs = {
  app: EnumTaskbarApp;
};


/** All available subscriptions */
export type SubscriptionsUserCurrentTicketOverviewUpdatesArgs = {
  ignoreUserConditions: Scalars['Boolean']['input'];
};


/** All available subscriptions */
export type SubscriptionsUserUpdatesArgs = {
  userId: Scalars['ID']['input'];
};

/** Third-party system configuration information */
export type SystemImportConfigurationInput = {
  /** Third-party system password/token */
  secret?: InputMaybe<Scalars['String']['input']>;
  /** Third-party system source */
  source: EnumSystemImportSource;
  /** Verify TLS certificate */
  tlsVerify?: InputMaybe<Scalars['Boolean']['input']>;
  /** Third-party system URL */
  url: Scalars['UriHttpString']['input'];
  /** Third-party system username */
  username?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of SystemImportConfiguration. */
export type SystemImportConfigurationPayload = {
  __typename?: 'SystemImportConfigurationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Is the configuration valid? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of SystemImportStart. */
export type SystemImportStartPayload = {
  __typename?: 'SystemImportStartPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the start successful? */
  success: Scalars['Boolean']['output'];
};

/** Basic system information */
export type SystemInformation = {
  /** Default system locale */
  localeDefault?: InputMaybe<Scalars['String']['input']>;
  /** Images to be uploaded. */
  logo?: InputMaybe<Scalars['BinaryString']['input']>;
  /** System name to display in the app */
  organization: Scalars['String']['input'];
  /** Default system time zone */
  timezoneDefault?: InputMaybe<Scalars['String']['input']>;
  /** System URL */
  url?: InputMaybe<Scalars['String']['input']>;
};

/** System setup state. */
export type SystemSetupInfo = {
  __typename?: 'SystemSetupInfo';
  /** System setup status. */
  status: EnumSystemSetupInfoStatus;
  /** System setup type. */
  type?: Maybe<EnumSystemSetupInfoType>;
};

/** Autogenerated return type of SystemSetupLock. */
export type SystemSetupLockPayload = {
  __typename?: 'SystemSetupLockPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Critical section resoure name. */
  resource?: Maybe<Scalars['String']['output']>;
  /** Critical section resoure value. */
  value?: Maybe<Scalars['String']['output']>;
};

/** Autogenerated return type of SystemSetupRunAutoWizard. */
export type SystemSetupRunAutoWizardPayload = {
  __typename?: 'SystemSetupRunAutoWizardPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The current session, if the auto wizard was successfully executed. */
  session?: Maybe<Session>;
};

/** Autogenerated return type of SystemSetupUnlock. */
export type SystemSetupUnlockPayload = {
  __typename?: 'SystemSetupUnlockPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Success. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TagAssignmentAdd. */
export type TagAssignmentAddPayload = {
  __typename?: 'TagAssignmentAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TagAssignmentRemove. */
export type TagAssignmentRemovePayload = {
  __typename?: 'TagAssignmentRemovePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TagAssignmentUpdate. */
export type TagAssignmentUpdatePayload = {
  __typename?: 'TagAssignmentUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Assigned tags */
export type TagsInterface = {
  tags?: Maybe<Array<Scalars['String']['output']>>;
};

/** Objects representing taskbar item entity */
export type TaskbarItemEntity = Organization | Ticket | User | UserTaskbarItemEntitySearch | UserTaskbarItemEntityTicketCreate;

/** Ticket template */
export type Template = {
  __typename?: 'Template';
  active?: Maybe<Scalars['Boolean']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  options?: Maybe<Scalars['JSON']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Context data for template rendering, e.g. customer data. */
export type TemplateRenderContextInput = {
  /** Ticket customer (if no ticket exists yet) */
  customerId?: InputMaybe<Scalars['ID']['input']>;
  /** Group */
  groupId?: InputMaybe<Scalars['ID']['input']>;
  /** Organization */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** Ticket */
  ticketId?: InputMaybe<Scalars['ID']['input']>;
  /** User (if not present the currently logged in user will be passed) */
  userId?: InputMaybe<Scalars['ID']['input']>;
};

/** Autogenerated return type of TemplateUpdates. */
export type TemplateUpdatesPayload = {
  __typename?: 'TemplateUpdatesPayload';
  /** Current ticket templates */
  templates?: Maybe<Array<Template>>;
};

/** Text modules */
export type TextModule = {
  __typename?: 'TextModule';
  active: Scalars['Boolean']['output'];
  content?: Maybe<Scalars['String']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  groups?: Maybe<GroupConnection>;
  id: Scalars['ID']['output'];
  keywords?: Maybe<Scalars['String']['output']>;
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  renderedContent?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};


/** Text modules */
export type TextModuleGroupsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};


/** Text modules */
export type TextModuleRenderedContentArgs = {
  templateRenderContext: TemplateRenderContextInput;
};

/** Tickets */
export type Ticket = ObjectAttributeValuesInterface & TagsInterface & {
  __typename?: 'Ticket';
  /** Returns true if an AI agent is running for this ticket */
  aiAgentRunning?: Maybe<Scalars['Boolean']['output']>;
  /** Count of ticket articles that were not sent by 'System'. */
  articleCount?: Maybe<Scalars['Int']['output']>;
  /** Returns the checklist of this ticket, if present */
  checklist?: Maybe<Checklist>;
  closeAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  closeDiffInMin?: Maybe<Scalars['Int']['output']>;
  closeEscalationAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  closeInMin?: Maybe<Scalars['Int']['output']>;
  /** resolver for Rails' belongs_to relationship */
  createArticleType?: Maybe<TicketArticleType>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  customer: User;
  escalationAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  /** Returns links to external services */
  externalReferences?: Maybe<TicketExternalReferences>;
  firstResponseAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  firstResponseDiffInMin?: Maybe<Scalars['Int']['output']>;
  firstResponseEscalationAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  firstResponseInMin?: Maybe<Scalars['Int']['output']>;
  /** resolver for Rails' belongs_to relationship */
  group: Group;
  id: Scalars['ID']['output'];
  /** The initial channel of the ticket. */
  initialChannel?: Maybe<EnumChannelArea>;
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  lastCloseAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  lastContactAgentAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  lastContactAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  lastContactCustomerAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  lastOwnerUpdateAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  mentions?: Maybe<MentionConnection>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  number: Scalars['String']['output'];
  objectAttributeValues?: Maybe<Array<ObjectAttributeValue>>;
  /** resolver for Rails' belongs_to relationship */
  organization?: Maybe<Organization>;
  /** resolver for Rails' belongs_to relationship */
  owner: User;
  pendingTime?: Maybe<Scalars['ISO8601DateTime']['output']>;
  policy: PolicyTicket;
  preferences?: Maybe<Scalars['JSON']['output']>;
  /** resolver for Rails' belongs_to relationship */
  priority: TicketPriority;
  /** Returns (only accessible) other tickets which reference the current ticket */
  referencingChecklistTickets?: Maybe<Array<Ticket>>;
  /** The Shared draft ID if the ticket has a shared draft. */
  sharedDraftZoomId?: Maybe<Scalars['ID']['output']>;
  /** resolver for Rails' belongs_to relationship */
  state: TicketState;
  /** Ticket color indicator state. */
  stateColorCode: EnumTicketStateColorCode;
  subscribed?: Maybe<Scalars['Boolean']['output']>;
  tags?: Maybe<Array<Scalars['String']['output']>>;
  timeUnit?: Maybe<Scalars['Float']['output']>;
  timeUnitsPerType?: Maybe<Array<TicketTimeAccountingTypeSum>>;
  title: Scalars['String']['output'];
  updateDiffInMin?: Maybe<Scalars['Int']['output']>;
  updateEscalationAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  updateInMin?: Maybe<Scalars['Int']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};


/** Tickets */
export type TicketMentionsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** Autogenerated return type of TicketAIAssistanceSummarize. */
export type TicketAiAssistanceSummarizePayload = {
  __typename?: 'TicketAIAssistanceSummarizePayload';
  /** Analytics metadata */
  analytics?: Maybe<AiAnalyticsMetadata>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Different parts of the generated summary */
  summary?: Maybe<TicketAiAssistanceSummary>;
};

/** The ticket summary */
export type TicketAiAssistanceSummary = {
  __typename?: 'TicketAIAssistanceSummary';
  conversationSummary?: Maybe<Scalars['String']['output']>;
  customerEmotion?: Maybe<Scalars['String']['output']>;
  customerMood?: Maybe<Scalars['String']['output']>;
  customerRequest?: Maybe<Scalars['String']['output']>;
  openQuestions?: Maybe<Array<Scalars['String']['output']>>;
  upcomingEvents?: Maybe<Array<Scalars['String']['output']>>;
};

/** Autogenerated return type of TicketAIAssistanceSummaryUpdates. */
export type TicketAiAssistanceSummaryUpdatesPayload = {
  __typename?: 'TicketAIAssistanceSummaryUpdatesPayload';
  /** Analytics metadata */
  analytics?: Maybe<AiAnalyticsMetadata>;
  /** Error that occurred during the execution of the async job */
  error?: Maybe<AsyncExecutionError>;
  /** Different parts of the generated summary */
  summary?: Maybe<TicketAiAssistanceSummary>;
};

/** Ticket articles */
export type TicketArticle = {
  __typename?: 'TicketArticle';
  /** All attached files as stored in the database. */
  attachments: Array<StoredFile>;
  /** Attachments for display, with inline images filtered out. */
  attachmentsWithoutInline: Array<StoredFile>;
  /** The originator (originBy, if any) or the creator of an article. */
  author: User;
  /** Raw body as saved in the database. */
  body: Scalars['String']['output'];
  /** Body with cid: URLs replaced for inline images in HTML articles. */
  bodyWithUrls: Scalars['String']['output'];
  cc?: Maybe<AddressesField>;
  contentType: Scalars['String']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  detectedLanguage?: Maybe<Scalars['String']['output']>;
  from?: Maybe<AddressesField>;
  id: Scalars['ID']['output'];
  inReplyTo?: Maybe<Scalars['String']['output']>;
  internal: Scalars['Boolean']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  mediaErrorState?: Maybe<TicketArticleMediaErrorState>;
  messageId?: Maybe<Scalars['String']['output']>;
  messageIdMd5?: Maybe<Scalars['String']['output']>;
  preferences?: Maybe<Scalars['JSON']['output']>;
  replyTo?: Maybe<AddressesField>;
  securityState?: Maybe<TicketArticleSecurityState>;
  /** resolver for Rails' belongs_to relationship */
  sender?: Maybe<TicketArticleSender>;
  subject?: Maybe<Scalars['String']['output']>;
  /** resolver for Rails' belongs_to relationship */
  ticket: Ticket;
  to?: Maybe<AddressesField>;
  /** resolver for Rails' belongs_to relationship */
  type?: Maybe<TicketArticleType>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of TicketArticleChangeVisibility. */
export type TicketArticleChangeVisibilityPayload = {
  __typename?: 'TicketArticleChangeVisibilityPayload';
  /** The updated ticket article */
  article?: Maybe<TicketArticle>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** The connection type for TicketArticle. */
export type TicketArticleConnection = {
  __typename?: 'TicketArticleConnection';
  /** A list of edges. */
  edges: Array<TicketArticleEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** Autogenerated return type of TicketArticleDelete. */
export type TicketArticleDeletePayload = {
  __typename?: 'TicketArticleDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the ticket article deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** An edge in a connection. */
export type TicketArticleEdge = {
  __typename?: 'TicketArticleEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: TicketArticle;
};

/** Autogenerated return type of TicketArticleEmailForwardReply. */
export type TicketArticleEmailForwardReplyPayload = {
  __typename?: 'TicketArticleEmailForwardReplyPayload';
  /** Cloned attachments for the new article. */
  attachments: Array<StoredFile>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** 'Cc' information of the original email to be inserted in the quoted email block */
  quotableCc?: Maybe<Scalars['String']['output']>;
  /** 'From' information of the original email to be inserted in the quoted email block */
  quotableFrom?: Maybe<Scalars['String']['output']>;
  /** 'To' information of the original email to be inserted in the quoted email block */
  quotableTo?: Maybe<Scalars['String']['output']>;
};

/** Represents the article attributes to be used in ticket create/update. */
export type TicketArticleInput = {
  /** The article accounted time activity type. */
  accountedTimeTypeId?: InputMaybe<Scalars['ID']['input']>;
  /** The article attachments. */
  attachments?: InputMaybe<AttachmentInput>;
  /** The article body. */
  body?: InputMaybe<Scalars['String']['input']>;
  /** The article CC address. */
  cc?: InputMaybe<Array<Scalars['String']['input']>>;
  /** The article content type. */
  contentType?: InputMaybe<Scalars['String']['input']>;
  /** The article sender address. */
  from?: InputMaybe<Scalars['String']['input']>;
  /** Message id of the article this article replies to. */
  inReplyTo?: InputMaybe<Scalars['String']['input']>;
  /** Whether the article is internal. */
  internal?: InputMaybe<Scalars['Boolean']['input']>;
  /** The article preferences. */
  preferences?: InputMaybe<Scalars['JSON']['input']>;
  /** The article security options. */
  security?: InputMaybe<TicketSecurityInput>;
  /** The article sender. */
  sender?: InputMaybe<Scalars['String']['input']>;
  /** The article subject. */
  subject?: InputMaybe<Scalars['String']['input']>;
  /** The article subtype. */
  subtype?: InputMaybe<Scalars['String']['input']>;
  /** The article accounted time. */
  timeUnit?: InputMaybe<Scalars['Float']['input']>;
  /** The article recipient address. */
  to?: InputMaybe<Array<Scalars['String']['input']>>;
  /** The article type. */
  type?: InputMaybe<Scalars['String']['input']>;
};

/** Ticket article media error information, e.g. for WhatsApp Business */
export type TicketArticleMediaErrorState = {
  __typename?: 'TicketArticleMediaErrorState';
  error?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TicketArticleRetryMediaDownload. */
export type TicketArticleRetryMediaDownloadPayload = {
  __typename?: 'TicketArticleRetryMediaDownloadPayload';
  /** Updated article (article is not updated in case of an error result). */
  article?: Maybe<TicketArticle>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the operation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TicketArticleRetrySecurityProcess. */
export type TicketArticleRetrySecurityProcessPayload = {
  __typename?: 'TicketArticleRetrySecurityProcessPayload';
  /** Updated article (article is not updated in case of an error result). */
  article?: Maybe<TicketArticle>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Result of the operation. */
  retryResult?: Maybe<TicketArticleSecurityState>;
};

/** Ticket article security information, e.g. for S/MIME */
export type TicketArticleSecurityState = {
  __typename?: 'TicketArticleSecurityState';
  encryptionMessage?: Maybe<Scalars['String']['output']>;
  encryptionSuccess?: Maybe<Scalars['Boolean']['output']>;
  signingMessage?: Maybe<Scalars['String']['output']>;
  signingSuccess?: Maybe<Scalars['Boolean']['output']>;
  /** The used email security method */
  type?: Maybe<EnumSecurityStateType>;
};

/** Ticket article senders */
export type TicketArticleSender = {
  __typename?: 'TicketArticleSender';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name?: Maybe<EnumTicketArticleSenderName>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Ticket article types */
export type TicketArticleType = {
  __typename?: 'TicketArticleType';
  communication?: Maybe<Scalars['Boolean']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of TicketArticleUpdates. */
export type TicketArticleUpdatesPayload = {
  __typename?: 'TicketArticleUpdatesPayload';
  /** A new article needs to be added to the list */
  addArticle?: Maybe<TicketArticle>;
  /** An article must be removed from the list */
  removeArticleId?: Maybe<Scalars['ID']['output']>;
  /** An existing article was changed */
  updateArticle?: Maybe<TicketArticle>;
};

/** Autogenerated return type of TicketChecklistAdd. */
export type TicketChecklistAddPayload = {
  __typename?: 'TicketChecklistAddPayload';
  /** Created checklist */
  checklist?: Maybe<Checklist>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Autogenerated return type of TicketChecklistDelete. */
export type TicketChecklistDeletePayload = {
  __typename?: 'TicketChecklistDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation succcessful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TicketChecklistItemDelete. */
export type TicketChecklistItemDeletePayload = {
  __typename?: 'TicketChecklistItemDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation succcessful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Input fields for ticket checklist item. */
export type TicketChecklistItemInput = {
  /** Checklist item state */
  checked?: InputMaybe<Scalars['Boolean']['input']>;
  /** Checklist item label */
  text?: InputMaybe<Scalars['String']['input']>;
};

/** Autogenerated return type of TicketChecklistItemOrderUpdate. */
export type TicketChecklistItemOrderUpdatePayload = {
  __typename?: 'TicketChecklistItemOrderUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation succcessful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of TicketChecklistItemUpsert. */
export type TicketChecklistItemUpsertPayload = {
  __typename?: 'TicketChecklistItemUpsertPayload';
  /** Updated or created checklist item. */
  checklistItem: ChecklistItem;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Autogenerated return type of TicketChecklistItemsAdd. */
export type TicketChecklistItemsAddPayload = {
  __typename?: 'TicketChecklistItemsAddPayload';
  /** Updated checklist. */
  checklist: Checklist;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of TicketChecklistTitleUpdate. */
export type TicketChecklistTitleUpdatePayload = {
  __typename?: 'TicketChecklistTitleUpdatePayload';
  /** Created checklist */
  checklist?: Maybe<Checklist>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Autogenerated return type of TicketChecklistUpdates. */
export type TicketChecklistUpdatesPayload = {
  __typename?: 'TicketChecklistUpdatesPayload';
  /** Ticket checklist was removed from ticket */
  removedTicketChecklist?: Maybe<Scalars['Boolean']['output']>;
  /** Ticket checklist */
  ticketChecklist?: Maybe<Checklist>;
};

/** The connection type for Ticket. */
export type TicketConnection = {
  __typename?: 'TicketConnection';
  /** A list of edges. */
  edges: Array<TicketEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** Open and closed ticket information */
export type TicketCount = {
  __typename?: 'TicketCount';
  /** Closed ticket count of the related object */
  closed: Scalars['Int']['output'];
  /** Closed ticket search query of the related object */
  closedSearchQuery?: Maybe<Scalars['String']['output']>;
  /** Open ticket count of the related object */
  open: Scalars['Int']['output'];
  /** Open ticket search query of the related object */
  openSearchQuery?: Maybe<Scalars['String']['output']>;
};

/** Represents the ticket attributes to be used in ticket create. */
export type TicketCreateInput = {
  /** The article data. */
  article?: InputMaybe<TicketArticleInput>;
  /** The customer of the ticket. */
  customer?: InputMaybe<TicketCustomerInput>;
  /** External references to create for the newly created ticket */
  externalReferences?: InputMaybe<TicketExternalReferencesInput>;
  /** The group of the ticket. */
  groupId: Scalars['ID']['input'];
  /** Links to create for the newly created ticket */
  links?: InputMaybe<Array<TicketLinkInput>>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization of the ticket. */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** The owner of the ticket. */
  ownerId?: InputMaybe<Scalars['ID']['input']>;
  /** The pending time of the ticket. */
  pendingTime?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  /** The priority of the ticket. */
  priorityId?: InputMaybe<Scalars['ID']['input']>;
  /** The shared draft used to create this ticket. */
  sharedDraftId?: InputMaybe<Scalars['ID']['input']>;
  /** The state of the ticket. */
  stateId?: InputMaybe<Scalars['ID']['input']>;
  /** The tags that should be assigned to the new ticket. */
  tags?: InputMaybe<Array<Scalars['String']['input']>>;
  /** The title of the ticket. */
  title: Scalars['NonEmptyString']['input'];
};

/** Autogenerated return type of TicketCreate. */
export type TicketCreatePayload = {
  __typename?: 'TicketCreatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created ticket. If this is present but empty, the mutation was successful but the user has no rights to view the new ticket. */
  ticket?: Maybe<Ticket>;
};

/** Base ticket input customer type */
export type TicketCustomerInput = {
  /** A customer email address. */
  email?: InputMaybe<Scalars['String']['input']>;
  /** The customer of the ticket. */
  id?: InputMaybe<Scalars['ID']['input']>;
};

/** Payload to update a ticket customer */
export type TicketCustomerUpdateInput = {
  /** The customer of the ticket. */
  customerId: Scalars['ID']['input'];
  /** The organization of the ticket (only needed if the customer belongs to several organizations). */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
};

/** Autogenerated return type of TicketCustomerUpdate. */
export type TicketCustomerUpdatePayload = {
  __typename?: 'TicketCustomerUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated ticket. */
  ticket?: Maybe<Ticket>;
};

/** An edge in a connection. */
export type TicketEdge = {
  __typename?: 'TicketEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: Ticket;
};

/** Links attached to a ticket and pointing to external services */
export type TicketExternalReferences = {
  __typename?: 'TicketExternalReferences';
  /** Returns exising links for the github integration */
  github?: Maybe<Array<Scalars['UriHttpString']['output']>>;
  /** Returns exising links for the gitlab integration */
  gitlab?: Maybe<Array<Scalars['UriHttpString']['output']>>;
  /** Returns exising object ids for the idoit integration */
  idoit?: Maybe<Array<Scalars['Int']['output']>>;
};

/** Idoit object item for an external reference for a ticket */
export type TicketExternalReferencesIdoitObject = {
  __typename?: 'TicketExternalReferencesIdoitObject';
  /** Idoit object id */
  idoitObjectId: Scalars['Int']['output'];
  /** Link to the object in the idoit GUI */
  link?: Maybe<Scalars['UriHttpString']['output']>;
  status: Scalars['String']['output'];
  title: Scalars['String']['output'];
  type: Scalars['String']['output'];
};

/** Autogenerated return type of TicketExternalReferencesIdoitObjectAdd. */
export type TicketExternalReferencesIdoitObjectAddPayload = {
  __typename?: 'TicketExternalReferencesIdoitObjectAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The added / resolved idoit objects */
  idoitObjects?: Maybe<Array<TicketExternalReferencesIdoitObject>>;
};

/** Represents information to fetch detailed idoit objects for the given idoit object ids or the given ticket */
export type TicketExternalReferencesIdoitObjectListInput = {
  /** The idoit object ids for the detailed list */
  idoitObjectIds?: InputMaybe<Array<Scalars['Int']['input']>>;
  /** The related ticket for the idoit objects */
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};

/** Autogenerated return type of TicketExternalReferencesIdoitObjectRemove. */
export type TicketExternalReferencesIdoitObjectRemovePayload = {
  __typename?: 'TicketExternalReferencesIdoitObjectRemovePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Represents the ticket external links to be added */
export type TicketExternalReferencesInput = {
  /** The article data. */
  article?: InputMaybe<TicketArticleInput>;
  /** The customer of the ticket. */
  customer?: InputMaybe<TicketCustomerInput>;
  /** Links for the github integration */
  github?: InputMaybe<Array<Scalars['UriHttpString']['input']>>;
  /** Links for the gitlab integration */
  gitlab?: InputMaybe<Array<Scalars['UriHttpString']['input']>>;
  /** Object ids for the Idoit integration */
  idoit?: InputMaybe<Array<Scalars['Int']['input']>>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization of the ticket. */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** The owner of the ticket. */
  ownerId?: InputMaybe<Scalars['ID']['input']>;
  /** The pending time of the ticket. */
  pendingTime?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  /** The priority of the ticket. */
  priorityId?: InputMaybe<Scalars['ID']['input']>;
  /** The state of the ticket. */
  stateId?: InputMaybe<Scalars['ID']['input']>;
};

/** Issue tracker item for an external reference for a ticket */
export type TicketExternalReferencesIssueTrackerItem = {
  __typename?: 'TicketExternalReferencesIssueTrackerItem';
  /** The assignees of the issue */
  assignees?: Maybe<Array<Scalars['String']['output']>>;
  /** The issue ID from the external issue tracker */
  issueId: Scalars['Int']['output'];
  /** The labels of the issue */
  labels?: Maybe<Array<TicketExternalReferencesIssueTrackerItemLabel>>;
  /** The milestone of the issue */
  milestone?: Maybe<Scalars['String']['output']>;
  /** The state of the issue */
  state: EnumTicketExternalReferencesIssueTrackerItemState;
  /** The title of the issue */
  title: Scalars['String']['output'];
  /** The URL of the issue */
  url: Scalars['UriHttpString']['output'];
};

/** Autogenerated return type of TicketExternalReferencesIssueTrackerItemAdd. */
export type TicketExternalReferencesIssueTrackerItemAddPayload = {
  __typename?: 'TicketExternalReferencesIssueTrackerItemAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The added issue tracker item */
  issueTrackerItem?: Maybe<TicketExternalReferencesIssueTrackerItem>;
};

/** The labels of the Issue tracker item */
export type TicketExternalReferencesIssueTrackerItemLabel = {
  __typename?: 'TicketExternalReferencesIssueTrackerItemLabel';
  /** The color of the label */
  color: Scalars['String']['output'];
  /** The text color of the label */
  textColor: Scalars['String']['output'];
  /** The title of the label */
  title: Scalars['String']['output'];
};

/** Autogenerated return type of TicketExternalReferencesIssueTrackerItemRemove. */
export type TicketExternalReferencesIssueTrackerItemRemovePayload = {
  __typename?: 'TicketExternalReferencesIssueTrackerItemRemovePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the mutation successful? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Represents information to fetch detailed issue tracker items for the given issue tracker links or the given ticket */
export type TicketExternalReferencesIssueTrackerListInput = {
  /** The issue tracker links for the detailed list */
  issueTrackerLinks?: InputMaybe<Array<Scalars['UriHttpString']['input']>>;
  /** The related ticket for the issue tracker items */
  ticketId?: InputMaybe<Scalars['ID']['input']>;
};

/** Represents a ticket link to another object. */
export type TicketLinkInput = {
  /** The target object to link to */
  linkObjectId: Scalars['ID']['input'];
  /** The link type to set, e.g. normal/parent/child */
  linkType: Scalars['String']['input'];
};

/** Ticket live user information */
export type TicketLiveUser = {
  __typename?: 'TicketLiveUser';
  /** Different apps information from the user */
  apps: Array<TicketLiveUserApp>;
  user: User;
};

/** Ticket live user app information */
export type TicketLiveUserApp = {
  __typename?: 'TicketLiveUserApp';
  editing: Scalars['Boolean']['output'];
  /** Last interaction time from the user in the frontend */
  lastInteraction: Scalars['ISO8601DateTime']['output'];
  name: EnumTaskbarApp;
};

/** Autogenerated return type of TicketLiveUserDelete. */
export type TicketLiveUserDeletePayload = {
  __typename?: 'TicketLiveUserDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the live user entry deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of TicketLiveUserUpdates. */
export type TicketLiveUserUpdatesPayload = {
  __typename?: 'TicketLiveUserUpdatesPayload';
  /** Current live users from the ticket. */
  liveUsers?: Maybe<Array<TicketLiveUser>>;
};

/** Autogenerated return type of TicketLiveUserUpsert. */
export type TicketLiveUserUpsertPayload = {
  __typename?: 'TicketLiveUserUpsertPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Did we succeed to insert/update the live user entry? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of TicketMerge. */
export type TicketMergePayload = {
  __typename?: 'TicketMergePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The source ticket after merging. */
  sourceTicket?: Maybe<Ticket>;
  /** The target ticket after merging. */
  targetTicket?: Maybe<Ticket>;
};

/** Autogenerated return type of TicketOverviewUpdates. */
export type TicketOverviewUpdatesPayload = {
  __typename?: 'TicketOverviewUpdatesPayload';
  /** Current ticket overviews for the user. */
  ticketOverviews?: Maybe<Array<Overview>>;
};

/** Ticket priorities */
export type TicketPriority = {
  __typename?: 'TicketPriority';
  active: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  defaultCreate: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  uiColor?: Maybe<Scalars['String']['output']>;
  uiIcon?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Refer to a ticket without raising authorization errors in case of missing permissions */
export type TicketReference = {
  __typename?: 'TicketReference';
  /** The ticket, if there is read permission */
  ticket?: Maybe<Ticket>;
};

/** Represents the security attributes to be used in ticket article create/update. */
export type TicketSecurityInput = {
  /** Security method. */
  method: EnumSecurityStateType;
  /** Enabled security options. */
  options: Array<EnumSecurityOption>;
};

/** Ticket shared draft to start new tickets */
export type TicketSharedDraftStart = {
  __typename?: 'TicketSharedDraftStart';
  content?: Maybe<Scalars['JSON']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  group?: Maybe<Group>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  name?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of TicketSharedDraftStartCreate. */
export type TicketSharedDraftStartCreatePayload = {
  __typename?: 'TicketSharedDraftStartCreatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated draft. */
  sharedDraft: TicketSharedDraftStart;
};

/** Autogenerated return type of TicketSharedDraftStartDelete. */
export type TicketSharedDraftStartDeletePayload = {
  __typename?: 'TicketSharedDraftStartDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the ticket article deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** The ticket start draft fields */
export type TicketSharedDraftStartInput = {
  /** Content of the draft */
  content: Scalars['JSON']['input'];
  /** Form ID to copy attachments from */
  formId: Scalars['String']['input'];
  /** Group to put shared draft into */
  groupId: Scalars['ID']['input'];
};

/** Autogenerated return type of TicketSharedDraftStartUpdateByGroup. */
export type TicketSharedDraftStartUpdateByGroupPayload = {
  __typename?: 'TicketSharedDraftStartUpdateByGroupPayload';
  /** Up-to-date drafts in the given */
  sharedDraftStarts?: Maybe<Array<TicketSharedDraftStart>>;
};

/** Autogenerated return type of TicketSharedDraftStartUpdate. */
export type TicketSharedDraftStartUpdatePayload = {
  __typename?: 'TicketSharedDraftStartUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated draft. */
  sharedDraft: TicketSharedDraftStart;
};

/** Ticket shared draft in detail view */
export type TicketSharedDraftZoom = {
  __typename?: 'TicketSharedDraftZoom';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  newArticle?: Maybe<Scalars['JSON']['output']>;
  ticketAttributes?: Maybe<Scalars['JSON']['output']>;
  ticketId?: Maybe<Scalars['ID']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Autogenerated return type of TicketSharedDraftZoomCreate. */
export type TicketSharedDraftZoomCreatePayload = {
  __typename?: 'TicketSharedDraftZoomCreatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created draft. */
  sharedDraft: TicketSharedDraftZoom;
};

/** Autogenerated return type of TicketSharedDraftZoomDelete. */
export type TicketSharedDraftZoomDeletePayload = {
  __typename?: 'TicketSharedDraftZoomDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the ticket article deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** The ticket zoom draft fields */
export type TicketSharedDraftZoomInput = {
  /** Form ID to copy attachments from */
  formId: Scalars['String']['input'];
  /** Article content of the draft */
  newArticle: Scalars['JSON']['input'];
  /** Ticket attributes of the draft */
  ticketAttributes: Scalars['JSON']['input'];
  /** Ticket to put the draft into */
  ticketId: Scalars['ID']['input'];
};

/** Autogenerated return type of TicketSharedDraftZoomUpdate. */
export type TicketSharedDraftZoomUpdatePayload = {
  __typename?: 'TicketSharedDraftZoomUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated draft. */
  sharedDraft: TicketSharedDraftZoom;
};

/** Ticket states */
export type TicketState = {
  __typename?: 'TicketState';
  active: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  defaultCreate: Scalars['Boolean']['output'];
  defaultFollowUp: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  ignoreEscalation: Scalars['Boolean']['output'];
  name: Scalars['String']['output'];
  nextStateId?: Maybe<Scalars['Int']['output']>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  /** resolver for Rails' belongs_to relationship */
  stateType: TicketStateType;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Ticket state types */
export type TicketStateType = {
  __typename?: 'TicketStateType';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  name: Scalars['String']['output'];
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Ticket time accounting - sum per type */
export type TicketTimeAccountingTypeSum = {
  __typename?: 'TicketTimeAccountingTypeSum';
  name: Scalars['String']['output'];
  timeUnit: Scalars['Float']['output'];
};

/** Payload to update a ticket customer */
export type TicketTitleUpdateInput = {
  /** The title of the ticket. */
  title: Scalars['String']['input'];
};

/** Autogenerated return type of TicketTitleUpdate. */
export type TicketTitleUpdatePayload = {
  __typename?: 'TicketTitleUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated ticket. */
  ticket?: Maybe<Ticket>;
};

/** Autogenerated return type of TicketUpdateBulk. */
export type TicketUpdateBulkPayload = {
  __typename?: 'TicketUpdateBulkPayload';
  /** Did the bulk update fail? */
  errors?: Maybe<Array<TicketUpdateBulkUserError>>;
  /** Were the tickets updated successfully? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Represents an error during a ticket bulk update mutation. */
export type TicketUpdateBulkUserError = {
  __typename?: 'TicketUpdateBulkUserError';
  /** Exception class */
  errorType: Scalars['String']['output'];
  /** Ticket which caused the bulk update transaction to fail and be rolled back */
  failedTicket?: Maybe<Ticket>;
  message: Scalars['String']['output'];
};

/** Represents the ticket attributes to be used in ticket update. */
export type TicketUpdateInput = {
  /** The article data. */
  article?: InputMaybe<TicketArticleInput>;
  /** The customer of the ticket. */
  customer?: InputMaybe<TicketCustomerInput>;
  /** The group of the ticket. */
  groupId?: InputMaybe<Scalars['ID']['input']>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization of the ticket. */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** The owner of the ticket. */
  ownerId?: InputMaybe<Scalars['ID']['input']>;
  /** The pending time of the ticket. */
  pendingTime?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  /** The priority of the ticket. */
  priorityId?: InputMaybe<Scalars['ID']['input']>;
  /** The shared draft used to update this ticket. */
  sharedDraftId?: InputMaybe<Scalars['ID']['input']>;
  /** The state of the ticket. */
  stateId?: InputMaybe<Scalars['ID']['input']>;
  /** The title of the ticket. */
  title?: InputMaybe<Scalars['NonEmptyString']['input']>;
};

/** Represents ticket update meta information to be used in ticket update. */
export type TicketUpdateMetaInput = {
  /** The article data. */
  article?: InputMaybe<TicketArticleInput>;
  /** The customer of the ticket. */
  customer?: InputMaybe<TicketCustomerInput>;
  /** The macro to apply onto ticket */
  macroId?: InputMaybe<Scalars['ID']['input']>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization of the ticket. */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** The owner of the ticket. */
  ownerId?: InputMaybe<Scalars['ID']['input']>;
  /** The pending time of the ticket. */
  pendingTime?: InputMaybe<Scalars['ISO8601DateTime']['input']>;
  /** The priority of the ticket. */
  priorityId?: InputMaybe<Scalars['ID']['input']>;
  /** The ticket update validators to skip */
  skipValidators?: InputMaybe<Array<EnumUserErrorException>>;
  /** The state of the ticket. */
  stateId?: InputMaybe<Scalars['ID']['input']>;
};

/** Autogenerated return type of TicketUpdate. */
export type TicketUpdatePayload = {
  __typename?: 'TicketUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated ticket. If this is present but empty, the mutation was successful but the user has no rights to view the updated ticket. */
  ticket?: Maybe<Ticket>;
};

/** Autogenerated return type of TicketUpdates. */
export type TicketUpdatesPayload = {
  __typename?: 'TicketUpdatesPayload';
  /** Updated ticket */
  ticket?: Maybe<Ticket>;
};

/** User access token */
export type Token = {
  __typename?: 'Token';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  expiresAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  id: Scalars['ID']['output'];
  lastUsedAt?: Maybe<Scalars['ISO8601DateTime']['output']>;
  name?: Maybe<Scalars['String']['output']>;
  preferences?: Maybe<Scalars['JSON']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  /** resolver for Rails' belongs_to relationship */
  user?: Maybe<User>;
};

/** Autogenerated return type of Translations. */
export type TranslationsPayload = {
  __typename?: 'TranslationsPayload';
  /** Cache key that the front end should use to cache the new translation data. */
  cacheKey?: Maybe<Scalars['String']['output']>;
  /** If this is true, then the front end's translation cache is still valid and should be used, cacheKey and translation will not be returned. */
  isCacheStillValid: Scalars['Boolean']['output'];
  /** The actual translation data as Hash where keys are source and values target strings (excluding untranslated strings). */
  translations?: Maybe<Scalars['JSON']['output']>;
};

/** Triggers */
export type Trigger = {
  __typename?: 'Trigger';
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  id: Scalars['ID']['output'];
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  /** Name of the trigger */
  name: Scalars['String']['output'];
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
};

/** Payload for the two factor authentication */
export type TwoFactorAuthenticationInput = {
  /** Two factor authentication method */
  twoFactorMethod: EnumTwoFactorAuthenticationMethod;
  /** Two factor authentication token */
  twoFactorPayload: Scalars['JSON']['input'];
};

/** Two factor authentication methods available for the user about to log-in. */
export type TwoFactorEnabledAuthenticationMethod = {
  __typename?: 'TwoFactorEnabledAuthenticationMethod';
  authenticationMethod: EnumTwoFactorAuthenticationMethod;
  configured: Scalars['Boolean']['output'];
  default: Scalars['Boolean']['output'];
};

/** Autogenerated return type of TwoFactorMethodInitiateAuthentication. */
export type TwoFactorMethodInitiateAuthenticationPayload = {
  __typename?: 'TwoFactorMethodInitiateAuthenticationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  initiationData?: Maybe<Scalars['JSON']['output']>;
};

/** Payload for the two factor recovery authentication */
export type TwoFactorRecoveryInput = {
  /** Two factor recovery code */
  recoveryCode: Scalars['String']['input'];
};

/** A file to be uploaded. */
export type UploadFileInput = {
  /** File content */
  content?: InputMaybe<Scalars['BinaryString']['input']>;
  /** Content-Disposition: inline flag */
  inline?: InputMaybe<Scalars['Boolean']['input']>;
  /** File name. */
  name: Scalars['String']['input'];
  /** File's content-type. */
  type?: InputMaybe<Scalars['String']['input']>;
};

/** Users (admins, agents and customers) */
export type User = ObjectAttributeValuesInterface & {
  __typename?: 'User';
  active?: Maybe<Scalars['Boolean']['output']>;
  authorizations?: Maybe<Array<Authorization>>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  email?: Maybe<Scalars['String']['output']>;
  fax?: Maybe<Scalars['String']['output']>;
  firstname?: Maybe<Scalars['String']['output']>;
  fullname?: Maybe<Scalars['String']['output']>;
  hasSecondaryOrganizations?: Maybe<Scalars['Boolean']['output']>;
  id: Scalars['ID']['output'];
  image?: Maybe<Scalars['String']['output']>;
  imageSource?: Maybe<Scalars['String']['output']>;
  /** Internal database ID */
  internalId: Scalars['Int']['output'];
  lastname?: Maybe<Scalars['String']['output']>;
  login?: Maybe<Scalars['String']['output']>;
  mobile?: Maybe<Scalars['String']['output']>;
  /** Internal note */
  note?: Maybe<Scalars['String']['output']>;
  objectAttributeValues?: Maybe<Array<ObjectAttributeValue>>;
  /** resolver for Rails' belongs_to relationship */
  organization?: Maybe<Organization>;
  outOfOffice?: Maybe<Scalars['Boolean']['output']>;
  outOfOfficeEndAt?: Maybe<Scalars['ISO8601Date']['output']>;
  /** Replacement agent if this user is out of office */
  outOfOfficeReplacement?: Maybe<User>;
  outOfOfficeStartAt?: Maybe<Scalars['ISO8601Date']['output']>;
  permissions?: Maybe<UserPermission>;
  /** Typed access to user preferences */
  personalSettings?: Maybe<UserPersonalSettings>;
  phone?: Maybe<Scalars['String']['output']>;
  policy: PolicyDefault;
  /** Direct access to preferences store */
  preferences?: Maybe<Scalars['JSON']['output']>;
  secondaryOrganizations?: Maybe<OrganizationConnection>;
  ticketsCount?: Maybe<TicketCount>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  verified?: Maybe<Scalars['Boolean']['output']>;
  vip?: Maybe<Scalars['Boolean']['output']>;
  web?: Maybe<Scalars['String']['output']>;
};


/** Users (admins, agents and customers) */
export type UserSecondaryOrganizationsArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  first?: InputMaybe<Scalars['Int']['input']>;
  last?: InputMaybe<Scalars['Int']['input']>;
};

/** User access token creation fields */
export type UserAccessTokenInput = {
  /** The token expiration date */
  expiresAt?: InputMaybe<Scalars['ISO8601Date']['input']>;
  /** The token name */
  name: Scalars['String']['input'];
  /** Permission names */
  permission: Array<Scalars['String']['input']>;
};

/** Autogenerated return type of UserAddFirstAdmin. */
export type UserAddFirstAdminPayload = {
  __typename?: 'UserAddFirstAdminPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The current session, if the user was successfully created. */
  session?: Maybe<Session>;
};

/** Autogenerated return type of UserAdd. */
export type UserAddPayload = {
  __typename?: 'UserAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created user. */
  user?: Maybe<User>;
};

/** Calendar subscriptions all calendars options saving */
export type UserCalendarSubscriptionSingleOptionsInput = {
  /** Defines if not assigned tickets are included */
  notAssigned: Scalars['Boolean']['input'];
  /** Defines if own tickets are included */
  own: Scalars['Boolean']['input'];
};

/** Calendar subscriptions options saving */
export type UserCalendarSubscriptionsConfigInput = {
  /** Defines if alarm is added */
  alarm: Scalars['Boolean']['input'];
  /** Options for Escalation tab */
  escalation: UserCalendarSubscriptionSingleOptionsInput;
  /** Options for New & opened tab */
  newOpen: UserCalendarSubscriptionSingleOptionsInput;
  /** Options for Pending tab */
  pending: UserCalendarSubscriptionSingleOptionsInput;
};

/** Two factor configuration information (e.g. configured and default methods) for the user. */
export type UserConfigurationTwoFactor = {
  __typename?: 'UserConfigurationTwoFactor';
  /** List of enabled two factor authentication methods (and information about the current user). */
  enabledAuthenticationMethods: Array<TwoFactorEnabledAuthenticationMethod>;
  /** Whether recovery codes exist for the current user. */
  recoveryCodesExist: Scalars['Boolean']['output'];
};

/** The connection type for User. */
export type UserConnection = {
  __typename?: 'UserConnection';
  /** A list of edges. */
  edges: Array<UserEdge>;
  /** Information to aid in pagination. */
  pageInfo: PageInfo;
  /** Indicates the total number of available records. */
  totalCount: Scalars['Int']['output'];
};

/** Autogenerated return type of UserCurrentAccessTokenAdd. */
export type UserCurrentAccessTokenAddPayload = {
  __typename?: 'UserCurrentAccessTokenAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The token data */
  token?: Maybe<Token>;
  /** The token itself, shown once */
  tokenValue: Scalars['String']['output'];
};

/** Autogenerated return type of UserCurrentAccessTokenDelete. */
export type UserCurrentAccessTokenDeletePayload = {
  __typename?: 'UserCurrentAccessTokenDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the access token deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentAccessTokenUpdates. */
export type UserCurrentAccessTokenUpdatesPayload = {
  __typename?: 'UserCurrentAccessTokenUpdatesPayload';
  /** List of acess tokens for the user */
  tokens?: Maybe<Array<Token>>;
};

/** Autogenerated return type of UserCurrentAppearance. */
export type UserCurrentAppearancePayload = {
  __typename?: 'UserCurrentAppearancePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Profile appearance settings updated successfully? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentAvatarAdd. */
export type UserCurrentAvatarAddPayload = {
  __typename?: 'UserCurrentAvatarAddPayload';
  /** The newly created avatar. */
  avatar?: Maybe<Avatar>;
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
};

/** Autogenerated return type of UserCurrentAvatarDelete. */
export type UserCurrentAvatarDeletePayload = {
  __typename?: 'UserCurrentAvatarDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the avatar deletion successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentAvatarSelect. */
export type UserCurrentAvatarSelectPayload = {
  __typename?: 'UserCurrentAvatarSelectPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the avatar selection successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentAvatarUpdates. */
export type UserCurrentAvatarUpdatesPayload = {
  __typename?: 'UserCurrentAvatarUpdatesPayload';
  /** List of avatars for the user */
  avatars?: Maybe<Array<Avatar>>;
};

/** Autogenerated return type of UserCurrentCalendarSubscriptionUpdate. */
export type UserCurrentCalendarSubscriptionUpdatePayload = {
  __typename?: 'UserCurrentCalendarSubscriptionUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Profile appearance settings updated successfully? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentChangePassword. */
export type UserCurrentChangePasswordPayload = {
  __typename?: 'UserCurrentChangePasswordPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if changing the password was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentDeviceDelete. */
export type UserCurrentDeviceDeletePayload = {
  __typename?: 'UserCurrentDeviceDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if deleting the user (session) device was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentDevicesUpdates. */
export type UserCurrentDevicesUpdatesPayload = {
  __typename?: 'UserCurrentDevicesUpdatesPayload';
  /** List of devices for the user */
  devices?: Maybe<Array<UserDevice>>;
};

/** Autogenerated return type of UserCurrentLocale. */
export type UserCurrentLocalePayload = {
  __typename?: 'UserCurrentLocalePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the update successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentNotificationPreferencesReset. */
export type UserCurrentNotificationPreferencesResetPayload = {
  __typename?: 'UserCurrentNotificationPreferencesResetPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Updated user object */
  user: User;
};

/** Autogenerated return type of UserCurrentNotificationPreferencesUpdate. */
export type UserCurrentNotificationPreferencesUpdatePayload = {
  __typename?: 'UserCurrentNotificationPreferencesUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Updated user object */
  user: User;
};

/** Autogenerated return type of UserCurrentOutOfOffice. */
export type UserCurrentOutOfOfficePayload = {
  __typename?: 'UserCurrentOutOfOfficePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Profile out of office settings updated successfully? */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Hold last used information for an overview */
export type UserCurrentOverviewLastUsed = {
  /** When the overview was last used */
  lastUsedAt: Scalars['ISO8601DateTime']['input'];
  /** The overview */
  overviewId: Scalars['ID']['input'];
};

/** Autogenerated return type of UserCurrentOverviewOrderingUpdates. */
export type UserCurrentOverviewOrderingUpdatesPayload = {
  __typename?: 'UserCurrentOverviewOrderingUpdatesPayload';
  /** List of sorted overviews for the user */
  overviews?: Maybe<Array<Overview>>;
};

/** Autogenerated return type of UserCurrentOverviewResetOrder. */
export type UserCurrentOverviewResetOrderPayload = {
  __typename?: 'UserCurrentOverviewResetOrderPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** List of overview sortings for the user */
  overviews?: Maybe<Array<Overview>>;
  /** Was the reset successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentOverviewUpdateLastUsed. */
export type UserCurrentOverviewUpdateLastUsedPayload = {
  __typename?: 'UserCurrentOverviewUpdateLastUsedPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the save successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentOverviewUpdateOrder. */
export type UserCurrentOverviewUpdateOrderPayload = {
  __typename?: 'UserCurrentOverviewUpdateOrderPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the reset successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentPasswordCheck. */
export type UserCurrentPasswordCheckPayload = {
  __typename?: 'UserCurrentPasswordCheckPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if given password matches current user password */
  success?: Maybe<Scalars['Boolean']['output']>;
  /** One-time token which should be included in a subsequent request (where applicable) */
  token?: Maybe<Scalars['String']['output']>;
};

/** Autogenerated return type of UserCurrentRecentViewReset. */
export type UserCurrentRecentViewResetPayload = {
  __typename?: 'UserCurrentRecentViewResetPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the reset successful? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentRecentViewUpdates. */
export type UserCurrentRecentViewUpdatesPayload = {
  __typename?: 'UserCurrentRecentViewUpdatesPayload';
  /** The recent view list of the user has changed. */
  recentViewsUpdated?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentRemoveLinkedAccount. */
export type UserCurrentRemoveLinkedAccountPayload = {
  __typename?: 'UserCurrentRemoveLinkedAccountPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Was the linked account removed? */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentTaskbarItemAdd. */
export type UserCurrentTaskbarItemAddPayload = {
  __typename?: 'UserCurrentTaskbarItemAddPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created taskbar item. */
  taskbarItem?: Maybe<UserTaskbarItem>;
};

/** Autogenerated return type of UserCurrentTaskbarItemDelete. */
export type UserCurrentTaskbarItemDeletePayload = {
  __typename?: 'UserCurrentTaskbarItemDeletePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if deleting the user (session) device was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTaskbarItemListPrio. */
export type UserCurrentTaskbarItemListPrioPayload = {
  __typename?: 'UserCurrentTaskbarItemListPrioPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if sorting the taskbar item list was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTaskbarItemListUpdates. */
export type UserCurrentTaskbarItemListUpdatesPayload = {
  __typename?: 'UserCurrentTaskbarItemListUpdatesPayload';
  /** List of taskbar items */
  taskbarItemList?: Maybe<Array<UserTaskbarItem>>;
};

/** Autogenerated return type of UserCurrentTaskbarItemStateUpdates. */
export type UserCurrentTaskbarItemStateUpdatesPayload = {
  __typename?: 'UserCurrentTaskbarItemStateUpdatesPayload';
  /** Signals that the taskbar item state has changed */
  stateChanged?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTaskbarItemTouchLastContact. */
export type UserCurrentTaskbarItemTouchLastContactPayload = {
  __typename?: 'UserCurrentTaskbarItemTouchLastContactPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated taskbar item. */
  taskbarItem?: Maybe<UserTaskbarItem>;
};

/** Autogenerated return type of UserCurrentTaskbarItemUpdate. */
export type UserCurrentTaskbarItemUpdatePayload = {
  __typename?: 'UserCurrentTaskbarItemUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The updated taskbar item. */
  taskbarItem?: Maybe<UserTaskbarItem>;
};

/** Autogenerated return type of UserCurrentTaskbarItemUpdates. */
export type UserCurrentTaskbarItemUpdatesPayload = {
  __typename?: 'UserCurrentTaskbarItemUpdatesPayload';
  /** A new taskbar item needs to be added to the list */
  addItem?: Maybe<UserTaskbarItem>;
  /** An item must be removed from the list */
  removeItem?: Maybe<Scalars['ID']['output']>;
  /** An existing taskbar item was changed */
  updateItem?: Maybe<UserTaskbarItem>;
};

/** Autogenerated return type of UserCurrentTicketOverviewUpdates. */
export type UserCurrentTicketOverviewUpdatesPayload = {
  __typename?: 'UserCurrentTicketOverviewUpdatesPayload';
  /** Current ticket overviews for the user. */
  ticketOverviews?: Maybe<Array<Overview>>;
};

/** Autogenerated return type of UserCurrentTicketScreenBehavior. */
export type UserCurrentTicketScreenBehaviorPayload = {
  __typename?: 'UserCurrentTicketScreenBehaviorPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** Whether the user ticket screen behavior setting was updated successfully */
  success: Scalars['Boolean']['output'];
};

/** Autogenerated return type of UserCurrentTwoFactorRecoveryCodesGenerate. */
export type UserCurrentTwoFactorRecoveryCodesGeneratePayload = {
  __typename?: 'UserCurrentTwoFactorRecoveryCodesGeneratePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** One-time two-factor authentication codes */
  recoveryCodes?: Maybe<Array<Scalars['String']['output']>>;
};

/** Autogenerated return type of UserCurrentTwoFactorRemoveMethodCredentials. */
export type UserCurrentTwoFactorRemoveMethodCredentialsPayload = {
  __typename?: 'UserCurrentTwoFactorRemoveMethodCredentialsPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if removing authentication method was successful */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTwoFactorRemoveMethod. */
export type UserCurrentTwoFactorRemoveMethodPayload = {
  __typename?: 'UserCurrentTwoFactorRemoveMethodPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if removing authentication method was successful */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTwoFactorSetDefaultMethod. */
export type UserCurrentTwoFactorSetDefaultMethodPayload = {
  __typename?: 'UserCurrentTwoFactorSetDefaultMethodPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if setting authentication method as default was successful */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserCurrentTwoFactorUpdates. */
export type UserCurrentTwoFactorUpdatesPayload = {
  __typename?: 'UserCurrentTwoFactorUpdatesPayload';
  /** Configuration information for the current user. */
  configuration?: Maybe<UserConfigurationTwoFactor>;
};

/** Autogenerated return type of UserCurrentTwoFactorVerifyMethodConfiguration. */
export type UserCurrentTwoFactorVerifyMethodConfigurationPayload = {
  __typename?: 'UserCurrentTwoFactorVerifyMethodConfigurationPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** One-time two-factor authentication codes */
  recoveryCodes?: Maybe<Array<Scalars['String']['output']>>;
};

/** Users (session) device */
export type UserDevice = {
  __typename?: 'UserDevice';
  browser?: Maybe<Scalars['String']['output']>;
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  deviceDetails?: Maybe<Scalars['JSON']['output']>;
  fingerprint?: Maybe<Scalars['String']['output']>;
  id: Scalars['ID']['output'];
  ip?: Maybe<Scalars['String']['output']>;
  location?: Maybe<Scalars['String']['output']>;
  locationDetails?: Maybe<Scalars['JSON']['output']>;
  name: Scalars['String']['output'];
  os?: Maybe<Scalars['String']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  userAgent?: Maybe<Scalars['String']['output']>;
  userId: Scalars['ID']['output'];
};

/** An edge in a connection. */
export type UserEdge = {
  __typename?: 'UserEdge';
  /** A cursor for use in pagination. */
  cursor: Scalars['String']['output'];
  /** The item at the end of the edge. */
  node: User;
};

/** Represents an error in the input of a mutation. */
export type UserError = {
  __typename?: 'UserError';
  exception?: Maybe<EnumUserErrorException>;
  field?: Maybe<Scalars['String']['output']>;
  message: Scalars['String']['output'];
  messagePlaceholder?: Maybe<Array<Scalars['String']['output']>>;
};

/** Represents a User <-> Group permission entry. */
export type UserGroupPermissionEntry = {
  /** Assigned access levels for the user in the group */
  accessType: Array<EnumPermissionAccess>;
  /** Internal ID of the group */
  groupInternalId: Scalars['Int']['input'];
};

/** The user add/update fields. */
export type UserInput = {
  /** The user active flag */
  active?: InputMaybe<Scalars['Boolean']['input']>;
  /** The user email */
  email?: InputMaybe<Scalars['String']['input']>;
  /** The user fax */
  fax?: InputMaybe<Scalars['String']['input']>;
  /** The user first name */
  firstname?: InputMaybe<Scalars['String']['input']>;
  /** User group access levels */
  groupIds?: InputMaybe<Array<UserGroupPermissionEntry>>;
  /** The user last name */
  lastname?: InputMaybe<Scalars['String']['input']>;
  /** The user mobile */
  mobile?: InputMaybe<Scalars['String']['input']>;
  /** The user note */
  note?: InputMaybe<Scalars['String']['input']>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The organization the user belongs to */
  organizationId?: InputMaybe<Scalars['ID']['input']>;
  /** The secondary organizations the user belongs to */
  organizationIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The user password */
  password?: InputMaybe<Scalars['String']['input']>;
  /** The user phone */
  phone?: InputMaybe<Scalars['String']['input']>;
  /** The roles (e.g. admin, agent, (e.g. Agent or Customer) this user has */
  roleIds?: InputMaybe<Array<Scalars['ID']['input']>>;
  /** The user vip flag */
  vip?: InputMaybe<Scalars['Boolean']['input']>;
  /** The user web */
  web?: InputMaybe<Scalars['String']['input']>;
};

/** Two factor authentication methods available for the user about to log-in. */
export type UserLoginTwoFactorMethods = {
  __typename?: 'UserLoginTwoFactorMethods';
  availableTwoFactorAuthenticationMethods: Array<EnumTwoFactorAuthenticationMethod>;
  defaultTwoFactorAuthenticationMethod?: Maybe<EnumTwoFactorAuthenticationMethod>;
  recoveryCodesAvailable: Scalars['Boolean']['output'];
};

/** Settings for ticket notification channels. */
export type UserNotificationMatrixChannelInput = {
  /** Whether to send notifications via email */
  email: Scalars['Boolean']['input'];
  /** Whether to show notifications via GUI */
  online?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Filter for ticket notification channels. */
export type UserNotificationMatrixCriteriaInput = {
  /** No filter - send notificationy for any tickets */
  no: Scalars['Boolean']['input'];
  /** Send notifications for my tickets */
  ownedByMe: Scalars['Boolean']['input'];
  /** Send notifications for unassigned tickets */
  ownedByNobody: Scalars['Boolean']['input'];
  /** Send notifications for my subscribed tickets */
  subscribed: Scalars['Boolean']['input'];
};

/** Settings for ticket notifications. */
export type UserNotificationMatrixInput = {
  /** Notification settings for new tickets */
  create: UserNotificationMatrixRowInput;
  /** Notification settings for ticket escalations */
  escalation: UserNotificationMatrixRowInput;
  /** Notification settings for reached ticket reminders */
  reminderReached: UserNotificationMatrixRowInput;
  /** Notification settings for updated tickets */
  update: UserNotificationMatrixRowInput;
};

/** Settings for ticket notifications. */
export type UserNotificationMatrixRowInput = {
  /** Channels for notification delivery */
  channel: UserNotificationMatrixChannelInput;
  /** Filter for ticket notifications */
  criteria: UserNotificationMatrixCriteriaInput;
};

/** Settings for notification sounds. */
export type UserNotificationSoundInput = {
  /** Whether to play notification sounds */
  enabled: Scalars['Boolean']['input'];
  /** Which audio file to play for notification sounds */
  file: EnumNotificationSoundFile;
};

/** Autogenerated return type of UserPasswordResetSend. */
export type UserPasswordResetSendPayload = {
  __typename?: 'UserPasswordResetSendPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if sending of the password reset link was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserPasswordResetUpdate. */
export type UserPasswordResetUpdatePayload = {
  __typename?: 'UserPasswordResetUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if the password update was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserPasswordResetVerify. */
export type UserPasswordResetVerifyPayload = {
  __typename?: 'UserPasswordResetVerifyPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if the password reset token is valid. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Permissions for the current user */
export type UserPermission = {
  __typename?: 'UserPermission';
  ids: Array<Scalars['Int']['output']>;
  names: Array<Scalars['String']['output']>;
};

/** Personal settings of the current user */
export type UserPersonalSettings = {
  __typename?: 'UserPersonalSettings';
  notificationConfig?: Maybe<UserPersonalSettingsNotificationConfig>;
  notificationSound?: Maybe<UserPersonalSettingsNotificationSound>;
};

/** Options applying for all calendar subscriptions */
export type UserPersonalSettingsCalendarSubscriptionGlobalOptions = {
  __typename?: 'UserPersonalSettingsCalendarSubscriptionGlobalOptions';
  alarm?: Maybe<Scalars['Boolean']['output']>;
};

/** Settings for the single calendar subscription */
export type UserPersonalSettingsCalendarSubscriptionSingle = {
  __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle';
  options?: Maybe<UserPersonalSettingsCalendarSubscriptionSingleOptions>;
  url?: Maybe<Scalars['UriHttpString']['output']>;
};

/** Options for the single calendar subscription */
export type UserPersonalSettingsCalendarSubscriptionSingleOptions = {
  __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions';
  notAssigned?: Maybe<Scalars['Boolean']['output']>;
  own?: Maybe<Scalars['Boolean']['output']>;
};

/** Settings for calendar subscription */
export type UserPersonalSettingsCalendarSubscriptionsConfig = {
  __typename?: 'UserPersonalSettingsCalendarSubscriptionsConfig';
  combinedUrl?: Maybe<Scalars['UriHttpString']['output']>;
  escalation?: Maybe<UserPersonalSettingsCalendarSubscriptionSingle>;
  globalOptions?: Maybe<UserPersonalSettingsCalendarSubscriptionGlobalOptions>;
  newOpen?: Maybe<UserPersonalSettingsCalendarSubscriptionSingle>;
  pending?: Maybe<UserPersonalSettingsCalendarSubscriptionSingle>;
};

/** Settings for ticket notifications. */
export type UserPersonalSettingsNotificationConfig = {
  __typename?: 'UserPersonalSettingsNotificationConfig';
  groupIds?: Maybe<Array<Scalars['Int']['output']>>;
  matrix?: Maybe<UserPersonalSettingsNotificationMatrix>;
};

/** Settings for ticket notifications. */
export type UserPersonalSettingsNotificationMatrix = {
  __typename?: 'UserPersonalSettingsNotificationMatrix';
  /** Notification settings for new tickets */
  create?: Maybe<UserPersonalSettingsNotificationMatrixRow>;
  /** Notification settings for ticket escalations */
  escalation?: Maybe<UserPersonalSettingsNotificationMatrixRow>;
  /** Notification settings for reached ticket reminders */
  reminderReached?: Maybe<UserPersonalSettingsNotificationMatrixRow>;
  /** Notification settings for updated tickets */
  update?: Maybe<UserPersonalSettingsNotificationMatrixRow>;
};

/** Settings for ticket notification channels. */
export type UserPersonalSettingsNotificationMatrixChannel = {
  __typename?: 'UserPersonalSettingsNotificationMatrixChannel';
  /** Whether to send notifications via email */
  email?: Maybe<Scalars['Boolean']['output']>;
  /** Whether to show notifications via GUI */
  online?: Maybe<Scalars['Boolean']['output']>;
};

/** Filter for ticket notification channels. */
export type UserPersonalSettingsNotificationMatrixCriteria = {
  __typename?: 'UserPersonalSettingsNotificationMatrixCriteria';
  /** No filter - send notificationy for any tickets */
  no?: Maybe<Scalars['Boolean']['output']>;
  /** Send notifications for my tickets */
  ownedByMe?: Maybe<Scalars['Boolean']['output']>;
  /** Send notifications for unassigned tickets */
  ownedByNobody?: Maybe<Scalars['Boolean']['output']>;
  /** Send notifications for my subscribed tickets */
  subscribed?: Maybe<Scalars['Boolean']['output']>;
};

/** Settings for ticket notifications. */
export type UserPersonalSettingsNotificationMatrixRow = {
  __typename?: 'UserPersonalSettingsNotificationMatrixRow';
  /** Channels for notification delivery */
  channel?: Maybe<UserPersonalSettingsNotificationMatrixChannel>;
  /** Filter for ticket notifications */
  criteria?: Maybe<UserPersonalSettingsNotificationMatrixCriteria>;
};

/** Settings for notification sounds. */
export type UserPersonalSettingsNotificationSound = {
  __typename?: 'UserPersonalSettingsNotificationSound';
  /** Whether to play notification sounds */
  enabled?: Maybe<Scalars['Boolean']['output']>;
  /** Which audio file to play for notification sounds */
  file?: Maybe<EnumNotificationSoundFile>;
};

/** The user sign-up fields. */
export type UserSignupInput = {
  /** The user email */
  email: Scalars['String']['input'];
  /** The user first name */
  firstname?: InputMaybe<Scalars['String']['input']>;
  /** The user last name */
  lastname?: InputMaybe<Scalars['String']['input']>;
  /** The user login */
  login?: InputMaybe<Scalars['String']['input']>;
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The user password */
  password: Scalars['String']['input'];
};

/** Autogenerated return type of UserSignup. */
export type UserSignupPayload = {
  __typename?: 'UserSignupPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if creating the user and sending the token was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserSignupResend. */
export type UserSignupResendPayload = {
  __typename?: 'UserSignupResendPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** This indicates if sending of the token via email was successful. */
  success?: Maybe<Scalars['Boolean']['output']>;
};

/** Autogenerated return type of UserSignupVerify. */
export type UserSignupVerifyPayload = {
  __typename?: 'UserSignupVerifyPayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The current session, if the verification was successful. */
  session?: Maybe<Session>;
};

/** Users taskbar item */
export type UserTaskbarItem = {
  __typename?: 'UserTaskbarItem';
  active: Scalars['Boolean']['output'];
  app: EnumTaskbarApp;
  callback: EnumTaskbarEntity;
  changed: Scalars['Boolean']['output'];
  /** Create date/time of the record */
  createdAt: Scalars['ISO8601DateTime']['output'];
  /** User that created this record */
  createdBy?: Maybe<User>;
  dirty: Scalars['Boolean']['output'];
  entity?: Maybe<TaskbarItemEntity>;
  entityAccess?: Maybe<EnumTaskbarEntityAccess>;
  formId?: Maybe<Scalars['String']['output']>;
  formNewArticlePresent: Scalars['Boolean']['output'];
  id: Scalars['ID']['output'];
  key: Scalars['String']['output'];
  notify: Scalars['Boolean']['output'];
  params?: Maybe<Scalars['JSON']['output']>;
  prio: Scalars['Int']['output'];
  state?: Maybe<Scalars['JSON']['output']>;
  /** Last update date/time of the record */
  updatedAt: Scalars['ISO8601DateTime']['output'];
  /** Last user that updated this record */
  updatedBy?: Maybe<User>;
  userId: Scalars['ID']['output'];
};

/** Entity representing taskbar item search */
export type UserTaskbarItemEntitySearch = {
  __typename?: 'UserTaskbarItemEntitySearch';
  model?: Maybe<Scalars['String']['output']>;
  query?: Maybe<Scalars['String']['output']>;
};

/** Entity representing taskbar item ticket create */
export type UserTaskbarItemEntityTicketCreate = {
  __typename?: 'UserTaskbarItemEntityTicketCreate';
  createArticleTypeKey?: Maybe<Scalars['String']['output']>;
  title: Scalars['String']['output'];
  uid: Scalars['String']['output'];
};

/** The taskbar item fields. */
export type UserTaskbarItemInput = {
  /** The taskbar item application */
  app: EnumTaskbarApp;
  /** The taskbar item related object callback */
  callback: EnumTaskbarEntity;
  /** The taskbar item form updater dirty flag */
  dirty?: InputMaybe<Scalars['Boolean']['input']>;
  /** The itaskbar item related object key identifier */
  key: Scalars['String']['input'];
  /** The taskbar item notification about changes */
  notify: Scalars['Boolean']['input'];
  /** Additional custom attributes (names + values) */
  objectAttributeValues?: InputMaybe<Array<ObjectAttributeValueInput>>;
  /** The taskbar item related object parameters */
  params?: InputMaybe<Scalars['JSON']['input']>;
  /** The taskbar item sorting priority */
  prio: Scalars['Int']['input'];
  /** The taskbar item related object state */
  state?: InputMaybe<Scalars['JSON']['input']>;
};

/** The taskbar item list priority fields. */
export type UserTaskbarItemListPrioInput = {
  /** The taskbar item ID */
  id: Scalars['ID']['input'];
  /** The taskbar item priority */
  prio: Scalars['Int']['input'];
};

/** Autogenerated return type of UserUpdate. */
export type UserUpdatePayload = {
  __typename?: 'UserUpdatePayload';
  /** Errors encountered during execution of the mutation. */
  errors?: Maybe<Array<UserError>>;
  /** The created user. */
  user?: Maybe<User>;
};

/** Autogenerated return type of UserUpdates. */
export type UserUpdatesPayload = {
  __typename?: 'UserUpdatesPayload';
  /** Updated user */
  user?: Maybe<User>;
};

export type OrganizationInfoForPopoverQueryVariables = Exact<{
  organizationId: Scalars['ID']['input'];
  membersCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type OrganizationInfoForPopoverQuery = { __typename?: 'Queries', organization: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, allMembers?: { __typename?: 'UserConnection', totalCount: number, edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, internalId: number, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null } }> } | null } };

export type DetailSearchQueryVariables = Exact<{
  search: Scalars['String']['input'];
  onlyIn: EnumSearchableModels;
  limit?: InputMaybe<Scalars['Int']['input']>;
  offset?: InputMaybe<Scalars['Int']['input']>;
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
}>;


export type DetailSearchQuery = { __typename?: 'Queries', search: { __typename?: 'SearchResult', totalCount: number, items: Array<
      | { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, active?: boolean | null }
      | { __typename?: 'Ticket', id: string, internalId: number, title: string, number: string, stateColorCode: EnumTicketStateColorCode, createdAt: string, customer: { __typename?: 'User', id: string, fullname?: string | null }, owner: { __typename?: 'User', id: string, fullname?: string | null }, group: { __typename?: 'Group', id: string, name?: string | null }, state: { __typename?: 'TicketState', id: string, name: string }, priority: { __typename?: 'TicketPriority', id: string, name: string, uiColor?: string | null }, policy: { __typename?: 'PolicyTicket', update: boolean } }
      | { __typename?: 'User', id: string, internalId: number, login?: string | null, firstname?: string | null, lastname?: string | null, active?: boolean | null, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, secondaryOrganizations?: { __typename?: 'OrganizationConnection', totalCount: number, edges: Array<{ __typename?: 'OrganizationEdge', node: { __typename?: 'Organization', id: string, name?: string | null } }> } | null }
    > } };

export type QuickSearchQueryVariables = Exact<{
  search: Scalars['String']['input'];
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type QuickSearchQuery = { __typename?: 'Queries', quickSearchOrganizations: { __typename?: 'SearchResult', totalCount: number, items: Array<
      | { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null }
      | { __typename?: 'Ticket' }
      | { __typename?: 'User' }
    > }, quickSearchTickets: { __typename?: 'SearchResult', totalCount: number, items: Array<
      | { __typename?: 'Organization' }
      | { __typename?: 'Ticket', id: string, internalId: number, title: string, number: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }
      | { __typename?: 'User' }
    > }, quickSearchUsers: { __typename?: 'SearchResult', totalCount: number, items: Array<
      | { __typename?: 'Organization' }
      | { __typename?: 'Ticket' }
      | { __typename?: 'User', id: string, internalId: number, fullname?: string | null, active?: boolean | null }
    > } };

export type SearchCountsQueryVariables = Exact<{
  search: Scalars['String']['input'];
  onlyIn: Array<EnumSearchableModels> | EnumSearchableModels;
}>;


export type SearchCountsQuery = { __typename?: 'Queries', searchCounts: Array<{ __typename?: 'SearchCountsResult', model: EnumSearchableModels, totalCount: number }> };

export type TicketInfoForPopoverQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketInfoForPopoverQuery = { __typename?: 'Queries', ticket: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, stateColorCode: EnumTicketStateColorCode, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null }, priority: { __typename?: 'TicketPriority', id: string, name: string } } };

export type UserInfoForPopoverQueryVariables = Exact<{
  userId: Scalars['ID']['input'];
  secondaryOrganizationsCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type UserInfoForPopoverQuery = { __typename?: 'Queries', user: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, image?: string | null, email?: string | null, web?: string | null, vip?: boolean | null, phone?: string | null, mobile?: string | null, fax?: string | null, note?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null } | null, secondaryOrganizations?: { __typename?: 'OrganizationConnection', totalCount: number, edges: Array<{ __typename?: 'OrganizationEdge', node: { __typename?: 'Organization', id: string, internalId: number, active?: boolean | null, name?: string | null } }> } | null } };

export type CalendarIcsFileEventsQueryVariables = Exact<{
  fileId: Scalars['ID']['input'];
}>;


export type CalendarIcsFileEventsQuery = { __typename?: 'Queries', calendarIcsFileEvents: Array<{ __typename?: 'CalendarIcsFileEvent', title?: string | null, location?: string | null, startDate?: string | null, endDate?: string | null, organizer?: string | null, attendees?: Array<string> | null, description?: string | null }> };

export type ChannelEmailAddMutationVariables = Exact<{
  input: ChannelEmailAddInput;
}>;


export type ChannelEmailAddMutation = { __typename?: 'Mutations', channelEmailAdd?: { __typename?: 'ChannelEmailAddPayload', channel?: { __typename?: 'Channel', options?: any | null, group?: { __typename?: 'Group', id: string } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ChannelEmailGuessConfigurationMutationVariables = Exact<{
  emailAddress: Scalars['String']['input'];
  password: Scalars['String']['input'];
}>;


export type ChannelEmailGuessConfigurationMutation = { __typename?: 'Mutations', channelEmailGuessConfiguration?: { __typename?: 'ChannelEmailGuessConfigurationPayload', result: { __typename?: 'ChannelEmailGuessConfigurationResult', inboundConfiguration?: { __typename?: 'ChannelEmailInboundConfiguration', adapter: EnumChannelEmailInboundAdapter, host?: string | null, port?: number | null, ssl?: EnumChannelEmailSsl | null, user?: string | null, password?: string | null, sslVerify?: boolean | null, folder?: string | null } | null, outboundConfiguration?: { __typename?: 'ChannelEmailOutboundConfiguration', adapter: EnumChannelEmailOutboundAdapter, host?: string | null, port?: number | null, user?: string | null, password?: string | null, sslVerify?: boolean | null } | null, mailboxStats?: { __typename?: 'ChannelEmailInboundMailboxStats', contentMessages?: number | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ChannelEmailSetNotificationConfigurationMutationVariables = Exact<{
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
}>;


export type ChannelEmailSetNotificationConfigurationMutation = { __typename?: 'Mutations', channelEmailSetNotificationConfiguration?: { __typename?: 'ChannelEmailSetNotificationConfigurationPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ChannelEmailValidateConfigurationInboundMutationVariables = Exact<{
  inboundConfiguration: ChannelEmailInboundConfigurationInput;
}>;


export type ChannelEmailValidateConfigurationInboundMutation = { __typename?: 'Mutations', channelEmailValidateConfigurationInbound?: { __typename?: 'ChannelEmailValidateConfigurationInboundPayload', success?: boolean | null, mailboxStats?: { __typename?: 'ChannelEmailInboundMailboxStats', contentMessages?: number | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ChannelEmailValidateConfigurationOutboundMutationVariables = Exact<{
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
  emailAddress: Scalars['String']['input'];
}>;


export type ChannelEmailValidateConfigurationOutboundMutation = { __typename?: 'Mutations', channelEmailValidateConfigurationOutbound?: { __typename?: 'ChannelEmailValidateConfigurationOutboundPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ChannelEmailValidateConfigurationRoundtripMutationVariables = Exact<{
  inboundConfiguration: ChannelEmailInboundConfigurationInput;
  outboundConfiguration: ChannelEmailOutboundConfigurationInput;
  emailAddress: Scalars['String']['input'];
}>;


export type ChannelEmailValidateConfigurationRoundtripMutation = { __typename?: 'Mutations', channelEmailValidateConfigurationRoundtrip?: { __typename?: 'ChannelEmailValidateConfigurationRoundtripPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type EmailAddressesQueryVariables = Exact<{
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type EmailAddressesQuery = { __typename?: 'Queries', emailAddresses: Array<{ __typename?: 'EmailAddress', name: string, email: string, active: boolean }> };

export type TicketUpdateBulkMutationVariables = Exact<{
  ticketIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
  input: TicketUpdateInput;
  macroId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TicketUpdateBulkMutation = { __typename?: 'Mutations', ticketUpdateBulk?: { __typename?: 'TicketUpdateBulkPayload', success?: boolean | null, errors?: Array<{ __typename?: 'TicketUpdateBulkUserError', errorType: string, message: string, failedTicket?: { __typename?: 'Ticket', id: string, title: string, number: string } | null }> | null } | null };

export type UserCurrentOverviewUpdateLastUsedMutationVariables = Exact<{
  overviewsLastUsed: Array<UserCurrentOverviewLastUsed> | UserCurrentOverviewLastUsed;
}>;


export type UserCurrentOverviewUpdateLastUsedMutation = { __typename?: 'Mutations', userCurrentOverviewUpdateLastUsed?: { __typename?: 'UserCurrentOverviewUpdateLastUsedPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type OverviewsWithCachedCountQueryVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
  filterOverviewIds?: InputMaybe<Array<Scalars['ID']['input']> | Scalars['ID']['input']>;
  cacheTtl: Scalars['Int']['input'];
}>;


export type OverviewsWithCachedCountQuery = { __typename?: 'Queries', ticketOverviews: Array<{ __typename?: 'Overview', id: string, cachedTicketCount: number }> };

export type TicketsByFilterQueryVariables = Exact<{
  customerId?: InputMaybe<Scalars['ID']['input']>;
  stateTypeCategory?: InputMaybe<EnumTicketStateTypeCategory>;
  pageSize?: InputMaybe<Scalars['Int']['input']>;
}>;


export type TicketsByFilterQuery = { __typename?: 'Queries', ticketsByFilter: { __typename?: 'TicketConnection', totalCount: number, edges: Array<{ __typename?: 'TicketEdge', node: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } } }> } };

export type TicketsCachedByOverviewQueryVariables = Exact<{
  overviewId: Scalars['ID']['input'];
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
  cursor?: InputMaybe<Scalars['String']['input']>;
  pageSize?: InputMaybe<Scalars['Int']['input']>;
  cacheTtl: Scalars['Int']['input'];
  renewCache?: InputMaybe<Scalars['Boolean']['input']>;
  knownCollectionSignature?: InputMaybe<Scalars['String']['input']>;
}>;


export type TicketsCachedByOverviewQuery = { __typename?: 'Queries', ticketsCachedByOverview: { __typename?: 'CachedTicketConnection', totalCount: number, collectionSignature: string, edges?: Array<{ __typename?: 'TicketEdge', cursor: string, node: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, updatedAt: string, aiAgentRunning?: boolean | null, pendingTime?: string | null, articleCount?: number | null, stateColorCode: EnumTicketStateColorCode, escalationAt?: string | null, firstResponseEscalationAt?: string | null, updateEscalationAt?: string | null, closeEscalationAt?: string | null, firstResponseAt?: string | null, closeAt?: string | null, timeUnit?: number | null, lastCloseAt?: string | null, lastContactAt?: string | null, lastContactAgentAt?: string | null, lastContactCustomerAt?: string | null, createdBy?: { __typename?: 'User', id: string, fullname?: string | null } | null, updatedBy?: { __typename?: 'User', id: string, fullname?: string | null } | null, owner: { __typename?: 'User', id: string, fullname?: string | null }, customer: { __typename?: 'User', id: string, fullname?: string | null }, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean } } }> | null, pageInfo: { __typename?: 'PageInfo', endCursor?: string | null, hasNextPage: boolean } } };

export type UserCurrentTicketOverviewsQueryVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
  withTicketCount: Scalars['Boolean']['input'];
}>;


export type UserCurrentTicketOverviewsQuery = { __typename?: 'Queries', userCurrentTicketOverviews: Array<{ __typename?: 'Overview', viewColumnsRaw: Array<string>, id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number }> };

export type UserCurrentTicketOverviewsCountQueryVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
  cacheTtl: Scalars['Int']['input'];
}>;


export type UserCurrentTicketOverviewsCountQuery = { __typename?: 'Queries', userCurrentTicketOverviews: Array<{ __typename?: 'Overview', id: string, cachedTicketCount: number }> };

export type UserCurrentOverviewOrderingFullAttributesUpdatesSubscriptionVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
  withTicketCount?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type UserCurrentOverviewOrderingFullAttributesUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentOverviewOrderingUpdates: { __typename?: 'UserCurrentOverviewOrderingUpdatesPayload', overviews?: Array<{ __typename?: 'Overview', viewColumnsRaw: Array<string>, id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number }> | null } };

export type UserCurrentOverviewOrderingUpdatesSubscriptionVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
}>;


export type UserCurrentOverviewOrderingUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentOverviewOrderingUpdates: { __typename?: 'UserCurrentOverviewOrderingUpdatesPayload', overviews?: Array<{ __typename?: 'Overview', id: string, name: string, organizationShared?: boolean | null, outOfOffice?: boolean | null }> | null } };

export type UserCurrentTicketOverviewFullAttributesUpdatesSubscriptionVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
  withTicketCount?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type UserCurrentTicketOverviewFullAttributesUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTicketOverviewUpdates: { __typename?: 'UserCurrentTicketOverviewUpdatesPayload', ticketOverviews?: Array<{ __typename?: 'Overview', viewColumnsRaw: Array<string>, id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number }> | null } };

export type UserCurrentTicketOverviewUpdatesSubscriptionVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
}>;


export type UserCurrentTicketOverviewUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTicketOverviewUpdates: { __typename?: 'UserCurrentTicketOverviewUpdatesPayload', ticketOverviews?: Array<{ __typename?: 'Overview', id: string, name: string }> | null } };

export type UserCurrentTaskbarItemAttributesFragment = { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
    | { __typename?: 'Organization', id: string, internalId: number }
    | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
    | { __typename?: 'User', id: string, internalId: number }
    | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
    | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
   | null };

export type UserCurrentPasswordCheckMutationVariables = Exact<{
  password: Scalars['String']['input'];
}>;


export type UserCurrentPasswordCheckMutation = { __typename?: 'Mutations', userCurrentPasswordCheck?: { __typename?: 'UserCurrentPasswordCheckPayload', success?: boolean | null, token?: string | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentRecentViewResetMutationVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentRecentViewResetMutation = { __typename?: 'Mutations', userCurrentRecentViewReset?: { __typename?: 'UserCurrentRecentViewResetPayload', success: boolean } | null };

export type UserCurrentTaskbarItemAddMutationVariables = Exact<{
  input: UserTaskbarItemInput;
}>;


export type UserCurrentTaskbarItemAddMutation = { __typename?: 'Mutations', userCurrentTaskbarItemAdd?: { __typename?: 'UserCurrentTaskbarItemAddPayload', taskbarItem?: { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
        | { __typename?: 'Organization', id: string, internalId: number }
        | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
        | { __typename?: 'User', id: string, internalId: number }
        | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
        | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
       | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTaskbarItemDeleteMutationVariables = Exact<{
  id: Scalars['ID']['input'];
}>;


export type UserCurrentTaskbarItemDeleteMutation = { __typename?: 'Mutations', userCurrentTaskbarItemDelete?: { __typename?: 'UserCurrentTaskbarItemDeletePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTaskbarItemListPrioMutationVariables = Exact<{
  list: Array<UserTaskbarItemListPrioInput> | UserTaskbarItemListPrioInput;
}>;


export type UserCurrentTaskbarItemListPrioMutation = { __typename?: 'Mutations', userCurrentTaskbarItemListPrio?: { __typename?: 'UserCurrentTaskbarItemListPrioPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTaskbarItemTouchLastContactMutationVariables = Exact<{
  id: Scalars['ID']['input'];
}>;


export type UserCurrentTaskbarItemTouchLastContactMutation = { __typename?: 'Mutations', userCurrentTaskbarItemTouchLastContact?: { __typename?: 'UserCurrentTaskbarItemTouchLastContactPayload', taskbarItem?: { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
        | { __typename?: 'Organization', id: string, internalId: number }
        | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
        | { __typename?: 'User', id: string, internalId: number }
        | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
        | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
       | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTaskbarItemUpdateMutationVariables = Exact<{
  id: Scalars['ID']['input'];
  input: UserTaskbarItemInput;
}>;


export type UserCurrentTaskbarItemUpdateMutation = { __typename?: 'Mutations', userCurrentTaskbarItemUpdate?: { __typename?: 'UserCurrentTaskbarItemUpdatePayload', taskbarItem?: { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
        | { __typename?: 'Organization', id: string, internalId: number }
        | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
        | { __typename?: 'User', id: string, internalId: number }
        | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
        | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
       | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTicketScreenBehaviorMutationVariables = Exact<{
  behavior: EnumTicketScreenBehavior;
}>;


export type UserCurrentTicketScreenBehaviorMutation = { __typename?: 'Mutations', userCurrentTicketScreenBehavior?: { __typename?: 'UserCurrentTicketScreenBehaviorPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentRecentViewListQueryVariables = Exact<{
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type UserCurrentRecentViewListQuery = { __typename?: 'Queries', userCurrentRecentViewList: Array<
    | { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null }
    | { __typename?: 'Ticket', id: string, internalId: number, title: string, number: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null } }
    | { __typename?: 'User', id: string, internalId: number, fullname?: string | null, active?: boolean | null }
  > };

export type UserCurrentTaskbarItemListQueryVariables = Exact<{
  app: EnumTaskbarApp;
}>;


export type UserCurrentTaskbarItemListQuery = { __typename?: 'Queries', userCurrentTaskbarItemList?: Array<{ __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
      | { __typename?: 'Organization', id: string, internalId: number }
      | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
      | { __typename?: 'User', id: string, internalId: number }
      | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
      | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
     | null }> | null };

export type UserCurrentRecentViewUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentRecentViewUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentRecentViewUpdates: { __typename?: 'UserCurrentRecentViewUpdatesPayload', recentViewsUpdated?: boolean | null } };

export type UserCurrentTaskbarItemListUpdatesSubscriptionVariables = Exact<{
  app: EnumTaskbarApp;
}>;


export type UserCurrentTaskbarItemListUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTaskbarItemListUpdates: { __typename?: 'UserCurrentTaskbarItemListUpdatesPayload', taskbarItemList?: Array<{ __typename?: 'UserTaskbarItem', id: string, prio: number }> | null } };

export type UserCurrentTaskbarItemStateUpdatesSubscriptionVariables = Exact<{
  taskbarItemId: Scalars['ID']['input'];
}>;


export type UserCurrentTaskbarItemStateUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTaskbarItemStateUpdates: { __typename?: 'UserCurrentTaskbarItemStateUpdatesPayload', stateChanged?: boolean | null } };

export type UserCurrentTaskbarItemUpdatesSubscriptionVariables = Exact<{
  app: EnumTaskbarApp;
}>;


export type UserCurrentTaskbarItemUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTaskbarItemUpdates: { __typename?: 'UserCurrentTaskbarItemUpdatesPayload', removeItem?: string | null, addItem?: { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
        | { __typename?: 'Organization', id: string, internalId: number }
        | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
        | { __typename?: 'User', id: string, internalId: number }
        | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
        | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
       | null } | null, updateItem?: { __typename?: 'UserTaskbarItem', id: string, key: string, callback: EnumTaskbarEntity, formId?: string | null, formNewArticlePresent: boolean, entityAccess?: EnumTaskbarEntityAccess | null, prio: number, changed: boolean, dirty: boolean, notify: boolean, updatedAt: string, entity?:
        | { __typename?: 'Organization', id: string, internalId: number }
        | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } }
        | { __typename?: 'User', id: string, internalId: number }
        | { __typename?: 'UserTaskbarItemEntitySearch', query?: string | null, model?: string | null }
        | { __typename?: 'UserTaskbarItemEntityTicketCreate', uid: string, title: string, createArticleTypeKey?: string | null }
       | null } | null } };

export type UserCurrentTwoFactorUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentTwoFactorUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentTwoFactorUpdates: { __typename?: 'UserCurrentTwoFactorUpdatesPayload', configuration?: { __typename?: 'UserConfigurationTwoFactor', recoveryCodesExist: boolean, enabledAuthenticationMethods: Array<{ __typename?: 'TwoFactorEnabledAuthenticationMethod', configured: boolean, authenticationMethod: EnumTwoFactorAuthenticationMethod }> } | null } };

export type AdminPasswordAuthSendMutationVariables = Exact<{
  login: Scalars['String']['input'];
}>;


export type AdminPasswordAuthSendMutation = { __typename?: 'Mutations', adminPasswordAuthSend?: { __typename?: 'AdminPasswordAuthSendPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AdminPasswordAuthVerifyMutationVariables = Exact<{
  token: Scalars['String']['input'];
}>;


export type AdminPasswordAuthVerifyMutation = { __typename?: 'Mutations', adminPasswordAuthVerify?: { __typename?: 'AdminPasswordAuthVerifyPayload', login?: string | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserPasswordResetSendMutationVariables = Exact<{
  username: Scalars['String']['input'];
}>;


export type UserPasswordResetSendMutation = { __typename?: 'Mutations', userPasswordResetSend?: { __typename?: 'UserPasswordResetSendPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserPasswordResetUpdateMutationVariables = Exact<{
  token: Scalars['String']['input'];
  password: Scalars['String']['input'];
}>;


export type UserPasswordResetUpdateMutation = { __typename?: 'Mutations', userPasswordResetUpdate?: { __typename?: 'UserPasswordResetUpdatePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserPasswordResetVerifyMutationVariables = Exact<{
  token: Scalars['String']['input'];
}>;


export type UserPasswordResetVerifyMutation = { __typename?: 'Mutations', userPasswordResetVerify?: { __typename?: 'UserPasswordResetVerifyPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserSignupMutationVariables = Exact<{
  input: UserSignupInput;
}>;


export type UserSignupMutation = { __typename?: 'Mutations', userSignup?: { __typename?: 'UserSignupPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserSignupResendMutationVariables = Exact<{
  email: Scalars['String']['input'];
}>;


export type UserSignupResendMutation = { __typename?: 'Mutations', userSignupResend?: { __typename?: 'UserSignupResendPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserSignupVerifyMutationVariables = Exact<{
  token: Scalars['String']['input'];
}>;


export type UserSignupVerifyMutation = { __typename?: 'Mutations', userSignupVerify?: { __typename?: 'UserSignupVerifyPayload', session?: { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type GuidedSetupSetSystemInformationMutationVariables = Exact<{
  input: SystemInformation;
}>;


export type GuidedSetupSetSystemInformationMutation = { __typename?: 'Mutations', guidedSetupSetSystemInformation?: { __typename?: 'GuidedSetupSetSystemInformationPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemImportConfigurationMutationVariables = Exact<{
  configuration: SystemImportConfigurationInput;
}>;


export type SystemImportConfigurationMutation = { __typename?: 'Mutations', systemImportConfiguration?: { __typename?: 'SystemImportConfigurationPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemImportStartMutationVariables = Exact<{ [key: string]: never; }>;


export type SystemImportStartMutation = { __typename?: 'Mutations', systemImportStart?: { __typename?: 'SystemImportStartPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemSetupLockMutationVariables = Exact<{
  ttl?: InputMaybe<Scalars['Int']['input']>;
}>;


export type SystemSetupLockMutation = { __typename?: 'Mutations', systemSetupLock?: { __typename?: 'SystemSetupLockPayload', resource?: string | null, value?: string | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemSetupRunAutoWizardMutationVariables = Exact<{
  token?: InputMaybe<Scalars['String']['input']>;
}>;


export type SystemSetupRunAutoWizardMutation = { __typename?: 'Mutations', systemSetupRunAutoWizard?: { __typename?: 'SystemSetupRunAutoWizardPayload', session?: { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemSetupUnlockMutationVariables = Exact<{
  value: Scalars['String']['input'];
}>;


export type SystemSetupUnlockMutation = { __typename?: 'Mutations', systemSetupUnlock?: { __typename?: 'SystemSetupUnlockPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserAddFirstAdminMutationVariables = Exact<{
  input: UserSignupInput;
}>;


export type UserAddFirstAdminMutation = { __typename?: 'Mutations', userAddFirstAdmin?: { __typename?: 'UserAddFirstAdminPayload', session?: { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type SystemImportStateQueryVariables = Exact<{ [key: string]: never; }>;


export type SystemImportStateQuery = { __typename?: 'Queries', systemImportState?: { __typename?: 'ImportJob', name: string, result?: any | null, startedAt?: string | null, finishedAt?: string | null } | null };

export type SystemSetupInfoQueryVariables = Exact<{ [key: string]: never; }>;


export type SystemSetupInfoQuery = { __typename?: 'Queries', systemSetupInfo: { __typename?: 'SystemSetupInfo', status: EnumSystemSetupInfoStatus, type?: EnumSystemSetupInfoType | null } };

export type UserCalendarSubscriptionAttributesFragment = { __typename?: 'UserPersonalSettingsCalendarSubscriptionsConfig', combinedUrl?: string | null, globalOptions?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionGlobalOptions', alarm?: boolean | null } | null, newOpen?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null, pending?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null };

export type UserDeviceAttributesFragment = { __typename?: 'UserDevice', id: string, userId: string, name: string, os?: string | null, browser?: string | null, location?: string | null, deviceDetails?: any | null, locationDetails?: any | null, fingerprint?: string | null, userAgent?: string | null, ip?: string | null, createdAt: string, updatedAt: string };

export type UserCurrentAppearanceMutationVariables = Exact<{
  theme: EnumAppearanceTheme;
}>;


export type UserCurrentAppearanceMutation = { __typename?: 'Mutations', userCurrentAppearance?: { __typename?: 'UserCurrentAppearancePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentAvatarSelectMutationVariables = Exact<{
  id: Scalars['ID']['input'];
}>;


export type UserCurrentAvatarSelectMutation = { __typename?: 'Mutations', userCurrentAvatarSelect?: { __typename?: 'UserCurrentAvatarSelectPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentCalendarSubscriptionUpdateMutationVariables = Exact<{
  input: UserCalendarSubscriptionsConfigInput;
}>;


export type UserCurrentCalendarSubscriptionUpdateMutation = { __typename?: 'Mutations', userCurrentCalendarSubscriptionUpdate?: { __typename?: 'UserCurrentCalendarSubscriptionUpdatePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentChangePasswordMutationVariables = Exact<{
  currentPassword: Scalars['String']['input'];
  newPassword: Scalars['String']['input'];
}>;


export type UserCurrentChangePasswordMutation = { __typename?: 'Mutations', userCurrentChangePassword?: { __typename?: 'UserCurrentChangePasswordPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentDeviceDeleteMutationVariables = Exact<{
  deviceId: Scalars['ID']['input'];
}>;


export type UserCurrentDeviceDeleteMutation = { __typename?: 'Mutations', userCurrentDeviceDelete?: { __typename?: 'UserCurrentDeviceDeletePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentRemoveLinkedAccountMutationVariables = Exact<{
  provider: EnumAuthenticationProvider;
  uid: Scalars['String']['input'];
}>;


export type UserCurrentRemoveLinkedAccountMutation = { __typename?: 'Mutations', userCurrentRemoveLinkedAccount?: { __typename?: 'UserCurrentRemoveLinkedAccountPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentNotificationPreferencesResetMutationVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentNotificationPreferencesResetMutation = { __typename?: 'Mutations', userCurrentNotificationPreferencesReset?: { __typename?: 'UserCurrentNotificationPreferencesResetPayload', user: { __typename?: 'User', personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentNotificationPreferencesUpdateMutationVariables = Exact<{
  groupIds?: InputMaybe<Array<Scalars['ID']['input']> | Scalars['ID']['input']>;
  matrix: UserNotificationMatrixInput;
  sound: UserNotificationSoundInput;
}>;


export type UserCurrentNotificationPreferencesUpdateMutation = { __typename?: 'Mutations', userCurrentNotificationPreferencesUpdate?: { __typename?: 'UserCurrentNotificationPreferencesUpdatePayload', user: { __typename?: 'User', personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentOutOfOfficeMutationVariables = Exact<{
  input: OutOfOfficeInput;
}>;


export type UserCurrentOutOfOfficeMutation = { __typename?: 'Mutations', userCurrentOutOfOffice?: { __typename?: 'UserCurrentOutOfOfficePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentOverviewResetOrderMutationVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentOverviewResetOrderMutation = { __typename?: 'Mutations', userCurrentOverviewResetOrder?: { __typename?: 'UserCurrentOverviewResetOrderPayload', success: boolean, overviews?: Array<{ __typename?: 'Overview', id: string, name: string }> | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentOverviewUpdateOrderMutationVariables = Exact<{
  overviewIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;


export type UserCurrentOverviewUpdateOrderMutation = { __typename?: 'Mutations', userCurrentOverviewUpdateOrder?: { __typename?: 'UserCurrentOverviewUpdateOrderPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentAvatarListQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentAvatarListQuery = { __typename?: 'Queries', userCurrentAvatarList?: Array<{ __typename?: 'Avatar', id: string, default: boolean, deletable: boolean, initial: boolean, imageHash?: string | null, createdAt: string, updatedAt: string }> | null };

export type UserCurrentCalendarSubscriptionListQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentCalendarSubscriptionListQuery = { __typename?: 'Queries', userCurrentCalendarSubscriptionList: { __typename?: 'UserPersonalSettingsCalendarSubscriptionsConfig', combinedUrl?: string | null, globalOptions?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionGlobalOptions', alarm?: boolean | null } | null, newOpen?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null, pending?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingle', url?: string | null, options?: { __typename?: 'UserPersonalSettingsCalendarSubscriptionSingleOptions', own?: boolean | null, notAssigned?: boolean | null } | null } | null } };

export type UserCurrentDeviceListQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentDeviceListQuery = { __typename?: 'Queries', userCurrentDeviceList?: Array<{ __typename?: 'UserDevice', id: string, userId: string, name: string, os?: string | null, browser?: string | null, location?: string | null, deviceDetails?: any | null, locationDetails?: any | null, fingerprint?: string | null, userAgent?: string | null, ip?: string | null, createdAt: string, updatedAt: string }> | null };

export type UserCurrentOverviewListQueryVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
}>;


export type UserCurrentOverviewListQuery = { __typename?: 'Queries', userCurrentTicketOverviews: Array<{ __typename?: 'Overview', id: string, name: string, organizationShared?: boolean | null, outOfOffice?: boolean | null }> };

export type UserCurrentAccessTokenUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentAccessTokenUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentAccessTokenUpdates: { __typename?: 'UserCurrentAccessTokenUpdatesPayload', tokens?: Array<{ __typename?: 'Token', id: string, name?: string | null, preferences?: any | null, expiresAt?: string | null, lastUsedAt?: string | null, createdAt: string, user?: { __typename?: 'User', id: string } | null }> | null } };

export type UserCurrentAvatarUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentAvatarUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentAvatarUpdates: { __typename?: 'UserCurrentAvatarUpdatesPayload', avatars?: Array<{ __typename?: 'Avatar', id: string, default: boolean, deletable: boolean, initial: boolean, imageHash?: string | null, createdAt: string, updatedAt: string }> | null } };

export type UserCurrentDevicesUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentDevicesUpdatesSubscription = { __typename?: 'Subscriptions', userCurrentDevicesUpdates: { __typename?: 'UserCurrentDevicesUpdatesPayload', devices?: Array<{ __typename?: 'UserDevice', id: string, userId: string, name: string, os?: string | null, browser?: string | null, location?: string | null, deviceDetails?: any | null, locationDetails?: any | null, fingerprint?: string | null, userAgent?: string | null, ip?: string | null, createdAt: string, updatedAt: string }> | null } };

export type AiAssistantAnalyticsMetaFragment = { __typename?: 'AIAnalyticsMetadata', run?: { __typename?: 'AIAnalyticsRun', id: string } | null, usage?: { __typename?: 'AIAnalyticsUsage', userHasProvidedFeedback?: boolean | null } | null };

export type IdoitObjectAttributesFragment = { __typename?: 'TicketExternalReferencesIdoitObject', idoitObjectId: number, link?: string | null, title: string, type: string, status: string };

export type LinkAddMutationVariables = Exact<{
  input: LinkInput;
}>;


export type LinkAddMutation = { __typename?: 'Mutations', linkAdd?: { __typename?: 'LinkAddPayload', link?: { __typename?: 'Link', type: EnumLinkType, item:
        | { __typename?: 'KnowledgeBaseAnswerTranslation', id: string }
        | { __typename?: 'Ticket', id: string, internalId: number, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }
       } | null, errors?: Array<{ __typename?: 'UserError', message: string, field?: string | null }> | null } | null };

export type LinkRemoveMutationVariables = Exact<{
  input: LinkInput;
}>;


export type LinkRemoveMutation = { __typename?: 'Mutations', linkRemove?: { __typename?: 'LinkRemovePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, field?: string | null }> | null } | null };

export type TicketAiAssistanceSummarizeMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  regenerationOfId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TicketAiAssistanceSummarizeMutation = { __typename?: 'Mutations', ticketAIAssistanceSummarize?: { __typename?: 'TicketAIAssistanceSummarizePayload', summary?: { __typename?: 'TicketAIAssistanceSummary', customerRequest?: string | null, conversationSummary?: string | null, openQuestions?: Array<string> | null, upcomingEvents?: Array<string> | null, customerMood?: string | null, customerEmotion?: string | null } | null, analytics?: { __typename?: 'AIAnalyticsMetadata', isUnread?: boolean | null, run?: { __typename?: 'AIAnalyticsRun', id: string } | null, usage?: { __typename?: 'AIAnalyticsUsage', userHasProvidedFeedback?: boolean | null } | null } | null } | null };

export type TicketChecklistAddMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  templateId?: InputMaybe<Scalars['ID']['input']>;
  createFirstItem?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type TicketChecklistAddMutation = { __typename?: 'Mutations', ticketChecklistAdd?: { __typename?: 'TicketChecklistAddPayload', checklist?: { __typename?: 'Checklist', id: string, name?: string | null, items: Array<{ __typename?: 'ChecklistItem', id: string, text: string, checked: boolean }> } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketChecklistDeleteMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
}>;


export type TicketChecklistDeleteMutation = { __typename?: 'Mutations', ticketChecklistDelete?: { __typename?: 'TicketChecklistDeletePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketChecklistItemDeleteMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
  checklistItemId: Scalars['ID']['input'];
}>;


export type TicketChecklistItemDeleteMutation = { __typename?: 'Mutations', ticketChecklistItemDelete?: { __typename?: 'TicketChecklistItemDeletePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketChecklistItemOrderUpdateMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
  order: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;


export type TicketChecklistItemOrderUpdateMutation = { __typename?: 'Mutations', ticketChecklistItemOrderUpdate?: { __typename?: 'TicketChecklistItemOrderUpdatePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketChecklistItemUpsertMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
  checklistItemId?: InputMaybe<Scalars['ID']['input']>;
  input: TicketChecklistItemInput;
}>;


export type TicketChecklistItemUpsertMutation = { __typename?: 'Mutations', ticketChecklistItemUpsert?: { __typename?: 'TicketChecklistItemUpsertPayload', checklistItem: { __typename?: 'ChecklistItem', id: string, text: string, checked: boolean, ticketReference?: { __typename?: 'TicketReference', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } } | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketChecklistItemsAddMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
  input: Array<TicketChecklistItemInput> | TicketChecklistItemInput;
}>;


export type TicketChecklistItemsAddMutation = { __typename?: 'Mutations', ticketChecklistItemsAdd?: { __typename?: 'TicketChecklistItemsAddPayload', success: boolean } | null };

export type TicketChecklistTitleUpdateMutationVariables = Exact<{
  checklistId: Scalars['ID']['input'];
  title?: InputMaybe<Scalars['String']['input']>;
}>;


export type TicketChecklistTitleUpdateMutation = { __typename?: 'Mutations', ticketChecklistTitleUpdate?: { __typename?: 'TicketChecklistTitleUpdatePayload', checklist?: { __typename?: 'Checklist', id: string, name?: string | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketExternalReferencesIdoitObjectAddMutationVariables = Exact<{
  idoitObjectIds: Array<Scalars['Int']['input']> | Scalars['Int']['input'];
  ticketId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TicketExternalReferencesIdoitObjectAddMutation = { __typename?: 'Mutations', ticketExternalReferencesIdoitObjectAdd?: { __typename?: 'TicketExternalReferencesIdoitObjectAddPayload', idoitObjects?: Array<{ __typename?: 'TicketExternalReferencesIdoitObject', idoitObjectId: number, link?: string | null, title: string, type: string, status: string }> | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketExternalReferencesIdoitObjectRemoveMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  idoitObjectId: Scalars['Int']['input'];
}>;


export type TicketExternalReferencesIdoitObjectRemoveMutation = { __typename?: 'Mutations', ticketExternalReferencesIdoitObjectRemove?: { __typename?: 'TicketExternalReferencesIdoitObjectRemovePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketExternalReferencesIssueTrackerItemAddMutationVariables = Exact<{
  issueTrackerLink: Scalars['UriHttpString']['input'];
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TicketExternalReferencesIssueTrackerItemAddMutation = { __typename?: 'Mutations', ticketExternalReferencesIssueTrackerItemAdd?: { __typename?: 'TicketExternalReferencesIssueTrackerItemAddPayload', issueTrackerItem?: { __typename?: 'TicketExternalReferencesIssueTrackerItem', assignees?: Array<string> | null, issueId: number, milestone?: string | null, state: EnumTicketExternalReferencesIssueTrackerItemState, title: string, url: string, labels?: Array<{ __typename?: 'TicketExternalReferencesIssueTrackerItemLabel', color: string, textColor: string, title: string }> | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketExternalReferencesIssueTrackerItemRemoveMutationVariables = Exact<{
  issueTrackerLink: Scalars['UriHttpString']['input'];
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
  ticketId: Scalars['ID']['input'];
}>;


export type TicketExternalReferencesIssueTrackerItemRemoveMutation = { __typename?: 'Mutations', ticketExternalReferencesIssueTrackerItemRemove?: { __typename?: 'TicketExternalReferencesIssueTrackerItemRemovePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AutocompleteSearchIdoitObjectTypesQueryVariables = Exact<{
  input: AutocompleteSearchInput;
}>;


export type AutocompleteSearchIdoitObjectTypesQuery = { __typename?: 'Queries', autocompleteSearchIdoitObjectTypes: Array<{ __typename?: 'AutocompleteSearchEntry', value: string, label: string }> };

export type ChecklistTemplatesQueryVariables = Exact<{
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type ChecklistTemplatesQuery = { __typename?: 'Queries', checklistTemplates: Array<{ __typename?: 'ChecklistTemplate', id: string, name?: string | null, active?: boolean | null }> };

export type LinkListQueryVariables = Exact<{
  objectId: Scalars['ID']['input'];
  targetType: Scalars['String']['input'];
}>;


export type LinkListQuery = { __typename?: 'Queries', linkList?: Array<{ __typename?: 'Link', type: EnumLinkType, item:
      | { __typename?: 'KnowledgeBaseAnswerTranslation', id: string }
      | { __typename?: 'Ticket', id: string, internalId: number, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }
     }> | null };

export type TemplatesQueryVariables = Exact<{
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type TemplatesQuery = { __typename?: 'Queries', templates: Array<{ __typename?: 'Template', id: string, name: string }> };

export type TicketAttachmentsQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketAttachmentsQuery = { __typename?: 'Queries', ticketAttachments: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null, preferences?: any | null }> };

export type TicketChecklistQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketChecklistQuery = { __typename?: 'Queries', ticketChecklist?: { __typename?: 'Checklist', id: string, name?: string | null, completed: boolean, incomplete: number, items: Array<{ __typename?: 'ChecklistItem', id: string, text: string, checked: boolean, ticketReference?: { __typename?: 'TicketReference', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } } | null } | null }> } | null };

export type TicketExternalReferencesIdoitObjectListQueryVariables = Exact<{
  ticketId?: InputMaybe<Scalars['ID']['input']>;
  idoitObjectIds?: InputMaybe<Array<Scalars['Int']['input']> | Scalars['Int']['input']>;
}>;


export type TicketExternalReferencesIdoitObjectListQuery = { __typename?: 'Queries', ticketExternalReferencesIdoitObjectList: Array<{ __typename?: 'TicketExternalReferencesIdoitObject', idoitObjectId: number, link?: string | null, title: string, type: string, status: string }> };

export type TicketExternalReferencesIdoitObjectSearchQueryVariables = Exact<{
  idoitTypeId?: InputMaybe<Scalars['String']['input']>;
  limit: Scalars['Int']['input'];
  query?: InputMaybe<Scalars['String']['input']>;
}>;


export type TicketExternalReferencesIdoitObjectSearchQuery = { __typename?: 'Queries', ticketExternalReferencesIdoitObjectSearch: Array<{ __typename?: 'TicketExternalReferencesIdoitObject', idoitObjectId: number, link?: string | null, title: string, type: string, status: string }> };

export type TicketExternalReferencesIssueTrackerItemListQueryVariables = Exact<{
  issueTrackerType: EnumTicketExternalReferencesIssueTrackerType;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
  issueTrackerLinks?: InputMaybe<Array<Scalars['UriHttpString']['input']> | Scalars['UriHttpString']['input']>;
}>;


export type TicketExternalReferencesIssueTrackerItemListQuery = { __typename?: 'Queries', ticketExternalReferencesIssueTrackerItemList: Array<{ __typename?: 'TicketExternalReferencesIssueTrackerItem', assignees?: Array<string> | null, issueId: number, milestone?: string | null, state: EnumTicketExternalReferencesIssueTrackerItemState, title: string, url: string, labels?: Array<{ __typename?: 'TicketExternalReferencesIssueTrackerItemLabel', color: string, textColor: string, title: string }> | null }> };

export type TicketHistoryQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketHistoryQuery = { __typename?: 'Queries', ticketHistory: Array<{ __typename?: 'HistoryGroup', createdAt: string, records: Array<{ __typename?: 'HistoryRecord', issuer:
        | { __typename?: 'AIAgent', id: string, name: string }
        | { __typename?: 'Job', id: string, name: string }
        | { __typename?: 'Macro', id: string, name: string }
        | { __typename?: 'ObjectClass', klass?: string | null, info?: string | null }
        | { __typename?: 'PostmasterFilter', id: string, name: string }
        | { __typename?: 'Trigger', id: string, name: string }
        | { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, email?: string | null, image?: string | null }
      , events: Array<{ __typename?: 'HistoryRecordEvent', createdAt: string, action: string, attribute?: string | null, changes?: any | null, object:
          | { __typename?: 'Checklist', id: string, name?: string | null }
          | { __typename?: 'ChecklistItem', id: string, text: string, checked: boolean }
          | { __typename?: 'Group', id: string, name?: string | null }
          | { __typename?: 'Mention', id: string, user: { __typename?: 'User', id: string, fullname?: string | null } }
          | { __typename?: 'ObjectClass', klass?: string | null, info?: string | null }
          | { __typename?: 'Organization', id: string, name?: string | null }
          | { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string }
          | { __typename?: 'TicketArticle', id: string, body: string }
          | { __typename?: 'TicketSharedDraftZoom', id: string }
          | { __typename?: 'User', id: string, fullname?: string | null }
         }> }> }> };

export type TicketRelationAndRecentTicketListsQueryVariables = Exact<{
  ticketId: Scalars['Int']['input'];
  customerId: Scalars['ID']['input'];
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type TicketRelationAndRecentTicketListsQuery = { __typename?: 'Queries', ticketsRecentByCustomer: Array<{ __typename?: 'Ticket', number: string, internalId: number, id: string, title: string, createdAt: string, stateColorCode: EnumTicketStateColorCode, customer: { __typename?: 'User', id: string, fullname?: string | null }, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, group: { __typename?: 'Group', id: string, name?: string | null }, state: { __typename?: 'TicketState', id: string, name: string } }>, ticketsRecentlyViewed: Array<{ __typename?: 'Ticket', number: string, internalId: number, id: string, title: string, createdAt: string, stateColorCode: EnumTicketStateColorCode, customer: { __typename?: 'User', id: string, fullname?: string | null }, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, group: { __typename?: 'Group', id: string, name?: string | null }, state: { __typename?: 'TicketState', id: string, name: string } }> };

export type ChecklistTemplateUpdatesSubscriptionVariables = Exact<{
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type ChecklistTemplateUpdatesSubscription = { __typename?: 'Subscriptions', checklistTemplateUpdates: { __typename?: 'ChecklistTemplateUpdatesPayload', checklistTemplates?: Array<{ __typename?: 'ChecklistTemplate', id: string, name?: string | null, active?: boolean | null }> | null } };

export type LinkUpdatesSubscriptionVariables = Exact<{
  objectId: Scalars['ID']['input'];
  targetType: Scalars['String']['input'];
}>;


export type LinkUpdatesSubscription = { __typename?: 'Subscriptions', linkUpdates: { __typename?: 'LinkUpdatesPayload', links?: Array<{ __typename?: 'Link', type: EnumLinkType, item:
        | { __typename?: 'KnowledgeBaseAnswerTranslation', id: string }
        | { __typename?: 'Ticket', id: string, internalId: number, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }
       }> | null } };

export type TemplateUpdatesSubscriptionVariables = Exact<{
  onlyActive: Scalars['Boolean']['input'];
}>;


export type TemplateUpdatesSubscription = { __typename?: 'Subscriptions', templateUpdates: { __typename?: 'TemplateUpdatesPayload', templates?: Array<{ __typename?: 'Template', id: string, name: string }> | null } };

export type TicketAiAssistanceSummaryUpdatesSubscriptionVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  locale: Scalars['String']['input'];
}>;


export type TicketAiAssistanceSummaryUpdatesSubscription = { __typename?: 'Subscriptions', ticketAIAssistanceSummaryUpdates: { __typename?: 'TicketAIAssistanceSummaryUpdatesPayload', summary?: { __typename?: 'TicketAIAssistanceSummary', customerRequest?: string | null, conversationSummary?: string | null, openQuestions?: Array<string> | null, upcomingEvents?: Array<string> | null, customerMood?: string | null, customerEmotion?: string | null } | null, error?: { __typename?: 'AsyncExecutionError', message: string, exception: string } | null, analytics?: { __typename?: 'AIAnalyticsMetadata', isUnread?: boolean | null, run?: { __typename?: 'AIAnalyticsRun', id: string } | null, usage?: { __typename?: 'AIAnalyticsUsage', userHasProvidedFeedback?: boolean | null } | null } | null } };

export type TicketChecklistUpdatesSubscriptionVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketChecklistUpdatesSubscription = { __typename?: 'Subscriptions', ticketChecklistUpdates: { __typename?: 'TicketChecklistUpdatesPayload', removedTicketChecklist?: boolean | null, ticketChecklist?: { __typename?: 'Checklist', id: string, name?: string | null, completed: boolean, incomplete: number, items: Array<{ __typename?: 'ChecklistItem', id: string, text: string, checked: boolean, ticketReference?: { __typename?: 'TicketReference', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } } | null } | null }> } | null } };

export type OrganizationUpdateMutationVariables = Exact<{
  id: Scalars['ID']['input'];
  input: OrganizationInput;
}>;


export type OrganizationUpdateMutation = { __typename?: 'Mutations', organizationUpdate?: { __typename?: 'OrganizationUpdatePayload', organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketOverviewOrderQueryVariables = Exact<{
  withTicketCount?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type TicketOverviewOrderQuery = { __typename?: 'Queries', ticketOverviews: Array<{ __typename?: 'Overview', id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number, viewColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }>, orderColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }> }> };

export type TicketOverviewTicketCountQueryVariables = Exact<{
  ignoreUserConditions: Scalars['Boolean']['input'];
}>;


export type TicketOverviewTicketCountQuery = { __typename?: 'Queries', ticketOverviews: Array<{ __typename?: 'Overview', id: string, ticketCount: number }> };

export type TicketOverviewsQueryVariables = Exact<{
  withTicketCount: Scalars['Boolean']['input'];
}>;


export type TicketOverviewsQuery = { __typename?: 'Queries', ticketOverviews: Array<{ __typename?: 'Overview', id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number, viewColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }>, orderColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }> }> };

export type TicketWithMentionLimitQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  mentionsCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type TicketWithMentionLimitQuery = { __typename?: 'Queries', ticket: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, createArticleType?: { __typename?: 'TicketArticleType', id: string, name?: string | null } | null, mentions?: { __typename?: 'MentionConnection', totalCount: number, edges: Array<{ __typename?: 'MentionEdge', cursor: string, node: { __typename?: 'Mention', user: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, userTicketAccess: { __typename?: 'PolicyMentionUserTicketAccess', agentReadAccess: boolean } } }> } | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } };

export type TicketOverviewUpdatesSubscriptionVariables = Exact<{
  ignoreUserConditions?: InputMaybe<Scalars['Boolean']['input']>;
  withTicketCount: Scalars['Boolean']['input'];
}>;


export type TicketOverviewUpdatesSubscription = { __typename?: 'Subscriptions', ticketOverviewUpdates: { __typename?: 'TicketOverviewUpdatesPayload', ticketOverviews?: Array<{ __typename?: 'Overview', id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number, viewColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }>, orderColumns: Array<{ __typename?: 'KeyValue', key: string, value?: string | null }> }> | null } };

export type UserCurrentAvatarActiveQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentAvatarActiveQuery = { __typename?: 'Queries', userCurrentAvatarActive?: { __typename?: 'Avatar', id: string, default: boolean, deletable: boolean, initial: boolean, imageFull?: string | null, imageResize?: string | null, createdAt: string, updatedAt: string } | null };

export type SearchQueryVariables = Exact<{
  search: Scalars['String']['input'];
  onlyIn: EnumSearchableModels;
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type SearchQuery = { __typename?: 'Queries', search: { __typename?: 'SearchResult', totalCount: number, items: Array<
      | { __typename?: 'Organization', id: string, internalId: number, active?: boolean | null, name?: string | null, vip?: boolean | null, updatedAt: string, members?: { __typename?: 'UserConnection', totalCount: number, edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, fullname?: string | null } }> } | null, updatedBy?: { __typename?: 'User', id: string, fullname?: string | null } | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null }
      | { __typename?: 'Ticket', id: string, internalId: number, title: string, number: string, updatedAt: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string }, priority: { __typename?: 'TicketPriority', name: string, defaultCreate: boolean, uiColor?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, fullname?: string | null }, updatedBy?: { __typename?: 'User', id: string, fullname?: string | null } | null }
      | { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, image?: string | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, vip?: boolean | null, updatedAt: string, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null } | null, updatedBy?: { __typename?: 'User', id: string, fullname?: string | null } | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null }
    > } };

export type TicketLiveUserDeleteMutationVariables = Exact<{
  id: Scalars['ID']['input'];
  app: EnumTaskbarApp;
}>;


export type TicketLiveUserDeleteMutation = { __typename?: 'Mutations', ticketLiveUserDelete?: { __typename?: 'TicketLiveUserDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketLiveUserUpsertMutationVariables = Exact<{
  id: Scalars['ID']['input'];
  app: EnumTaskbarApp;
  editing: Scalars['Boolean']['input'];
}>;


export type TicketLiveUserUpsertMutation = { __typename?: 'Mutations', ticketLiveUserUpsert?: { __typename?: 'TicketLiveUserUpsertPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketsByOverviewSlimQueryVariables = Exact<{
  overviewId: Scalars['ID']['input'];
  orderBy?: InputMaybe<Scalars['String']['input']>;
  orderDirection?: InputMaybe<EnumOrderDirection>;
  cursor?: InputMaybe<Scalars['String']['input']>;
  showPriority: Scalars['Boolean']['input'];
  showUpdatedBy: Scalars['Boolean']['input'];
  pageSize?: InputMaybe<Scalars['Int']['input']>;
  withObjectAttributes?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type TicketsByOverviewSlimQuery = { __typename?: 'Queries', ticketsByOverview: { __typename?: 'TicketConnection', totalCount: number, edges: Array<{ __typename?: 'TicketEdge', cursor: string, node: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, updatedAt: string, aiAgentRunning?: boolean | null, stateColorCode: EnumTicketStateColorCode, updatedBy?: { __typename?: 'User', id: string, fullname?: string | null } | null, customer: { __typename?: 'User', id: string, firstname?: string | null, lastname?: string | null, fullname?: string | null }, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null }, priority?: { __typename?: 'TicketPriority', id: string, name: string, uiColor?: string | null, defaultCreate: boolean }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } }>, pageInfo: { __typename?: 'PageInfo', endCursor?: string | null, hasNextPage: boolean } } };

export type UserUpdateMutationVariables = Exact<{
  id: Scalars['ID']['input'];
  input: UserInput;
}>;


export type UserUpdateMutation = { __typename?: 'Mutations', userUpdate?: { __typename?: 'UserUpdatePayload', user?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AutocompleteSearchAgentQueryVariables = Exact<{
  input: AutocompleteSearchUserInput;
}>;


export type AutocompleteSearchAgentQuery = { __typename?: 'Queries', autocompleteSearchAgent: Array<{ __typename?: 'AutocompleteSearchUserEntry', value: number, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, icon?: string | null, user: { __typename?: 'User', vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } }> };

export type AutocompleteSearchGenericQueryVariables = Exact<{
  input: AutocompleteSearchGenericInput;
  membersCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type AutocompleteSearchGenericQuery = { __typename?: 'Queries', autocompleteSearchGeneric: Array<{ __typename?: 'AutocompleteSearchGenericEntry', value: number, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, object:
      | { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, allMembers?: { __typename?: 'UserConnection', edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, internalId: number, login?: string | null, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null, hasSecondaryOrganizations?: boolean | null } }> } | null }
      | { __typename?: 'Ticket' }
      | { __typename?: 'User', id: string, internalId: number, login?: string | null, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null } | null }
     }> };

export type AutocompleteSearchUserQueryVariables = Exact<{
  input: AutocompleteSearchUserInput;
}>;


export type AutocompleteSearchUserQuery = { __typename?: 'Queries', autocompleteSearchUser: Array<{ __typename?: 'AutocompleteSearchUserEntry', value: number, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, icon?: string | null, user: { __typename?: 'User', vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } }> };

export type KnowledgeBaseAnswerSuggestionContentTransformMutationVariables = Exact<{
  translationId: Scalars['ID']['input'];
  formId: Scalars['FormId']['input'];
}>;


export type KnowledgeBaseAnswerSuggestionContentTransformMutation = { __typename?: 'Mutations', knowledgeBaseAnswerSuggestionContentTransform?: { __typename?: 'KnowledgeBaseAnswerSuggestionContentTransformPayload', body?: string | null, attachments?: Array<{ __typename?: 'StoredFile', id: string, name: string, size?: number | null, type?: string | null, preferences?: any | null }> | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AiAssistanceTextToolsListQueryVariables = Exact<{
  groupId?: InputMaybe<Scalars['ID']['input']>;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type AiAssistanceTextToolsListQuery = { __typename?: 'Queries', aiAssistanceTextToolsList: Array<{ __typename?: 'AITextTool', id: string, name: string, active: boolean }> };

export type KnowledgeBaseAnswerSuggestionsQueryVariables = Exact<{
  query: Scalars['String']['input'];
}>;


export type KnowledgeBaseAnswerSuggestionsQuery = { __typename?: 'Queries', knowledgeBaseAnswerSuggestions?: Array<{ __typename?: 'KnowledgeBaseAnswerTranslation', id: string, title: string, maybeLocale?: string | null, categoryTreeTranslation: Array<{ __typename?: 'KnowledgeBaseCategoryTranslation', id: string, title: string }> }> | null };

export type MentionSuggestionsQueryVariables = Exact<{
  query: Scalars['String']['input'];
  groupId: Scalars['ID']['input'];
}>;


export type MentionSuggestionsQuery = { __typename?: 'Queries', mentionSuggestions?: Array<{ __typename?: 'User', id: string, internalId: number, fullname?: string | null, email?: string | null, image?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null }> | null };

export type TextModuleSuggestionsQueryVariables = Exact<{
  query: Scalars['String']['input'];
  limit?: InputMaybe<Scalars['Int']['input']>;
  ticketId?: InputMaybe<Scalars['ID']['input']>;
  customerId?: InputMaybe<Scalars['ID']['input']>;
  groupId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TextModuleSuggestionsQuery = { __typename?: 'Queries', textModuleSuggestions: Array<{ __typename?: 'TextModule', id: string, name: string, keywords?: string | null, renderedContent?: string | null }> };

export type AutocompleteSearchObjectAttributeExternalDataSourceQueryVariables = Exact<{
  input: AutocompleteSearchObjectAttributeExternalDataSourceInput;
}>;


export type AutocompleteSearchObjectAttributeExternalDataSourceQuery = { __typename?: 'Queries', autocompleteSearchObjectAttributeExternalDataSource: Array<{ __typename?: 'AutocompleteSearchExternalDataSourceEntry', value: any, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null }> };

export type FormUploadCacheAddMutationVariables = Exact<{
  formId: Scalars['FormId']['input'];
  files: Array<UploadFileInput> | UploadFileInput;
}>;


export type FormUploadCacheAddMutation = { __typename?: 'Mutations', formUploadCacheAdd?: { __typename?: 'FormUploadCacheAddPayload', uploadedFiles: Array<{ __typename?: 'StoredFile', id: string, name: string, size?: number | null, type?: string | null }> } | null };

export type FormUploadCacheRemoveMutationVariables = Exact<{
  formId: Scalars['FormId']['input'];
  fileIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;


export type FormUploadCacheRemoveMutation = { __typename?: 'Mutations', formUploadCacheRemove?: { __typename?: 'FormUploadCacheRemovePayload', success: boolean } | null };

export type AutocompleteSearchOrganizationQueryVariables = Exact<{
  input: AutocompleteSearchOrganizationInput;
}>;


export type AutocompleteSearchOrganizationQuery = { __typename?: 'Queries', autocompleteSearchOrganization: Array<{ __typename?: 'AutocompleteSearchOrganizationEntry', value: number, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, icon?: string | null, organization: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } }> };

export type AutocompleteSearchRecipientQueryVariables = Exact<{
  input: AutocompleteSearchRecipientInput;
}>;


export type AutocompleteSearchRecipientQuery = { __typename?: 'Queries', autocompleteSearchRecipient: Array<{ __typename?: 'AutocompleteSearchRecipientEntry', value: string, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, icon?: string | null }> };

export type FormUpdaterQueryVariables = Exact<{
  formUpdaterId: EnumFormUpdaterId;
  meta: FormUpdaterMetaInput;
  data: Scalars['JSON']['input'];
  relationFields: Array<FormUpdaterRelationField> | FormUpdaterRelationField;
  id?: InputMaybe<Scalars['ID']['input']>;
}>;


export type FormUpdaterQuery = { __typename?: 'Queries', formUpdater: { __typename?: 'FormUpdaterResult', fields: any, flags: any } };

export type ObjectManagerFrontendAttributesQueryVariables = Exact<{
  object: EnumObjectManagerObjects;
}>;


export type ObjectManagerFrontendAttributesQuery = { __typename?: 'Queries', objectManagerFrontendAttributes?: { __typename?: 'ObjectManagerFrontendAttributesPayload', attributes: Array<{ __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string, dataType: string, dataOption?: any | null, isInternal: boolean, screens?: any | null }>, screens: Array<{ __typename?: 'ObjectManagerScreenAttributes', name: string, attributes: Array<string> }> } | null };

export type OnlineNotificationDeleteMutationVariables = Exact<{
  onlineNotificationId: Scalars['ID']['input'];
}>;


export type OnlineNotificationDeleteMutation = { __typename?: 'Mutations', onlineNotificationDelete?: { __typename?: 'OnlineNotificationDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type OnlineNotificationMarkAllAsSeenMutationVariables = Exact<{
  onlineNotificationIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;


export type OnlineNotificationMarkAllAsSeenMutation = { __typename?: 'Mutations', onlineNotificationMarkAllAsSeen?: { __typename?: 'OnlineNotificationMarkAllAsSeenPayload', onlineNotifications?: Array<{ __typename?: 'OnlineNotification', id: string, seen: boolean }> | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type OnlineNotificationSeenMutationVariables = Exact<{
  objectId: Scalars['ID']['input'];
}>;


export type OnlineNotificationSeenMutation = { __typename?: 'Mutations', onlineNotificationSeen?: { __typename?: 'OnlineNotificationSeenPayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type OnlineNotificationsQueryVariables = Exact<{ [key: string]: never; }>;


export type OnlineNotificationsQuery = { __typename?: 'Queries', onlineNotifications: { __typename?: 'OnlineNotificationConnection', edges: Array<{ __typename?: 'OnlineNotificationEdge', cursor: string, node: { __typename?: 'OnlineNotification', id: string, seen: boolean, createdAt: string, typeName: string, objectName: string, createdBy?: { __typename?: 'User', id: string, fullname?: string | null, lastname?: string | null, firstname?: string | null, email?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null } | null, metaObject?:
          | { __typename?: 'DataPrivacyTask' }
          | { __typename?: 'Group' }
          | { __typename?: 'Organization' }
          | { __typename?: 'Role' }
          | { __typename?: 'Ticket', id: string, internalId: number, title: string }
          | { __typename?: 'TicketArticle', id: string, internalId: number, bodyWithUrls: string, preferences?: any | null, ticket: { __typename?: 'Ticket', id: string, internalId: number, title: string }, to?: { __typename?: 'AddressesField', raw: string } | null }
          | { __typename?: 'User' }
         | null } }>, pageInfo: { __typename?: 'PageInfo', endCursor?: string | null, hasNextPage: boolean } } };

export type OnlineNotificationsCountSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type OnlineNotificationsCountSubscription = { __typename?: 'Subscriptions', onlineNotificationsCount: { __typename?: 'OnlineNotificationsCountPayload', unseenCount: number } };

export type OrganizationAttributesFragment = { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null };

export type OrganizationMembersFragment = { __typename?: 'Organization', allMembers?: { __typename?: 'UserConnection', totalCount: number, edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, internalId: number, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null } }> } | null };

export type OrganizationQueryVariables = Exact<{
  organizationId: Scalars['ID']['input'];
  membersCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type OrganizationQuery = { __typename?: 'Queries', organization: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, policy: { __typename?: 'PolicyDefault', update: boolean }, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, allMembers?: { __typename?: 'UserConnection', totalCount: number, edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, internalId: number, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null } }> } | null } };

export type OrganizationUpdatesSubscriptionVariables = Exact<{
  organizationId: Scalars['ID']['input'];
  membersCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type OrganizationUpdatesSubscription = { __typename?: 'Subscriptions', organizationUpdates: { __typename?: 'OrganizationUpdatesPayload', organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, shared?: boolean | null, domain?: string | null, domainAssignment?: boolean | null, active?: boolean | null, note?: string | null, vip?: boolean | null, policy: { __typename?: 'PolicyDefault', update: boolean }, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, allMembers?: { __typename?: 'UserConnection', totalCount: number, edges: Array<{ __typename?: 'UserEdge', node: { __typename?: 'User', id: string, internalId: number, image?: string | null, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, vip?: boolean | null } }> } | null } | null } };

export type PublicLinksQueryVariables = Exact<{
  screen: EnumPublicLinksScreen;
}>;


export type PublicLinksQuery = { __typename?: 'Queries', publicLinks?: Array<{ __typename?: 'PublicLink', id: string, link: string, title: string, description?: string | null, newTab: boolean }> | null };

export type PublicLinkUpdatesSubscriptionVariables = Exact<{
  screen: EnumPublicLinksScreen;
}>;


export type PublicLinkUpdatesSubscription = { __typename?: 'Subscriptions', publicLinkUpdates: { __typename?: 'PublicLinkUpdatesPayload', publicLinks?: Array<{ __typename?: 'PublicLink', id: string, link: string, title: string, description?: string | null, newTab: boolean }> | null } };

export type TagAssignmentAddMutationVariables = Exact<{
  objectId: Scalars['ID']['input'];
  tag: Scalars['String']['input'];
}>;


export type TagAssignmentAddMutation = { __typename?: 'Mutations', tagAssignmentAdd?: { __typename?: 'TagAssignmentAddPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TagAssignmentRemoveMutationVariables = Exact<{
  objectId: Scalars['ID']['input'];
  tag: Scalars['String']['input'];
}>;


export type TagAssignmentRemoveMutation = { __typename?: 'Mutations', tagAssignmentRemove?: { __typename?: 'TagAssignmentRemovePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TagAssignmentUpdateMutationVariables = Exact<{
  objectId: Scalars['ID']['input'];
  tags: Array<Scalars['String']['input']> | Scalars['String']['input'];
}>;


export type TagAssignmentUpdateMutation = { __typename?: 'Mutations', tagAssignmentUpdate?: { __typename?: 'TagAssignmentUpdatePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AutocompleteSearchTagQueryVariables = Exact<{
  input: AutocompleteSearchTagInput;
}>;


export type AutocompleteSearchTagQuery = { __typename?: 'Queries', autocompleteSearchTag: Array<{ __typename?: 'AutocompleteSearchEntry', value: string, label: string }> };

export type SecurityStateFragment = { __typename?: 'TicketArticleSecurityState', type?: EnumSecurityStateType | null, signingSuccess?: boolean | null, signingMessage?: string | null, encryptionSuccess?: boolean | null, encryptionMessage?: string | null };

export type TicketArticleChangeVisibilityMutationVariables = Exact<{
  articleId: Scalars['ID']['input'];
  internal: Scalars['Boolean']['input'];
}>;


export type TicketArticleChangeVisibilityMutation = { __typename?: 'Mutations', ticketArticleChangeVisibility?: { __typename?: 'TicketArticleChangeVisibilityPayload', article?: { __typename?: 'TicketArticle', id: string, internal: boolean } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketArticleDeleteMutationVariables = Exact<{
  articleId: Scalars['ID']['input'];
}>;


export type TicketArticleDeleteMutation = { __typename?: 'Mutations', ticketArticleDelete?: { __typename?: 'TicketArticleDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketArticleEmailForwardReplyMutationVariables = Exact<{
  articleId: Scalars['ID']['input'];
  formId: Scalars['FormId']['input'];
}>;


export type TicketArticleEmailForwardReplyMutation = { __typename?: 'Mutations', ticketArticleEmailForwardReply?: { __typename?: 'TicketArticleEmailForwardReplyPayload', quotableFrom?: string | null, quotableTo?: string | null, quotableCc?: string | null, attachments: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null }>, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketArticleRetryMediaDownloadMutationVariables = Exact<{
  articleId: Scalars['ID']['input'];
}>;


export type TicketArticleRetryMediaDownloadMutation = { __typename?: 'Mutations', ticketArticleRetryMediaDownload?: { __typename?: 'TicketArticleRetryMediaDownloadPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketArticleRetrySecurityProcessMutationVariables = Exact<{
  articleId: Scalars['ID']['input'];
}>;


export type TicketArticleRetrySecurityProcessMutation = { __typename?: 'Mutations', ticketArticleRetrySecurityProcess?: { __typename?: 'TicketArticleRetrySecurityProcessPayload', retryResult?: { __typename?: 'TicketArticleSecurityState', type?: EnumSecurityStateType | null, signingSuccess?: boolean | null, signingMessage?: string | null, encryptionSuccess?: boolean | null, encryptionMessage?: string | null } | null, article?: { __typename?: 'TicketArticle', id: string, securityState?: { __typename?: 'TicketArticleSecurityState', type?: EnumSecurityStateType | null, signingSuccess?: boolean | null, signingMessage?: string | null, encryptionSuccess?: boolean | null, encryptionMessage?: string | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftStartAttributesFragment = { __typename?: 'TicketSharedDraftStart', id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null };

export type TicketSharedDraftStartCreateMutationVariables = Exact<{
  name: Scalars['String']['input'];
  input: TicketSharedDraftStartInput;
}>;


export type TicketSharedDraftStartCreateMutation = { __typename?: 'Mutations', ticketSharedDraftStartCreate?: { __typename?: 'TicketSharedDraftStartCreatePayload', sharedDraft: { __typename?: 'TicketSharedDraftStart', id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftStartDeleteMutationVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftStartDeleteMutation = { __typename?: 'Mutations', ticketSharedDraftStartDelete?: { __typename?: 'TicketSharedDraftStartDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftStartUpdateMutationVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
  input: TicketSharedDraftStartInput;
}>;


export type TicketSharedDraftStartUpdateMutation = { __typename?: 'Mutations', ticketSharedDraftStartUpdate?: { __typename?: 'TicketSharedDraftStartUpdatePayload', sharedDraft: { __typename?: 'TicketSharedDraftStart', id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftStartListQueryVariables = Exact<{
  groupId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftStartListQuery = { __typename?: 'Queries', ticketSharedDraftStartList: Array<{ __typename?: 'TicketSharedDraftStart', id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }> };

export type TicketSharedDraftStartSingleQueryVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftStartSingleQuery = { __typename?: 'Queries', ticketSharedDraftStartSingle: { __typename?: 'TicketSharedDraftStart', content?: any | null, id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null } };

export type TicketSharedDraftStartUpdateByGroupSubscriptionVariables = Exact<{
  groupId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftStartUpdateByGroupSubscription = { __typename?: 'Subscriptions', ticketSharedDraftStartUpdateByGroup: { __typename?: 'TicketSharedDraftStartUpdateByGroupPayload', sharedDraftStarts?: Array<{ __typename?: 'TicketSharedDraftStart', id: string, name?: string | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }> | null } };

export type TicketSharedDraftZoomAttributesFragment = { __typename?: 'TicketSharedDraftZoom', id: string, ticketId?: string | null, newArticle?: any | null, ticketAttributes?: any | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null };

export type TicketSharedDraftZoomCreateMutationVariables = Exact<{
  input: TicketSharedDraftZoomInput;
}>;


export type TicketSharedDraftZoomCreateMutation = { __typename?: 'Mutations', ticketSharedDraftZoomCreate?: { __typename?: 'TicketSharedDraftZoomCreatePayload', sharedDraft: { __typename?: 'TicketSharedDraftZoom', id: string, ticketId?: string | null, newArticle?: any | null, ticketAttributes?: any | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftZoomDeleteMutationVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftZoomDeleteMutation = { __typename?: 'Mutations', ticketSharedDraftZoomDelete?: { __typename?: 'TicketSharedDraftZoomDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftZoomUpdateMutationVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
  input: TicketSharedDraftZoomInput;
}>;


export type TicketSharedDraftZoomUpdateMutation = { __typename?: 'Mutations', ticketSharedDraftZoomUpdate?: { __typename?: 'TicketSharedDraftZoomUpdatePayload', sharedDraft: { __typename?: 'TicketSharedDraftZoom', id: string, ticketId?: string | null, newArticle?: any | null, ticketAttributes?: any | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null }, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketSharedDraftZoomShowQueryVariables = Exact<{
  sharedDraftId: Scalars['ID']['input'];
}>;


export type TicketSharedDraftZoomShowQuery = { __typename?: 'Queries', ticketSharedDraftZoomShow: { __typename?: 'TicketSharedDraftZoom', id: string, ticketId?: string | null, newArticle?: any | null, ticketAttributes?: any | null, updatedAt: string, updatedBy?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, phone?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null } | null } };

export type OverviewAttributesFragment = { __typename?: 'Overview', id: string, internalId: number, name: string, link: string, prio: number, groupBy?: string | null, orderBy: string, orderDirection: EnumOrderDirection, organizationShared?: boolean | null, outOfOffice?: boolean | null, active: boolean, ticketCount?: number };

export type ReferencingTicketFragment = { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } };

export type TicketArticleAttributesFragment = { __typename?: 'TicketArticle', id: string, internalId: number, messageId?: string | null, subject?: string | null, messageIdMd5?: string | null, inReplyTo?: string | null, contentType: string, preferences?: any | null, bodyWithUrls: string, internal: boolean, createdAt: string, detectedLanguage?: string | null, from?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, to?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, cc?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, replyTo?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, attachmentsWithoutInline: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null, preferences?: any | null }>, author: { __typename?: 'User', id: string, fullname?: string | null, firstname?: string | null, lastname?: string | null, email?: string | null, active?: boolean | null, image?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, authorizations?: Array<{ __typename?: 'Authorization', provider: string, uid: string, username?: string | null }> | null }, type?: { __typename?: 'TicketArticleType', name?: string | null, communication?: boolean | null } | null, sender?: { __typename?: 'TicketArticleSender', name?: EnumTicketArticleSenderName | null } | null, securityState?: { __typename?: 'TicketArticleSecurityState', encryptionMessage?: string | null, encryptionSuccess?: boolean | null, signingMessage?: string | null, signingSuccess?: boolean | null, type?: EnumSecurityStateType | null } | null, mediaErrorState?: { __typename?: 'TicketArticleMediaErrorState', error?: boolean | null } | null };

export type TicketAttributesFragment = { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null };

export type TicketLiveUserAttributesFragment = { __typename?: 'TicketLiveUser', user: { __typename?: 'User', id: string, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, apps: Array<{ __typename?: 'TicketLiveUserApp', name: EnumTaskbarApp, editing: boolean, lastInteraction: string }> };

export type TicketMentionFragment = { __typename?: 'Mention', user: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, userTicketAccess: { __typename?: 'PolicyMentionUserTicketAccess', agentReadAccess: boolean } };

export type TicketTaskbarTabAttributesFragment = { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, updatedAt: string, state: { __typename?: 'TicketState', id: string, name: string } };

export type TicketCreateMutationVariables = Exact<{
  input: TicketCreateInput;
}>;


export type TicketCreateMutation = { __typename?: 'Mutations', ticketCreate?: { __typename?: 'TicketCreatePayload', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketCustomerUpdateMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  input: TicketCustomerUpdateInput;
}>;


export type TicketCustomerUpdateMutation = { __typename?: 'Mutations', ticketCustomerUpdate?: { __typename?: 'TicketCustomerUpdatePayload', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketMergeMutationVariables = Exact<{
  sourceTicketId: Scalars['ID']['input'];
  targetTicketId: Scalars['ID']['input'];
}>;


export type TicketMergeMutation = { __typename?: 'Mutations', ticketMerge?: { __typename?: 'TicketMergePayload', errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type MentionSubscribeMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type MentionSubscribeMutation = { __typename?: 'Mutations', mentionSubscribe?: { __typename?: 'MentionSubscribePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketTitleUpdateMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  input: TicketTitleUpdateInput;
}>;


export type TicketTitleUpdateMutation = { __typename?: 'Mutations', ticketTitleUpdate?: { __typename?: 'TicketTitleUpdatePayload', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type MentionUnsubscribeMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type MentionUnsubscribeMutation = { __typename?: 'Mutations', mentionUnsubscribe?: { __typename?: 'MentionUnsubscribePayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type TicketUpdateMutationVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  input: TicketUpdateInput;
  meta: TicketUpdateMetaInput;
}>;


export type TicketUpdateMutation = { __typename?: 'Mutations', ticketUpdate?: { __typename?: 'TicketUpdatePayload', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type AutocompleteSearchTicketQueryVariables = Exact<{
  input: AutocompleteSearchTicketInput;
}>;


export type AutocompleteSearchTicketQuery = { __typename?: 'Queries', autocompleteSearchTicket: Array<{ __typename?: 'AutocompleteSearchTicketEntry', value: string, label: string, labelPlaceholder?: Array<string> | null, heading?: string | null, headingPlaceholder?: Array<string> | null, disabled?: boolean | null, icon?: string | null, ticket: { __typename?: 'Ticket', id: string, number: string, internalId: number, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } } }> };

export type TicketQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketQuery = { __typename?: 'Queries', ticket: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, createArticleType?: { __typename?: 'TicketArticleType', id: string, name?: string | null } | null, mentions?: { __typename?: 'MentionConnection', totalCount: number, edges: Array<{ __typename?: 'MentionEdge', cursor: string, node: { __typename?: 'Mention', user: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, userTicketAccess: { __typename?: 'PolicyMentionUserTicketAccess', agentReadAccess: boolean } } }> } | null, checklist?: { __typename?: 'Checklist', id: string, completed: boolean, incomplete: number, total: number, complete: number } | null, referencingChecklistTickets?: Array<{ __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }> | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } };

export type TicketArticlesQueryVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  beforeCursor?: InputMaybe<Scalars['String']['input']>;
  afterCursor?: InputMaybe<Scalars['String']['input']>;
  pageSize?: InputMaybe<Scalars['Int']['input']>;
  loadFirstArticles?: InputMaybe<Scalars['Boolean']['input']>;
  firstArticlesCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type TicketArticlesQuery = { __typename?: 'Queries', firstArticles?: { __typename?: 'TicketArticleConnection', edges: Array<{ __typename?: 'TicketArticleEdge', node: { __typename?: 'TicketArticle', id: string, internalId: number, messageId?: string | null, subject?: string | null, messageIdMd5?: string | null, inReplyTo?: string | null, contentType: string, preferences?: any | null, bodyWithUrls: string, internal: boolean, createdAt: string, detectedLanguage?: string | null, from?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, to?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, cc?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, replyTo?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, attachmentsWithoutInline: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null, preferences?: any | null }>, author: { __typename?: 'User', id: string, fullname?: string | null, firstname?: string | null, lastname?: string | null, email?: string | null, active?: boolean | null, image?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, authorizations?: Array<{ __typename?: 'Authorization', provider: string, uid: string, username?: string | null }> | null }, type?: { __typename?: 'TicketArticleType', name?: string | null, communication?: boolean | null } | null, sender?: { __typename?: 'TicketArticleSender', name?: EnumTicketArticleSenderName | null } | null, securityState?: { __typename?: 'TicketArticleSecurityState', encryptionMessage?: string | null, encryptionSuccess?: boolean | null, signingMessage?: string | null, signingSuccess?: boolean | null, type?: EnumSecurityStateType | null } | null, mediaErrorState?: { __typename?: 'TicketArticleMediaErrorState', error?: boolean | null } | null } }> }, articles: { __typename?: 'TicketArticleConnection', totalCount: number, edges: Array<{ __typename?: 'TicketArticleEdge', cursor: string, node: { __typename?: 'TicketArticle', id: string, internalId: number, messageId?: string | null, subject?: string | null, messageIdMd5?: string | null, inReplyTo?: string | null, contentType: string, preferences?: any | null, bodyWithUrls: string, internal: boolean, createdAt: string, detectedLanguage?: string | null, from?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, to?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, cc?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, replyTo?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, attachmentsWithoutInline: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null, preferences?: any | null }>, author: { __typename?: 'User', id: string, fullname?: string | null, firstname?: string | null, lastname?: string | null, email?: string | null, active?: boolean | null, image?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, authorizations?: Array<{ __typename?: 'Authorization', provider: string, uid: string, username?: string | null }> | null }, type?: { __typename?: 'TicketArticleType', name?: string | null, communication?: boolean | null } | null, sender?: { __typename?: 'TicketArticleSender', name?: EnumTicketArticleSenderName | null } | null, securityState?: { __typename?: 'TicketArticleSecurityState', encryptionMessage?: string | null, encryptionSuccess?: boolean | null, signingMessage?: string | null, signingSuccess?: boolean | null, type?: EnumSecurityStateType | null } | null, mediaErrorState?: { __typename?: 'TicketArticleMediaErrorState', error?: boolean | null } | null } }>, pageInfo: { __typename?: 'PageInfo', endCursor?: string | null, startCursor?: string | null, hasPreviousPage: boolean } } };

export type TicketArticleUpdatesSubscriptionVariables = Exact<{
  ticketId: Scalars['ID']['input'];
}>;


export type TicketArticleUpdatesSubscription = { __typename?: 'Subscriptions', ticketArticleUpdates: { __typename?: 'TicketArticleUpdatesPayload', removeArticleId?: string | null, addArticle?: { __typename?: 'TicketArticle', id: string, createdAt: string, sender?: { __typename?: 'TicketArticleSender', name?: EnumTicketArticleSenderName | null } | null } | null, updateArticle?: { __typename?: 'TicketArticle', id: string, internalId: number, messageId?: string | null, subject?: string | null, messageIdMd5?: string | null, inReplyTo?: string | null, contentType: string, preferences?: any | null, bodyWithUrls: string, internal: boolean, createdAt: string, detectedLanguage?: string | null, from?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, to?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, cc?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, replyTo?: { __typename?: 'AddressesField', raw: string, parsed?: Array<{ __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null, isSystemAddress: boolean }> | null } | null, attachmentsWithoutInline: Array<{ __typename?: 'StoredFile', id: string, internalId: number, name: string, size?: number | null, type?: string | null, preferences?: any | null }>, author: { __typename?: 'User', id: string, fullname?: string | null, firstname?: string | null, lastname?: string | null, email?: string | null, active?: boolean | null, image?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, authorizations?: Array<{ __typename?: 'Authorization', provider: string, uid: string, username?: string | null }> | null }, type?: { __typename?: 'TicketArticleType', name?: string | null, communication?: boolean | null } | null, sender?: { __typename?: 'TicketArticleSender', name?: EnumTicketArticleSenderName | null } | null, securityState?: { __typename?: 'TicketArticleSecurityState', encryptionMessage?: string | null, encryptionSuccess?: boolean | null, signingMessage?: string | null, signingSuccess?: boolean | null, type?: EnumSecurityStateType | null } | null, mediaErrorState?: { __typename?: 'TicketArticleMediaErrorState', error?: boolean | null } | null } | null } };

export type TicketLiveUserUpdatesSubscriptionVariables = Exact<{
  key: Scalars['String']['input'];
  app: EnumTaskbarApp;
}>;


export type TicketLiveUserUpdatesSubscription = { __typename?: 'Subscriptions', ticketLiveUserUpdates: { __typename?: 'TicketLiveUserUpdatesPayload', liveUsers?: Array<{ __typename?: 'TicketLiveUser', user: { __typename?: 'User', id: string, firstname?: string | null, lastname?: string | null, fullname?: string | null, email?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, apps: Array<{ __typename?: 'TicketLiveUserApp', name: EnumTaskbarApp, editing: boolean, lastInteraction: string }> }> | null } };

export type TicketUpdatesSubscriptionVariables = Exact<{
  ticketId: Scalars['ID']['input'];
  initial?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type TicketUpdatesSubscription = { __typename?: 'Subscriptions', ticketUpdates: { __typename?: 'TicketUpdatesPayload', ticket?: { __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, createdAt: string, escalationAt?: string | null, aiAgentRunning?: boolean | null, updatedAt: string, pendingTime?: string | null, tags?: Array<string> | null, timeUnit?: number | null, subscribed?: boolean | null, preferences?: any | null, stateColorCode: EnumTicketStateColorCode, sharedDraftZoomId?: string | null, firstResponseEscalationAt?: string | null, closeEscalationAt?: string | null, updateEscalationAt?: string | null, initialChannel?: EnumChannelArea | null, createArticleType?: { __typename?: 'TicketArticleType', id: string, name?: string | null } | null, mentions?: { __typename?: 'MentionConnection', totalCount: number, edges: Array<{ __typename?: 'MentionEdge', cursor: string, node: { __typename?: 'Mention', user: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, vip?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, active?: boolean | null, image?: string | null }, userTicketAccess: { __typename?: 'PolicyMentionUserTicketAccess', agentReadAccess: boolean } } }> } | null, checklist?: { __typename?: 'Checklist', id: string, completed: boolean, incomplete: number, total: number, complete: number } | null, referencingChecklistTickets?: Array<{ __typename?: 'Ticket', id: string, internalId: number, number: string, title: string, stateColorCode: EnumTicketStateColorCode, state: { __typename?: 'TicketState', id: string, name: string } }> | null, updatedBy?: { __typename?: 'User', id: string } | null, owner: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null }, customer: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, phone?: string | null, mobile?: string | null, image?: string | null, vip?: boolean | null, active?: boolean | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, email?: string | null, hasSecondaryOrganizations?: boolean | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean } }, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, vip?: boolean | null, active?: boolean | null } | null, state: { __typename?: 'TicketState', id: string, name: string, stateType: { __typename?: 'TicketStateType', id: string, name: string } }, group: { __typename?: 'Group', id: string, name?: string | null, summaryGeneration?: EnumTicketSummaryGeneration | null, emailAddress?: { __typename?: 'EmailAddressParsed', name?: string | null, emailAddress?: string | null } | null }, priority: { __typename?: 'TicketPriority', id: string, name: string, defaultCreate: boolean, uiColor?: string | null }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, policy: { __typename?: 'PolicyTicket', update: boolean, agentReadAccess: boolean }, timeUnitsPerType?: Array<{ __typename?: 'TicketTimeAccountingTypeSum', name: string, timeUnit: number }> | null, externalReferences?: { __typename?: 'TicketExternalReferences', github?: Array<string> | null, gitlab?: Array<string> | null } | null } | null } };

export type TokenAttributesFragment = { __typename?: 'Token', id: string, name?: string | null, preferences?: any | null, expiresAt?: string | null, lastUsedAt?: string | null, createdAt: string, user?: { __typename?: 'User', id: string } | null };

export type UserCurrentTwoFactorGetMethodConfigurationQueryVariables = Exact<{
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorGetMethodConfigurationQuery = { __typename?: 'Queries', userCurrentTwoFactorGetMethodConfiguration?: any | null };

export type UserCurrentTwoFactorRecoveryCodesGenerateMutationVariables = Exact<{
  token: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorRecoveryCodesGenerateMutation = { __typename?: 'Mutations', userCurrentTwoFactorRecoveryCodesGenerate?: { __typename?: 'UserCurrentTwoFactorRecoveryCodesGeneratePayload', recoveryCodes?: Array<string> | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTwoFactorRemoveMethodMutationVariables = Exact<{
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorRemoveMethodMutation = { __typename?: 'Mutations', userCurrentTwoFactorRemoveMethod?: { __typename?: 'UserCurrentTwoFactorRemoveMethodPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTwoFactorRemoveMethodCredentialsMutationVariables = Exact<{
  methodName: Scalars['String']['input'];
  token: Scalars['String']['input'];
  credentialId: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorRemoveMethodCredentialsMutation = { __typename?: 'Mutations', userCurrentTwoFactorRemoveMethodCredentials?: { __typename?: 'UserCurrentTwoFactorRemoveMethodCredentialsPayload', success?: boolean | null } | null };

export type UserCurrentTwoFactorSetDefaultMethodMutationVariables = Exact<{
  methodName: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorSetDefaultMethodMutation = { __typename?: 'Mutations', userCurrentTwoFactorSetDefaultMethod?: { __typename?: 'UserCurrentTwoFactorSetDefaultMethodPayload', success?: boolean | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTwoFactorVerifyMethodConfigurationMutationVariables = Exact<{
  methodName: EnumTwoFactorAuthenticationMethod;
  token: Scalars['String']['input'];
  payload: Scalars['JSON']['input'];
  configuration: Scalars['JSON']['input'];
}>;


export type UserCurrentTwoFactorVerifyMethodConfigurationMutation = { __typename?: 'Mutations', userCurrentTwoFactorVerifyMethodConfiguration?: { __typename?: 'UserCurrentTwoFactorVerifyMethodConfigurationPayload', recoveryCodes?: Array<string> | null, errors?: Array<{ __typename?: 'UserError', message: string, field?: string | null }> | null } | null };

export type UserCurrentAccessTokenAddMutationVariables = Exact<{
  input: UserAccessTokenInput;
}>;


export type UserCurrentAccessTokenAddMutation = { __typename?: 'Mutations', userCurrentAccessTokenAdd?: { __typename?: 'UserCurrentAccessTokenAddPayload', tokenValue: string, token?: { __typename?: 'Token', id: string, name?: string | null, preferences?: any | null, expiresAt?: string | null, lastUsedAt?: string | null, createdAt: string, user?: { __typename?: 'User', id: string } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentAccessTokenDeleteMutationVariables = Exact<{
  tokenId: Scalars['ID']['input'];
}>;


export type UserCurrentAccessTokenDeleteMutation = { __typename?: 'Mutations', userCurrentAccessTokenDelete?: { __typename?: 'UserCurrentAccessTokenDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentAvatarAddMutationVariables = Exact<{
  images: AvatarInput;
}>;


export type UserCurrentAvatarAddMutation = { __typename?: 'Mutations', userCurrentAvatarAdd?: { __typename?: 'UserCurrentAvatarAddPayload', avatar?: { __typename?: 'Avatar', id: string, default: boolean, deletable: boolean, initial: boolean, imageFull?: string | null, imageResize?: string | null, imageHash?: string | null, createdAt: string, updatedAt: string } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentAvatarDeleteMutationVariables = Exact<{
  id: Scalars['ID']['input'];
}>;


export type UserCurrentAvatarDeleteMutation = { __typename?: 'Mutations', userCurrentAvatarDelete?: { __typename?: 'UserCurrentAvatarDeletePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentLocaleMutationVariables = Exact<{
  locale: Scalars['String']['input'];
}>;


export type UserCurrentLocaleMutation = { __typename?: 'Mutations', userCurrentLocale?: { __typename?: 'UserCurrentLocalePayload', success: boolean, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserCurrentTwoFactorConfigurationQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentTwoFactorConfigurationQuery = { __typename?: 'Queries', userCurrentTwoFactorConfiguration: { __typename?: 'UserConfigurationTwoFactor', recoveryCodesExist: boolean, enabledAuthenticationMethods: Array<{ __typename?: 'TwoFactorEnabledAuthenticationMethod', configured: boolean, default: boolean, authenticationMethod: EnumTwoFactorAuthenticationMethod }> } };

export type UserCurrentTwoFactorInitiateMethodConfigurationQueryVariables = Exact<{
  methodName: EnumTwoFactorAuthenticationMethod;
  token: Scalars['String']['input'];
}>;


export type UserCurrentTwoFactorInitiateMethodConfigurationQuery = { __typename?: 'Queries', userCurrentTwoFactorInitiateMethodConfiguration: any };

export type UserCurrentAccessTokenListQueryVariables = Exact<{ [key: string]: never; }>;


export type UserCurrentAccessTokenListQuery = { __typename?: 'Queries', userCurrentAccessTokenList?: Array<{ __typename?: 'Token', id: string, name?: string | null, preferences?: any | null, expiresAt?: string | null, lastUsedAt?: string | null, createdAt: string, user?: { __typename?: 'User', id: string } | null }> | null };

export type UserAddMutationVariables = Exact<{
  input: UserInput;
  sendInvite?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type UserAddMutation = { __typename?: 'Mutations', userAdd?: { __typename?: 'UserAddPayload', user?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type UserQueryVariables = Exact<{
  userId: Scalars['ID']['input'];
  secondaryOrganizationsCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type UserQuery = { __typename?: 'Queries', user: { __typename?: 'User', hasSecondaryOrganizations?: boolean | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, image?: string | null, email?: string | null, web?: string | null, vip?: boolean | null, phone?: string | null, mobile?: string | null, fax?: string | null, note?: string | null, active?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, openSearchQuery?: string | null, closed: number, closedSearchQuery?: string | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null } | null, secondaryOrganizations?: { __typename?: 'OrganizationConnection', totalCount: number, edges: Array<{ __typename?: 'OrganizationEdge', node: { __typename?: 'Organization', id: string, internalId: number, active?: boolean | null, name?: string | null } }> } | null } };

export type CurrentUserAttributesFragment = { __typename?: 'User', email?: string | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, authorizations?: Array<{ __typename?: 'Authorization', id: string, provider: string, uid: string, username?: string | null }> | null, permissions?: { __typename?: 'UserPermission', names: Array<string> } | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null };

export type ErrorsFragment = { __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null };

export type ObjectAttributeValuesFragment = { __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } };

export type PublicLinkAttributesFragment = { __typename?: 'PublicLink', id: string, link: string, title: string, description?: string | null, newTab: boolean };

export type SessionFragment = { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null };

export type SimpleTicketAttributeFragment = { __typename?: 'Ticket', number: string, internalId: number, id: string, title: string, createdAt: string, stateColorCode: EnumTicketStateColorCode, customer: { __typename?: 'User', id: string, fullname?: string | null }, organization?: { __typename?: 'Organization', id: string, name?: string | null } | null, group: { __typename?: 'Group', id: string, name?: string | null }, state: { __typename?: 'TicketState', id: string, name: string } };

export type UserAttributesFragment = { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null };

export type UserDetailAttributesFragment = { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, image?: string | null, email?: string | null, web?: string | null, vip?: boolean | null, phone?: string | null, mobile?: string | null, fax?: string | null, note?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null } | null, secondaryOrganizations?: { __typename?: 'OrganizationConnection', totalCount: number, edges: Array<{ __typename?: 'OrganizationEdge', node: { __typename?: 'Organization', id: string, internalId: number, active?: boolean | null, name?: string | null } }> } | null };

export type UserPersonalSettingsFragment = { __typename?: 'User', personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null };

export type AiAnalyticsUsageMutationVariables = Exact<{
  aiAnalyticsRunId: Scalars['ID']['input'];
  input: AiAnalyticsUsageInput;
}>;


export type AiAnalyticsUsageMutation = { __typename?: 'Mutations', aiAnalyticsUsage?: { __typename?: 'AIAnalyticsUsagePayload', usage?: { __typename?: 'AIAnalyticsUsage', id: string } | null } | null };

export type AiAssistanceTextToolsRunMutationVariables = Exact<{
  input: Scalars['String']['input'];
  textToolId: Scalars['ID']['input'];
  templateRenderContext: TemplateRenderContextInput;
}>;


export type AiAssistanceTextToolsRunMutation = { __typename?: 'Mutations', aiAssistanceTextToolsRun?: { __typename?: 'AIAssistanceTextToolsRunPayload', output?: string | null } | null };

export type LoginMutationVariables = Exact<{
  input: LoginInput;
}>;


export type LoginMutation = { __typename?: 'Mutations', login?: { __typename?: 'LoginPayload', session?: { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null } | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null, twoFactorRequired?: { __typename?: 'UserLoginTwoFactorMethods', availableTwoFactorAuthenticationMethods: Array<EnumTwoFactorAuthenticationMethod>, defaultTwoFactorAuthenticationMethod?: EnumTwoFactorAuthenticationMethod | null, recoveryCodesAvailable: boolean } | null } | null };

export type LogoutMutationVariables = Exact<{ [key: string]: never; }>;


export type LogoutMutation = { __typename?: 'Mutations', logout?: { __typename?: 'LogoutPayload', success: boolean, externalLogoutUrl?: string | null } | null };

export type TwoFactorMethodInitiateAuthenticationMutationVariables = Exact<{
  login: Scalars['String']['input'];
  password: Scalars['String']['input'];
  twoFactorMethod: EnumTwoFactorAuthenticationMethod;
}>;


export type TwoFactorMethodInitiateAuthenticationMutation = { __typename?: 'Mutations', twoFactorMethodInitiateAuthentication?: { __typename?: 'TwoFactorMethodInitiateAuthenticationPayload', initiationData?: any | null, errors?: Array<{ __typename?: 'UserError', message: string, messagePlaceholder?: Array<string> | null, field?: string | null, exception?: EnumUserErrorException | null }> | null } | null };

export type ProductAboutQueryVariables = Exact<{ [key: string]: never; }>;


export type ProductAboutQuery = { __typename?: 'Queries', productAbout: string };

export type ApplicationBuildChecksumQueryVariables = Exact<{ [key: string]: never; }>;


export type ApplicationBuildChecksumQuery = { __typename?: 'Queries', applicationBuildChecksum: string };

export type ApplicationConfigQueryVariables = Exact<{ [key: string]: never; }>;


export type ApplicationConfigQuery = { __typename?: 'Queries', applicationConfig: Array<{ __typename?: 'KeyComplexValue', key: string, value?: any | null }> };

export type CurrentUserQueryVariables = Exact<{ [key: string]: never; }>;


export type CurrentUserQuery = { __typename?: 'Queries', currentUser: { __typename?: 'User', email?: string | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, authorizations?: Array<{ __typename?: 'Authorization', id: string, provider: string, uid: string, username?: string | null }> | null, permissions?: { __typename?: 'UserPermission', names: Array<string> } | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } };

export type LocalesQueryVariables = Exact<{
  onlyActive?: InputMaybe<Scalars['Boolean']['input']>;
}>;


export type LocalesQuery = { __typename?: 'Queries', locales: Array<{ __typename?: 'Locale', locale: string, alias?: string | null, name: string, dir: EnumTextDirection, active: boolean }> };

export type MacrosQueryVariables = Exact<{
  groupIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;


export type MacrosQuery = { __typename?: 'Queries', macros: Array<{ __typename?: 'Macro', id: string, active: boolean, name: string, uxFlowNextUp: string }> };

export type SessionQueryVariables = Exact<{ [key: string]: never; }>;


export type SessionQuery = { __typename?: 'Queries', session: { __typename?: 'Session', id: string, afterAuth?: { __typename?: 'SessionAfterAuth', type: EnumAfterAuthType, data?: any | null } | null } };

export type TicketSignatureQueryVariables = Exact<{
  groupId: Scalars['ID']['input'];
  ticketId?: InputMaybe<Scalars['ID']['input']>;
}>;


export type TicketSignatureQuery = { __typename?: 'Queries', ticketSignature?: { __typename?: 'Signature', id: string, renderedBody?: string | null } | null };

export type TranslationsQueryVariables = Exact<{
  locale: Scalars['String']['input'];
  cacheKey?: InputMaybe<Scalars['String']['input']>;
}>;


export type TranslationsQuery = { __typename?: 'Queries', translations?: { __typename?: 'TranslationsPayload', isCacheStillValid: boolean, cacheKey?: string | null, translations?: any | null } | null };

export type AiTextToolUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type AiTextToolUpdatesSubscription = { __typename?: 'Subscriptions', aiTextToolUpdates: { __typename?: 'AITextToolUpdatesPayload', textToolId?: string | null, groupIds?: Array<string> | null, removeTextToolId?: string | null } };

export type AppMaintenanceSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type AppMaintenanceSubscription = { __typename?: 'Subscriptions', appMaintenance: { __typename?: 'AppMaintenancePayload', type?: EnumAppMaintenanceType | null } };

export type ConfigUpdatesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type ConfigUpdatesSubscription = { __typename?: 'Subscriptions', configUpdates: { __typename?: 'ConfigUpdatesPayload', setting?: { __typename?: 'KeyComplexValue', key: string, value?: any | null } | null } };

export type CurrentUserUpdatesSubscriptionVariables = Exact<{
  userId: Scalars['ID']['input'];
}>;


export type CurrentUserUpdatesSubscription = { __typename?: 'Subscriptions', userUpdates: { __typename?: 'UserUpdatesPayload', user?: { __typename?: 'User', email?: string | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, image?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, preferences?: any | null, hasSecondaryOrganizations?: boolean | null, authorizations?: Array<{ __typename?: 'Authorization', id: string, provider: string, uid: string, username?: string | null }> | null, permissions?: { __typename?: 'UserPermission', names: Array<string> } | null, outOfOfficeReplacement?: { __typename?: 'User', id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, login?: string | null, phone?: string | null, email?: string | null } | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null } | null, personalSettings?: { __typename?: 'UserPersonalSettings', notificationConfig?: { __typename?: 'UserPersonalSettingsNotificationConfig', groupIds?: Array<number> | null, matrix?: { __typename?: 'UserPersonalSettingsNotificationMatrix', create?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, escalation?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, reminderReached?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null, update?: { __typename?: 'UserPersonalSettingsNotificationMatrixRow', channel?: { __typename?: 'UserPersonalSettingsNotificationMatrixChannel', email?: boolean | null, online?: boolean | null } | null, criteria?: { __typename?: 'UserPersonalSettingsNotificationMatrixCriteria', no?: boolean | null, ownedByMe?: boolean | null, ownedByNobody?: boolean | null, subscribed?: boolean | null } | null } | null } | null } | null, notificationSound?: { __typename?: 'UserPersonalSettingsNotificationSound', enabled?: boolean | null, file?: EnumNotificationSoundFile | null } | null } | null } | null } };

export type MacrosUpdateSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type MacrosUpdateSubscription = { __typename?: 'Subscriptions', macrosUpdate: { __typename?: 'MacrosUpdatePayload', macroId?: string | null, groupIds?: Array<string> | null, removeMacroId?: string | null } };

export type PushMessagesSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type PushMessagesSubscription = { __typename?: 'Subscriptions', pushMessages: { __typename?: 'PushMessagesPayload', title?: string | null, text?: string | null } };

export type UserUpdatesSubscriptionVariables = Exact<{
  userId: Scalars['ID']['input'];
  secondaryOrganizationsCount?: InputMaybe<Scalars['Int']['input']>;
}>;


export type UserUpdatesSubscription = { __typename?: 'Subscriptions', userUpdates: { __typename?: 'UserUpdatesPayload', user?: { __typename?: 'User', hasSecondaryOrganizations?: boolean | null, id: string, internalId: number, firstname?: string | null, lastname?: string | null, fullname?: string | null, outOfOffice?: boolean | null, outOfOfficeStartAt?: string | null, outOfOfficeEndAt?: string | null, image?: string | null, email?: string | null, web?: string | null, vip?: boolean | null, phone?: string | null, mobile?: string | null, fax?: string | null, note?: string | null, active?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, openSearchQuery?: string | null, closed: number, closedSearchQuery?: string | null } | null, policy: { __typename?: 'PolicyDefault', update: boolean }, objectAttributeValues?: Array<{ __typename?: 'ObjectAttributeValue', value?: any | null, renderedLink?: string | null, attribute: { __typename?: 'ObjectManagerFrontendAttribute', name: string, display: string } }> | null, organization?: { __typename?: 'Organization', id: string, internalId: number, name?: string | null, active?: boolean | null, vip?: boolean | null, ticketsCount?: { __typename?: 'TicketCount', open: number, closed: number } | null } | null, secondaryOrganizations?: { __typename?: 'OrganizationConnection', totalCount: number, edges: Array<{ __typename?: 'OrganizationEdge', node: { __typename?: 'Organization', id: string, internalId: number, active?: boolean | null, name?: string | null } }> } | null } | null } };
