// Copyright (C) 2012-2025 Zammad Foundation, https://zammad-foundation.org/

import type { ObjectManagerFrontendAttributesPayload } from '#shared/graphql/types.ts'

export default (): ObjectManagerFrontendAttributesPayload => ({
  attributes: [
    {
      name: 'firstname',
      display: 'First name',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'text',
        maxlength: 150,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'lastname',
      display: 'Last name',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'text',
        maxlength: 150,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'email',
      display: 'Email',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'email',
        maxlength: 150,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {
        signup: {
          '-all-': {
            null: false,
          },
        },
        invite_agent: {
          '-all-': {
            null: false,
          },
        },
        invite_customer: {
          '-all-': {
            null: false,
          },
        },
      },
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'web',
      display: 'Web',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'url',
        maxlength: 250,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'phone',
      display: 'Phone',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'tel',
        maxlength: 100,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'mobile',
      display: 'Mobile',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'tel',
        maxlength: 100,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'fax',
      display: 'Fax',
      dataType: 'input',
      isInternal: true,
      dataOption: {
        type: 'tel',
        maxlength: 100,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'organization_id',
      display: 'Organization',
      dataType: 'autocompletion_ajax',
      isInternal: true,
      dataOption: {
        multiple: false,
        nulloption: true,
        null: true,
        relation: 'Organization',
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'organization_ids',
      display: 'Secondary organizations',
      dataType: 'autocompletion_ajax',
      isInternal: true,
      dataOption: {
        multiple: true,
        nulloption: true,
        null: true,
        relation: 'Organization',
        item_class: 'formGroup--halfSize',
        display_limit: 3,
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'department',
      display: 'Department',
      dataType: 'input',
      isInternal: false,
      dataOption: {
        type: 'text',
        maxlength: 200,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'address',
      display: 'Address',
      dataType: 'textarea',
      isInternal: false,
      dataOption: {
        type: 'text',
        maxlength: 500,
        rows: 4,
        null: true,
        item_class: 'formGroup--halfSize',
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'note',
      display: 'Note',
      dataType: 'richtext',
      isInternal: true,
      dataOption: {
        type: 'text',
        maxlength: 5000,
        null: true,
        note: 'Notes are visible to agents only, never to customers.',
        no_images: true,
      },
      screens: {},
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'role_ids',
      display: 'Roles',
      dataType: 'user_permission',
      isInternal: true,
      dataOption: {
        null: false,
        item_class: 'checkbox',
        permission: ['admin.user'],
        relation: 'Role',
      },
      screens: {
        invite_agent: {
          '-all-': {
            null: false,
          },
        },
      },
      __typename: 'ObjectManagerFrontendAttribute',
    },
    {
      name: 'group_ids',
      display: 'Group permissions',
      dataType: 'group_permissions',
      isInternal: true,
      dataOption: {
        null: true,
        item_class: 'checkbox',
        permission: ['admin.user'],
      },
      screens: {
        invite_agent: {
          '-all-': {
            null: true,
          },
        },
      },
      __typename: 'ObjectManagerFrontendAttribute',
    },
  ],
  screens: [
    {
      name: 'view',
      attributes: [
        'firstname',
        'lastname',
        'email',
        'web',
        'phone',
        'mobile',
        'fax',
        'organization_id',
        'organization_ids',
        'department',
        'address',
        'note',
      ],
    },
    {
      name: 'edit',
      attributes: [
        'firstname',
        'lastname',
        'email',
        'web',
        'phone',
        'mobile',
        'fax',
        'organization_id',
        'organization_ids',
        'department',
        'address',
        'note',
      ],
    },
    {
      name: 'invite_agent',
      attributes: ['firstname', 'lastname', 'email', 'role_ids', 'group_ids'],
    },
  ],
})
