# Developer Manual for Zammad

Welcome to the developer docs of Zammad. 👋 This is a work in progress, and you're encouraged to contribute and improve
it.

## Development Environment

- [How to set up a development environment](development_environment/how-to-set-up-a-development-environment.md)
- [Getting started](development_environment/getting-started.md)
- [Basic information](development_environment/basic-information.md)

## Standards & Best Practices

- [Code Style Guide](standards/code-style-guide.md)
- [How to design tests](standards/how-to-design-tests.md)
- [How to add a database migration](standards/how-to-add-a-database-migration.md)
- [How to add an SVG Icon](standards/how-to-add-an-svg-icon.md)
- [How to handle localization & translations](standards/how-to-handle-localization.md)
- [How to rebuild the chat](standards/how-to-rebuild-the-chat.md)
- [How to use forms](standards/how-to-use-forms.md)

## Cookbook / Recipes

- [How to calculate required database connection count](cookbook/how-to-calculate-required-db-connection-count.md)
- [How to diagnose email bugs](cookbook/how-to-diagnose-email-bugs.md)
- [How to Debug Zammad Processes](cookbook/how-to-debug-zammad-processes.md)
- [How to use debuggers with Zammad](cookbook/how-to-use-debuggers.md)
- [How to test with RSpec / Capybara](cookbook/how-to-test-with-rspec-and-capybara.md)
- [How to test with QUnit](cookbook/how-to-test-with-qunit.md)
- [How to test with Vitest and Cypress](cookbook/how-to-test-with-vitest-and-cypress.md)
- [How to test the development version of Zammad via Docker](cookbook/how-to-test-develop-with-docker.md)
- [How to setup LDAP integration](cookbook/how-to-setup-ldap-integration.md)
- [How to setup PGP integration](cookbook/how-to-setup-pgp-integration.md)
- [How to setup S/MIME integration](cookbook/how-to-setup-smime-integration.md)

## How to Contribute

We live & love Open Source and therefore we encourage our community to contribute to the development of Zammad.

You could simply to do this by fixing a reported [issue](https://github.com/zammad/zammad/issues) or by implementing an
enhancement.

For the workflow how to contribute, please check
[the official GitHub documentation](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request).
